/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.bean;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantKeyValue;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponseStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class AssistantResponse {
    private AssistantResponseStatus status = AssistantResponseStatus.OK;
    private String error = null;
    private String errorTitle = null;
    private String nextActionId = null;
    private Map<String, Object> fieldValues = new HashMap<String, Object>();

    public AssistantResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(AssistantResponseStatus status) {
        this.status = status;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.setError(error, null);
    }

    public void setError(String error, String errorTitle) {
        this.status = AssistantResponseStatus.ERROR;
        this.error = error;
        this.errorTitle = errorTitle;
    }

    public String getNextActionId() {
        return this.nextActionId;
    }

    public void setNextActionId(String nextActionId) {
        this.nextActionId = nextActionId;
    }

    public void addFieldData(String key, AssistantKeyValue[] values) {
        this.fieldValues.put(key, values);
    }

    public void addFieldData(String key, List<KeyValue> items, int defaultSelectedIndex) {
        if (items != null) {
            JSONArray jsonArray = new JSONArray();
            for (int index = 0; index < items.size(); ++index) {
                KeyValue keyValue = items.get(index);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("key", (Object)keyValue.getKey());
                jsonObject.put("value", (Object)keyValue.getValue());
                if (index == defaultSelectedIndex) {
                    jsonObject.put("selected", (Object)"true");
                }
                jsonArray.put((Object)jsonObject);
            }
            this.fieldValues.put(key, jsonArray);
        }
    }

    public void addFieldData(String key, LocalDate value) {
        this.addFieldData(key, TimeUtils.format((LocalDate)value, (String)"yyyy-MM-dd"));
    }

    public void addFieldData(String key, Period value) {
        if (value != null) {
            JSONObject json = new JSONObject();
            if (value.getLocalDateFrom() != null) {
                json.put("dateFrom", (Object)TimeUtils.format((LocalDate)value.getLocalDateFrom(), (String)"yyyy-MM-dd"));
            }
            if (value.getLocalDateTo() != null) {
                json.put("dateTo", (Object)TimeUtils.format((LocalDate)value.getLocalDateTo(), (String)"yyyy-MM-dd"));
            }
            this.addFieldData(key, json);
        }
    }

    public void addFieldData(String key, String value) {
        this.fieldValues.put(key, value);
    }

    public void addFieldData(String key, boolean value) {
        this.fieldValues.put(key, String.valueOf(value));
    }

    public void addFieldData(String key, Set<Integer> contractIds, String title) {
        JSONObject json = new JSONObject();
        json.put("contractIds", (Object)Utils.toString(contractIds));
        json.put("title", (Object)title);
        this.fieldValues.put(key, json);
    }

    public void addFieldData(String key, EntityAttrAddress entityAttrAddress) {
        if (entityAttrAddress != null) {
            JSONObject json = new JSONObject();
            json.put("houseId", entityAttrAddress.getHouseId());
            json.put("flat", (Object)entityAttrAddress.getFlat());
            json.put("room", (Object)entityAttrAddress.getRoom());
            json.put("pod", entityAttrAddress.getPod());
            json.put("floor", entityAttrAddress.getFloor());
            json.put("title", (Object)entityAttrAddress.getTitle());
            this.fieldValues.put(key, json);
        }
    }

    public void addFieldData(String key, JSONObject value) {
        this.fieldValues.put(key, value);
    }

    public Map<String, Object> getFieldValues() {
        return this.fieldValues;
    }

    public void setErrorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }
}

