/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.model.ParameterTableModel;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantActionLibraryTab;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ParameterEditor;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantFieldType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class EditorPanel
extends BGUPanel {
    private JSONObject config = null;
    private JTabbedPane tabbedPane = null;
    private JTextArea actionComment = null;
    private ParameterEditor parameterEditor = null;
    private AssistantAction assistantAction = null;
    private final BGTextField titleField = new BGTextField(30);
    private final BGTextField actionIdField = new BGTextField(30);
    private final FieldTableModel tableModel = new FieldTableModel();
    private final BGButtonPanelOkCancel buttonPanel = new BGButtonPanelOkCancel();
    private final DynamicClassChooser chooser = new DynamicClassChooser(false, 2);
    private final AssistantActionLibraryTab parent;

    public EditorPanel(AssistantActionLibraryTab parent) {
        super((LayoutManager)new GridBagLayout());
        this.parent = parent;
    }

    protected void jbInit() throws Exception {
        this.buttonPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("ok")) {
                this.doSave();
            } else if (actionCommand.equals("cancel")) {
                this.assistantAction = null;
                this.setVisible(false);
            }
            this.parameterEditor.table.clearSelection();
            this.parent.setEnabled(true);
        });
        this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.add(this.getActionIdPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.add(this.getFieldPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getClassDialogPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getActionIdPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("Action ID (#): "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.actionIdField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)this.titleField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFieldPanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ParameterRow parameterRow = (ParameterRow)EditorPanel.this.tableModel.getSelectedRow();
                if (mouseEvent.getClickCount() == 2 && parameterRow != null) {
                    EditorPanel.this.doParameterCommand(BGDialogToolBar.ButtonData.EDIT_ITEM.getName());
                }
            }
        });
        BGDialogToolBar dialogToolBar = new BGDialogToolBar();
        dialogToolBar.setDefaultButtons(e -> this.doParameterCommand(e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.UP_ITEM, BGDialogToolBar.ButtonData.DOWN_ITEM});
        dialogToolBar.setOrientation(0);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(new Dimension(100, 300));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u044f: "), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)dialogToolBar, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, gridy, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getClassDialogPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.tabbedPane.add((Component)this.getClassPanel(), "\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430");
        JPanel panelWithParametersTable = new JPanel(new GridLayout(1, 2, 15, 5));
        panelWithParametersTable.setMinimumSize(new Dimension(100, 300));
        panelWithParametersTable.add(this.tabbedPane);
        panelWithParametersTable.add(this.getParamDialogPanel());
        return panelWithParametersTable;
    }

    private JPanel getCommentPanel() {
        this.actionComment = new JTextArea();
        this.actionComment.setMargin(new Insets(3, 3, 3, 3));
        this.actionComment.setWrapStyleWord(true);
        this.actionComment.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.actionComment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamDialogPanel() {
        this.parameterEditor = new ParameterEditor(this.getConfig().optJSONArray("options"));
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: "), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.parameterEditor, new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JSONObject getConfig() {
        if (this.config == null) {
            try {
                InputStream inputStream = EditorPanel.class.getResourceAsStream("config.json");
                this.config = new JSONObject(new String(Utils.readByBlock((InputStream)inputStream), StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        return this.config;
    }

    private void doSave() {
        if (Utils.isBlankString((String)this.actionIdField.getText())) {
            ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 ActionId!");
            return;
        }
        if (Utils.isBlankString((String)this.titleField.getText())) {
            ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u0441\u0442\u0435\u0440\u0430!");
            return;
        }
        this.assistantAction.setTitle(this.titleField.getText());
        this.assistantAction.setActionId(this.actionIdField.getText());
        this.assistantAction.setActionClass(this.chooser.getSelectedClass());
        JSONObject config = new JSONObject();
        JSONArray params = new JSONArray();
        for (ParameterRow parameterRow : this.tableModel.getRows()) {
            JSONObject param = new JSONObject();
            param.put("key", (Object)parameterRow.key);
            param.put("type", (Object)parameterRow.type);
            param.put("title", (Object)parameterRow.title);
            param.put("value", (Object)parameterRow.value);
            param.put("comment", (Object)parameterRow.comment);
            param.put("options", (Object)parameterRow.data);
            params.put((Object)param);
        }
        config.put("params", (Object)params);
        config.put("options", (Object)this.parameterEditor.getOptions());
        config.put("comment", (Object)this.actionComment.getText());
        this.assistantAction.setConfig(config.toString());
        this.setVisible(false);
    }

    private void doParameterCommand(String actionCommand) {
        ParameterRow parameterRow = (ParameterRow)this.tableModel.getSelectedRow();
        switch (BGDialogToolBar.ButtonData.of((String)actionCommand)) {
            case NEW_ITEM: {
                new FieldEditorDialog("\u041d\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435", new ParameterRow(), true).open();
                break;
            }
            case EDIT_ITEM: {
                new FieldEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u043b\u044f", parameterRow, false).open();
                break;
            }
            case DELETE_ITEM: {
                if (parameterRow == null) break;
                this.tableModel.deleteSelectedRows();
                this.tableModel.fireTableDataChanged();
                break;
            }
            case UP_ITEM: {
                if (parameterRow == null) break;
                this.tableModel.upSelectedRow();
                this.tableModel.fireTableDataChanged();
                break;
            }
            case DOWN_ITEM: {
                if (parameterRow == null) break;
                this.tableModel.downSelectedRow();
                this.tableModel.fireTableDataChanged();
                break;
            }
        }
    }

    public AssistantAction getAssistantAction() {
        return this.assistantAction;
    }

    public void setAssistantAction(AssistantAction assistantAction, String ifaceName, String superclassName) {
        this.assistantAction = assistantAction;
        this.tabbedPane.setSelectedIndex(0);
        this.titleField.setText(assistantAction.getTitle());
        this.actionIdField.setText(assistantAction.getActionId());
        this.chooser.setNewClass(false);
        this.chooser.setIfaceName(ifaceName);
        this.chooser.setSuperclassName(superclassName);
        this.chooser.performAction("refresh");
        this.chooser.setSelectedItem(assistantAction.getActionClass());
        this.tableModel.deleteRows();
        String configStr = assistantAction.getConfig();
        JSONObject config = new JSONObject(Utils.isEmptyString((String)configStr) ? "{}" : configStr);
        JSONArray params = config.optJSONArray("params");
        if (params != null) {
            int size = params.length();
            for (int index = 0; index < size; ++index) {
                JSONObject param = params.getJSONObject(index);
                ParameterRow parameterRow = new ParameterRow();
                parameterRow.setKey(param.optString("key"));
                parameterRow.setTitle(param.optString("title"));
                parameterRow.setType(param.optString("type"));
                parameterRow.setValue(param.optString("value"));
                parameterRow.setComment(param.optString("comment"));
                parameterRow.setData(Optional.ofNullable(param.optJSONObject("options")).orElse(new JSONObject()));
                this.tableModel.addRow(parameterRow);
            }
        }
        this.actionComment.setText(config.optString("comment", ""));
        this.parameterEditor.setData(config.optJSONObject("options"));
    }

    private JPanel getClassPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new JLabel("\u0421\u043e\u0437\u0434\u0430\u0442\u044c/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.chooser, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 5), 0, 0));
        return panel;
    }

    private static class FieldTableModel
    extends BGTableModel<ParameterRow> {
        public FieldTableModel() {
            super(FieldTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 150, 150, 150, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 200, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class ParameterRow {
        private String key = null;
        private String title = null;
        private String type = null;
        private String value = null;
        private String comment = null;
        private JSONObject data = new JSONObject();

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public JSONObject getData() {
            return this.data;
        }

        public void setData(JSONObject data) {
            this.data = data;
        }
    }

    class FieldEditorDialog
    extends BGEditorDialog<ParameterRow> {
        JTabbedPane tabbedPane;
        BGTextField keyField;
        BGTextField titleField;
        BGTextField valueField;
        BGTextField commentField;
        BGUComboBox<KeyValue> typesComboBox;
        ParameterTableModel parameterTableModel;
        boolean modeCreate;

        public FieldEditorDialog(String title, ParameterRow data, boolean modeCreate) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.keyField = new BGTextField(15);
            this.titleField = new BGTextField(40);
            this.valueField = new BGTextField(40);
            this.commentField = new BGTextField(40);
            this.typesComboBox = new BGUComboBox();
            this.parameterTableModel = new ParameterTableModel();
            this.modeCreate = modeCreate;
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getBasePanel(), "\u041e\u0441\u043d\u043e\u0432\u043d\u044b\u0435");
            this.tabbedPane.add((Component)this.getParamPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 10, 0), 0, 0));
            String value = ((ParameterRow)this.data).getKey();
            this.keyField.setEditable(value == null);
            this.setBGTextFieldValue(this.keyField, value);
            this.setBGTextFieldValue(this.titleField, ((ParameterRow)this.data).getTitle());
            this.setBGTextFieldValue(this.valueField, ((ParameterRow)this.data).getValue());
            this.setBGTextFieldValue(this.commentField, ((ParameterRow)this.data).getComment());
            value = ((ParameterRow)this.data).getType();
            this.typesComboBox.setEnabled(value == null);
            this.typesComboBox.setData(Stream.of(AssistantFieldType.values()).map(a -> new KeyValue(a.getCode(), a.getTitle())).toList());
            this.typesComboBox.addItemListener(a -> {
                if (a.getStateChange() == 1) {
                    this.setFieldOptions(((KeyValue)a.getItem()).getKey());
                }
            });
            for (int index = 0; index < this.typesComboBox.getItemCount(); ++index) {
                KeyValue keyValue = (KeyValue)this.typesComboBox.getItemAt(index);
                if (!keyValue.getKey().equals(value)) continue;
                this.typesComboBox.setSelectedIndex(index);
                break;
            }
        }

        private void setFieldOptions(String type) {
            JSONArray fieldOptions = EditorPanel.this.getConfig().optJSONArray("fieldOptions");
            JSONArray fieldOption = new JSONArray();
            int len = fieldOptions.length();
            for (int index = 0; index < len; ++index) {
                JSONObject arrayItem = fieldOptions.getJSONObject(index);
                if (!type.equals(arrayItem.optString("type"))) continue;
                fieldOption = arrayItem.getJSONArray("options");
                break;
            }
            ArrayList data = new ArrayList();
            fieldOption.forEach(o -> {
                JSONObject json = (JSONObject)o;
                json.put("value", (Object)((ParameterRow)this.data).getData().optString(json.optString("key")));
                data.add(json);
            });
            this.parameterTableModel.setData(data);
        }

        private JPanel getBasePanel() {
            int gridy = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043b\u044e\u0447:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.keyField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.typesComboBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.valueField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.commentField, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getParamPanel() {
            BGUTable table = new BGUTable((TableModel)this.parameterTableModel){

                public TableCellRenderer getCellRenderer(int row, int column) {
                    JSONObject rowJson = FieldEditorDialog.this.parameterTableModel.getRow(row);
                    if (column == 1) {
                        String type = rowJson.optString("type");
                        if ("boolean".equals(type)) {
                            TableCellRenderer tableCellRenderer = this.getDefaultRenderer(Boolean.class);
                            ((JCheckBox)((Object)tableCellRenderer)).setHorizontalAlignment(0);
                            return tableCellRenderer;
                        }
                        if ("INTEGER".equals(type)) {
                            return this.getDefaultRenderer(Number.class);
                        }
                    }
                    return super.getCellRenderer(row, column);
                }

                public TableCellEditor getCellEditor(int row, int column) {
                    JSONObject rowJson = FieldEditorDialog.this.parameterTableModel.getRow(row);
                    String type = rowJson.optString("type");
                    if ("text".equals(type)) {
                        return this.getDefaultEditor(String.class);
                    }
                    if ("INTEGER".equals(type)) {
                        return this.getDefaultEditor(Number.class);
                    }
                    return super.getCellEditor(row, column);
                }
            };
            table.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)600, (int)150), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private void setBGTextFieldValue(BGTextField field, String value) {
            field.setHorizontalAlignment(2);
            field.setText(value != null ? value : "");
        }

        public boolean doApply() throws Exception {
            String key = this.keyField.getText().trim();
            if (Utils.isBlankString((String)key)) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430!");
                return false;
            }
            if (this.modeCreate && EditorPanel.this.tableModel.getRows().stream().anyMatch(a -> a.getKey().equals(key))) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u043b\u044e\u0447 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u043c!");
                return false;
            }
            if (this.typesComboBox.getSelectedIndex() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f!");
                return false;
            }
            ((ParameterRow)this.data).setType(((KeyValue)this.typesComboBox.getSelectedItem()).getKey());
            ((ParameterRow)this.data).setTitle(this.titleField.getText());
            ((ParameterRow)this.data).setValue(this.valueField.getText());
            ((ParameterRow)this.data).setComment(this.commentField.getText());
            this.parameterTableModel.getRows().forEach(a -> ((ParameterRow)this.data).getData().put(a.optString("key"), (Object)a.optString("value")));
            if (this.keyField.isEditable()) {
                ((ParameterRow)this.data).setKey(this.keyField.getText());
                EditorPanel.this.tableModel.addRow((ParameterRow)this.data);
            }
            EditorPanel.this.tableModel.fireTableDataChanged();
            EditorPanel.this.tableModel.setSelectedRow((ParameterRow)this.data);
            return true;
        }
    }
}

