/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import bitel.billing.server.call.bean.Login;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager;
import ru.bitel.bgbilling.modules.dialup.server.bean.IpAddr;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class LoginIpManager {
    private Connection con;
    private String tableName;
    private String userLoginTable;
    private int mid;

    public LoginIpManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "radius_pair_ip_" + mid;
        this.userLoginTable = "user_login_" + mid;
        this.mid = mid;
    }

    public List<Long> getLoginIps(int lid, String realm) {
        HashMap<String, List<Long>> ips = this.getLoginsIps(lid);
        List<Long> result = ips.get(realm);
        if (result == null) {
            result = new ArrayList<Long>();
        }
        return result;
    }

    public HashMap<String, List<Long>> getLoginsIps(int lid) {
        HashMap<String, List<Long>> ips = new HashMap<String, List<Long>>(8);
        try {
            String query = "SELECT ip, realm FROM " + this.tableName + " WHERE id=? AND (date1 IS NULL OR date1<=CURDATE()) AND (date2 IS NULL OR date2>=CURDATE())";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, lid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                List<Long> result;
                String ipRealm = rs.getString(2).trim().toLowerCase();
                if (ipRealm.length() == 0) {
                    ipRealm = "default";
                }
                if ((result = ips.get(ipRealm)) == null) {
                    result = new ArrayList<Long>(6);
                    ips.put(ipRealm, result);
                }
                result.add(rs.getLong(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ips;
    }

    public List<IpAddr> getAllLoginsIps(int lid) {
        ArrayList<IpAddr> result = new ArrayList<IpAddr>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, lid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String realm = rs.getString("realm").trim().toLowerCase();
                long ip = rs.getLong("ip");
                Date date1 = rs.getDate("date1");
                Date date2 = rs.getDate("date2");
                IpAddr addr = new IpAddr(ip, realm, date1, date2);
                result.add(addr);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static List<IpAddr> getIpAddrList(String values) throws BGException {
        ArrayList<IpAddr> ipList = new ArrayList<IpAddr>();
        for (String token : Utils.toList((String)values)) {
            IpAddr addr = new IpAddr(token);
            ipList.add(addr);
        }
        return ipList;
    }

    public void checkIpAddrList(int lid, List<IpAddr> ipAddrList) throws BGException {
        try {
            Login login = new DialUpLoginManager(this.con, this.mid).getLoginById(lid);
            String query = "SELECT contract.title, login.id FROM " + this.tableName + " AS addr LEFT JOIN " + this.userLoginTable + " AS login ON login.id=addr.id LEFT JOIN contract ON contract.id=login.cid WHERE addr.id!=? AND addr.ip=? AND (addr.date1 IS NULL OR ? IS NULL OR addr.date1<=?) AND (addr.date2 IS NULL OR ? IS NULL OR ?<=addr.date2) AND (login.date1 IS NULL OR ? IS NULL OR login.date1<=?) AND (login.date2 IS NULL OR ? IS NULL OR ?<=login.date2) ";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, lid);
            for (IpAddr addr : ipAddrList) {
                ps.setLong(2, addr.ipAddr);
                ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date2));
                ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date2));
                ps.setDate(5, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date1));
                ps.setDate(6, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date1));
                ps.setDate(7, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2()));
                ps.setDate(8, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2()));
                ps.setDate(9, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1()));
                ps.setDate(10, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1()));
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    throw new BGException("IP \u0430\u0434\u0440\u0435\u0441 " + IPUtils.convertLongIpToString((long)addr.ipAddr) + " \u0443\u0436\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043b\u043e\u0433\u0438\u043d\u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + rs.getString(1));
                }
                rs.close();
            }
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void checkIpAddrList(int lid, String values) throws BGException {
        List<IpAddr> ipList = LoginIpManager.getIpAddrList(values);
        this.checkIpAddrList(lid, ipList);
    }

    public void updateLoginIps(int lid, String values) throws BGException {
        List<IpAddr> ipList = LoginIpManager.getIpAddrList(values);
        this.checkIpAddrList(lid, ipList);
        this.updateLoginIps(lid, ipList);
    }

    public void updateLoginIps(int lid, List<IpAddr> ipList) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, lid);
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (id, ip, realm, date1, date2) VALUES (?, ?, ?, ?, ?)");
            ps.setInt(1, lid);
            for (IpAddr addr : ipList) {
                ps.setLong(2, addr.ipAddr);
                ps.setString(3, addr.realm);
                ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date1));
                ps.setDate(5, TimeUtils.convertDateToSqlDate((java.util.Date)addr.date2));
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public Map<Integer, List<IpAddr>> getRealtimeAddressMap() throws BGException {
        ConcurrentHashMap<Integer, List<IpAddr>> result = new ConcurrentHashMap<Integer, List<IpAddr>>();
        try {
            String query = "SELECT id, ip, realm, date1, date2 FROM " + this.tableName + " WHERE id>0 AND date2 IS NULL OR (date2>=CURDATE())";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int lid = rs.getInt(1);
                IpAddr addr = new IpAddr(rs.getLong(2), rs.getString(3), rs.getDate(4), rs.getDate(5));
                ArrayList<IpAddr> addrList = (ArrayList<IpAddr>)result.get(lid);
                if (addrList == null) {
                    addrList = new ArrayList<IpAddr>(2);
                    result.put(lid, addrList);
                }
                addrList.add(addr);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

