/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.hd.server.AgentAction;
import ru.bitel.bgbilling.modules.hd.server.AgentDriver;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingServer;
import ru.bitel.common.Preferences;

public class HostingAgentDriver
extends AgentDriver {
    private HostingServer server;

    public HostingAgentDriver(Preferences moduleSetup, HostingServer server) {
        super(moduleSetup);
        this.server = server;
    }

    @Override
    public void connect() throws Exception {
        this.connect(this.server.getAddr());
    }

    @Override
    public String getName() {
        return this.server.getAddr();
    }

    public void registerHosting(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("add_hosting");
        this.addRequestParam(req, "user", action.hostingUser);
        this.addRequestParam(req, "pswd", action.hostingPswd);
        this.addRequestParam(req, "type", action.hostingType);
        int pos = 0;
        for (String host : action.hostingHosts) {
            this.addRequestParam(req, "host" + pos++, host);
        }
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0445\u043e\u0441\u0442\u0438\u043d\u0433\u0430: " + resp);
        }
    }

    public void unregisterHosting(AgentAction action) throws Exception {
        StringBuilder req = this.getCommandTemplate("delete_hostng");
        this.addRequestParam(req, "user", action.hostingUser);
        String resp = this.sendCommand(req.toString());
        if (!resp.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0445\u043e\u0441\u0442\u0438\u043d\u0433\u0430: " + resp);
        }
    }
}

