/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ClientStatManager {
    private Connection con;
    private int mid;
    private int items = 0;
    private Map<Integer, String> valuesMap = new HashMap<Integer, String>();
    private SortedMap<Integer, String> labelsMap = new TreeMap<Integer, String>();
    private long valuesMax = 0L;
    private long valuesSum = 0L;

    public ClientStatManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void addStatInfo(Element el, int cid, String aids, String sids, int year, int month, int day) {
        try {
            if (sids == null || "".equals(sids)) {
                sids = "0";
            }
            if (aids != null && "".equals(aids)) {
                aids = null;
            }
            if (day < 0 || month < 0 || year < 0 || cid < 0) {
                return;
            }
            Element stat = XMLUtils.createElement((Element)el, (String)"stat");
            Element labels = XMLUtils.createElement((Element)el, (String)"labels");
            this.fillData(cid, aids, sids, year, month, day);
            labels.setAttribute("items", String.valueOf(this.items));
            for (Map.Entry<Integer, String> entry : this.valuesMap.entrySet()) {
                Element item = XMLUtils.createElement((Element)stat, (String)"item");
                item.setAttribute("id", String.valueOf(entry.getKey()));
                item.setAttribute("value", entry.getValue());
            }
            for (Map.Entry<Integer, String> entry : this.labelsMap.entrySet()) {
                Element label = XMLUtils.createElement((Element)labels, (String)"label");
                label.setAttribute("id", String.valueOf(entry.getKey()));
                label.setAttribute("text", entry.getValue());
            }
            stat.setAttribute("max", String.valueOf(this.valuesMax));
            stat.setAttribute("all", String.valueOf(this.valuesSum));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addStatInfo(Map<String, Object> dataMap, int cid, String aids, String sids, int year, int month, int day) {
        try {
            if (sids == null || "".equals(sids)) {
                sids = "0";
            }
            if (aids != null && "".equals(aids)) {
                aids = null;
            }
            if (day < 0 || month < 0 || year < 0 || cid < 0) {
                return;
            }
            HashMap<String, String> stat = new HashMap<String, String>();
            this.fillData(cid, aids, sids, year, month, day);
            dataMap.put("items", String.valueOf(this.items));
            dataMap.put("valuesMap", this.valuesMap);
            dataMap.put("labelsMap", this.labelsMap);
            stat.put("max", String.valueOf(this.valuesMax));
            stat.put("all", String.valueOf(this.valuesSum));
            dataMap.put("stat", stat);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fillData(int cid, String aids, String sids, int year, int month, int day) throws SQLException {
        block14: {
            StringBuffer whereFilter;
            String tableName;
            ResultSet rs;
            PreparedStatement ps;
            block15: {
                String mon;
                block13: {
                    this.valuesMap.clear();
                    this.labelsMap.clear();
                    if (sids == null || "".equals(sids)) {
                        sids = "0";
                    }
                    if (aids != null && "".equals(aids)) {
                        aids = null;
                    }
                    if (day < 0 || month < 0 || year < 0 || cid < 0) {
                        return;
                    }
                    this.valuesMax = 0L;
                    this.valuesSum = 0L;
                    ps = null;
                    rs = null;
                    mon = month < 10 ? "0" + month : "" + month;
                    tableName = null;
                    whereFilter = new StringBuffer();
                    whereFilter.append(" AND sid in ( ");
                    whereFilter.append(sids);
                    whereFilter.append(" )");
                    if (aids != null) {
                        whereFilter.append(" AND aid IN ( ");
                        whereFilter.append(aids);
                        whereFilter.append(" ) ");
                    }
                    if (month <= 0 || day <= 0) break block13;
                    this.addItems(0, 23, true);
                    tableName = "ipn_contract_data_" + this.mid + "_" + year + mon;
                    GregorianCalendar dayDate = new GregorianCalendar();
                    dayDate.set(1, year);
                    dayDate.set(2, month - 1);
                    dayDate.set(5, day);
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT hh, sum(amount) FROM ");
                    query.append(tableName);
                    query.append(" WHERE dt=? ");
                    query.append(" AND cid=");
                    query.append(cid);
                    query.append(whereFilter.toString());
                    query.append(" GROUP BY hh");
                    if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) break block14;
                    ps = this.con.prepareStatement(query.toString());
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)dayDate));
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        long value = rs.getLong(2);
                        this.valuesSum += value;
                        if (value > this.valuesMax) {
                            this.valuesMax = value;
                        }
                        this.valuesMap.put(rs.getInt(1) + 1, String.valueOf(value));
                    }
                    break block14;
                }
                if (month <= 0 || day != 0) break block15;
                tableName = "ipn_contract_data_" + this.mid + "_" + year + mon;
                GregorianCalendar date = new GregorianCalendar(year, month - 1, 1);
                ((Calendar)date).add(2, 1);
                ((Calendar)date).add(5, -1);
                int daysInMonth = date.get(5);
                this.addItems(1, daysInMonth, false);
                StringBuilder query = new StringBuilder();
                query.append("SELECT dayofmonth(dt) AS dm, sum(amount) FROM ");
                query.append(tableName);
                query.append(" WHERE cid=");
                query.append(cid);
                query.append(whereFilter.toString());
                query.append(" GROUP BY dm");
                if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) break block14;
                ps = this.con.prepareStatement(query.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    long value = rs.getLong(2);
                    this.valuesSum += value;
                    if (value > this.valuesMax) {
                        this.valuesMax = value;
                    }
                    this.valuesMap.put(Integer.valueOf(rs.getString(1)), String.valueOf(value));
                }
                break block14;
            }
            if (month == 0 && day == 0) {
                this.addItems(1, 12, false);
                GregorianCalendar now = new GregorianCalendar();
                GregorianCalendar date1 = new GregorianCalendar(year, 0, 1);
                GregorianCalendar date2 = new GregorianCalendar(year, 11, 2);
                while (date1.before(date2) && date1.before(now)) {
                    int mm = date1.get(2) + 1;
                    tableName = "ipn_contract_data_" + this.mid + "_" + year + (mm < 10 ? "0" + mm : "" + mm);
                    if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                        StringBuilder query = new StringBuilder();
                        query.append("SELECT sum(amount) FROM ");
                        query.append(tableName);
                        query.append(" WHERE cid=");
                        query.append(cid);
                        query.append(whereFilter.toString());
                        ps = this.con.prepareStatement(query.toString());
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            long value = rs.getLong(1);
                            this.valuesSum += value;
                            if (value > this.valuesMax) {
                                this.valuesMax = value;
                            }
                            this.valuesMap.put(mm, String.valueOf(value));
                        }
                    }
                    ((Calendar)date1).add(2, 1);
                }
            }
        }
    }

    public SortedMap<Integer, Long> getStatData() {
        TreeMap<Integer, Long> result = new TreeMap<Integer, Long>();
        for (Map.Entry<Integer, String> entry : this.labelsMap.entrySet()) {
            String value = this.valuesMap.get(entry.getKey());
            if (value == null) {
                value = "0";
            }
            result.put(entry.getKey(), Long.valueOf(value));
        }
        return result;
    }

    private final void addItems(int from, int to, boolean addId) {
        this.items = to - from + 1;
        for (int i = from; i <= to; ++i) {
            this.labelsMap.put(addId ? i + 1 : i, i < 10 ? "0" + i : "" + i);
        }
    }
}

