/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ConverterSchedulerTaskOldPackages
extends AbstractBGConverter {
    private final String NEED_CONVERT_KEY = "scheduler_converter_was_runned";
    private final Map<String, String> packagesPaths = new HashMap<String, String>();

    @Override
    public void runConverter(Connection connection) {
        boolean alreadyBeenRunned = Utils.maskBlank((String)ServerUtils.getSetupValue(connection, "scheduler_converter_was_runned"), (String)"0").equals("1");
        if (alreadyBeenRunned) {
            return;
        }
        this.getLogger().info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0451\u0440 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u043f\u0443\u0442\u0435\u0439 \u043a\u043b\u0430\u0441\u0441\u043e\u0432-\u0437\u0430\u0434\u0430\u0447 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430 \u043d\u0430 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435");
        this.initPackagesPaths();
        try {
            this.renamePackagePathsForTable(connection, "scheduled_tasks");
            this.renamePackagePathsForTable(connection, "scheduled_class");
            this.renamePackagePathsForDependentTasks(connection);
            ServerUtils.setSetupValue(connection, "scheduler_converter_was_runned", "1");
            this.getLogger().info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
        }
        catch (Exception ex) {
            this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0440\u044b\u0445 \u043f\u0443\u0442\u0435\u0439 \u043a\u043b\u0430\u0441\u0441\u043e\u0432-\u0437\u0430\u0434\u0430\u0447 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430", ex);
        }
    }

    private void renamePackagePathsForTable(Connection connection, String tableName) throws SQLException {
        String query = "UPDATE " + tableName + " SET class=? WHERE class=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            for (String oldPath : this.packagesPaths.keySet()) {
                ps.setString(1, this.packagesPaths.get(oldPath));
                ps.setString(2, oldPath);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    private void renamePackagePathsForDependentTasks(Connection connection) throws Exception {
        SchedulerManager schedulerManager = new SchedulerManager(connection);
        for (LightweightTaskData taskData : schedulerManager.getTaskList(null)) {
            List<DependentTask> dependentTasks = taskData.getDependentTasks();
            if (!Utils.notEmptyCollection(dependentTasks)) continue;
            for (DependentTask dependentTask : dependentTasks) {
                String newClassName = this.packagesPaths.get(dependentTask.getClassName());
                if (!Utils.notBlankString((String)newClassName)) continue;
                dependentTask.setClassName(newClassName);
                schedulerManager.updateTask(taskData);
            }
        }
    }

    private void initPackagesPaths() {
        this.packagesPaths.put("bitel.billing.server.contract.CleanerContract", "ru.bitel.bgbilling.kernel.contract.task.ContractCleaner");
        this.packagesPaths.put("bitel.billing.server.load.TaskGenerator", "ru.bitel.bgbilling.kernel.task.server.task.TaskGenerator");
        this.packagesPaths.put("bitel.billing.server.contract.LimitRestorer", "ru.bitel.bgbilling.kernel.contract.balance.server.task.LimitRestorer");
        this.packagesPaths.put("bitel.billing.server.contract.DebtMailSender", "ru.bitel.bgbilling.kernel.contract.balance.server.task.DebtMailSender");
        this.packagesPaths.put("bitel.billing.server.contract.ContractStatusSetter", "ru.bitel.bgbilling.kernel.contract.status.server.task.ContractStatusSetter");
        this.packagesPaths.put("bitel.billing.server.ticket.CheckCancelTask", "ru.bitel.bgbilling.modules.ticket.server.CheckCancelTask");
        this.packagesPaths.put("bitel.billing.server.ipn.LogCalculator", "ru.bitel.bgbilling.modules.ipn.server.LogCalculator");
        this.packagesPaths.put("bitel.billing.server.ipn.IPNTestGates", "ru.bitel.bgbilling.modules.ipn.server.IPNTestGates");
        this.packagesPaths.put("bitel.billing.server.cerbercrypt.Calculator", "ru.bitel.bgbilling.modules.cerbercrypt.server.task.Calculator");
        this.packagesPaths.put("bitel.billing.server.cerbercrypt.Synchronizer", "ru.bitel.bgbilling.modules.cerbercrypt.server.task.Synchronizer");
        this.packagesPaths.put("bitel.billing.server.cerbercrypt.Locker", "ru.bitel.bgbilling.modules.cerbercrypt.server.task.Locker");
        this.packagesPaths.put("bitel.billing.server.cerbercrypt.CardContractSetter", "ru.bitel.bgbilling.modules.cerbercrypt.server.task.CardContractSetter");
        this.packagesPaths.put("bitel.billing.server.cerbercrypt.StatusSetter", "ru.bitel.bgbilling.modules.cerbercrypt.server.task.StatusSetter");
        this.packagesPaths.put("bitel.billing.server.ipn.MaxCalculator", "ru.bitel.bgbilling.modules.ipn.server.MaxCalculator");
        this.packagesPaths.put("bitel.billing.server.dialup.MaxCalculator", "ru.bitel.bgbilling.modules.dialup.server.MaxCalculator");
        this.packagesPaths.put("bitel.billing.server.phone.BalanceSetter", "ru.bitel.bgbilling.modules.voiceip.server.task.BalanceSetter");
        this.packagesPaths.put("bitel.billing.server.phone.BalanceSetter", "ru.bitel.bgbilling.modules.phone.server.task.BalanceSetter");
        this.packagesPaths.put("bitel.billing.server.contract.CleanerContract", "ru.bitel.bgbilling.modules.rscm.server.task.RSCMCalculator");
        this.packagesPaths.put("bitel.billing.server.script.global.bean.GlobalScriptTimer", "ru.bitel.bgbilling.kernel.script.server.task.GlobalScriptTimer");
        this.packagesPaths.put("bitel.billing.server.load.TaskGenerator", "ru.bitel.bgbilling.kernel.task.server.task.TaskGenerator");
    }
}

