/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarValue;
import ru.bitel.bgbilling.kernel.tariff.common.event.TariffVarModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffLabelManager;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarValueDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.common.service.TariffService")
public class TariffServiceImpl
extends AbstractService
implements TariffService {
    private TariffVarValueDao tariffVarValueDao;

    @PostConstruct
    private void init() {
        this.tariffVarValueDao = new TariffVarValueDao(this.getConnection());
    }

    @Override
    public SearchResult<TariffPlan> searchTariffPlans(List<Integer> labelIds, List<Integer> moduleIds, int showUsed, Page page) throws Exception {
        SearchResult searchResult = new SearchResult().setPage(page);
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            tariffPlanDao.searchTariffPlans((SearchResult<TariffPlan>)searchResult, showUsed, moduleIds, labelIds, "");
        }
        return searchResult;
    }

    @Override
    public List<TariffPlan> tariffPlanList(List<Integer> contractLabelIds, Integer personType, String title) throws Exception {
        if ((contractLabelIds == null || contractLabelIds.isEmpty()) && (personType == null || personType < 0) && Utils.isEmptyString((String)title)) {
            return this.context.newDirectory(TariffPlan.class, 0).list();
        }
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            List<TariffPlan> list = tariffPlanDao.getTariffPlanList(0, contractLabelIds, personType, title);
            return list;
        }
    }

    @Override
    public List<IdTitle> tariffPlanTitles() throws Exception {
        return this.context.getDirectory(TariffPlan.class, 0).list().stream().map(IdTitle::toIdTitle).toList();
    }

    @Override
    public TariffPlan tariffPlanGet(int id) throws Exception {
        return this.context.getDirectory(TariffPlan.class, 0).get(id);
    }

    @Override
    public void tariffPlanDelete(int id) throws Exception {
        this.context.newDirectory(TariffPlan.class, 0).delete(id);
    }

    @Override
    public int tariffPlanUpdate(TariffPlan tariffPlan) throws Exception {
        this.context.getDirectory(TariffPlan.class, 0).update(tariffPlan);
        return tariffPlan.getId();
    }

    @Override
    public TariffGroup tariffGroupGet(int id) throws Exception {
        return this.context.getDirectory(TariffGroup.class, 0).get(id);
    }

    @Override
    public void tariffGroupDelete(int id) throws Exception {
        this.context.getDirectory(TariffGroup.class, 0).delete(id);
    }

    @Override
    public int tariffGroupUpdate(TariffGroup tariffGroup) throws Exception {
        this.context.newDirectory(TariffGroup.class, 0).update(tariffGroup);
        return tariffGroup.getId();
    }

    @Override
    public List<TariffGroup> tariffGroupList() throws Exception {
        return this.context.newDirectory(TariffGroup.class, 0).list();
    }

    @Override
    public List<TariffVar> tariffVars(TariffVarType tariffVarType, List<Integer> tariffPlanIds) throws Exception {
        return new TariffVarDao(this.getConnection()).list(tariffVarType, tariffPlanIds);
    }

    @Override
    public TariffVar tariffVarGet(int tariffVarId) throws Exception {
        return (TariffVar)new TariffVarDao(this.getConnection()).get(tariffVarId);
    }

    @Override
    public int tariffVarUpdate(TariffVar tariffVar) throws Exception {
        int tariffVarId = new TariffVarDao(this.getConnection()).updateTariffVar(tariffVar);
        EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarId));
        return tariffVarId;
    }

    @Override
    public int tariffVarDelete(int tariffVarId) throws Exception {
        this.tariffVarValueDao.deleteTariffVarValues(tariffVarId);
        int result = new TariffVarDao(this.getConnection()).delete(tariffVarId);
        EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarId));
        return result;
    }

    @Override
    public List<IdTitle> tariffVarListItems(int moduleId, String varTypeCode) throws Exception {
        Map<String, Object> resultMap;
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if ("inet_option".equals(varTypeCode) && !(resultMap = EventProcessor.getInstance().doCrossComponentQuery(null, moduleId, "tariffVarListOptionItems", moduleId)).isEmpty()) {
            resultMap.values().forEach(a -> result.addAll((List)a));
        }
        return result;
    }

    @Override
    public SearchResult<TariffVarValue> tariffVarValues(int tariffVarId, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        this.tariffVarValueDao.searchTariffVarValue((SearchResult<TariffVarValue>)searchResult, tariffVarId);
        return searchResult;
    }

    @Override
    public void tariffVarValueSet(TariffVarValue tariffVarValue) throws Exception {
        this.tariffVarValueDao.update(tariffVarValue);
        EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarValue.getTariffVarId()));
    }

    @Override
    public int tariffVarValueDelete(TariffVarValue tariffVarValue) throws Exception {
        int result = this.tariffVarValueDao.deleteTariffVarValue(tariffVarValue);
        EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarValue.getTariffVarId()));
        return result;
    }

    @Override
    public List<TariffLabelItem> getTariffLabelTreeItemList(int tariffPlanId) throws Exception {
        TariffLabelManager tariffLabelManager = new TariffLabelManager(this.getConnection());
        List<TariffLabelItem> tariffLabelItems = tariffLabelManager.getTariffLabelItemList();
        if (tariffPlanId > 0) {
            Set<Integer> tariffLabelSet = tariffLabelManager.getTariffLabelIds(tariffPlanId);
            for (TariffLabelItem tariffLabelItem : tariffLabelItems) {
                tariffLabelItem.setSelected(tariffLabelSet.contains(tariffLabelItem.getId()));
            }
        }
        return tariffLabelItems;
    }

    @Override
    public void setTariffLabelTreeItemList(int tariffPlanId, List<TariffLabelItem> items) throws Exception {
        HashSet<Integer> labelIds = new HashSet<Integer>();
        if (items != null) {
            for (TariffLabelItem tariffLabelItem : items) {
                labelIds.add(tariffLabelItem.getId());
            }
        }
        new TariffLabelManager(this.getConnection()).setTariffLabelIds(tariffPlanId, labelIds);
    }

    @Override
    public Set<Integer> getTariffLabelIds(int tariffPlanId) throws Exception {
        return new TariffLabelManager(this.getConnection()).getTariffLabelIds(tariffPlanId);
    }

    @Override
    public int updateTariffLabelTreeItem(TariffLabelItem tariffLabelItem) throws Exception {
        new TariffLabelManager(this.getConnection()).updateTariffLabelTreeItem(tariffLabelItem);
        return tariffLabelItem != null ? tariffLabelItem.getId() : -1;
    }

    @Override
    public void removeTariffLabelTreeItem(int tariffLabelItemId) throws Exception {
        new TariffLabelManager(this.getConnection()).removeTariffLabelItem(tariffLabelItemId);
    }

    @Override
    public List<TariffPlan> getTariffListByLabelId(int labelId) throws Exception {
        Set<Integer> tariffIds = new TariffLabelManager(this.getConnection()).getTariffIdsByLabelId(labelId);
        if (tariffIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TariffPlan> tariffs = new ArrayList<TariffPlan>();
        TariffService tariffService = this.context.getService(TariffService.class, 0);
        for (Integer id : tariffIds) {
            tariffs.add(tariffService.tariffPlanGet(id));
        }
        return tariffs;
    }
}

