/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentInfo;
import ru.bitel.common.Utils;

public class PaymentInfoDao
extends AbstractIdDao<PaymentInfo> {
    public PaymentInfoDao(Connection con) {
        super(con, -1, "payment_info");
    }

    @Override
    protected PaymentInfo getFromRS(ResultSet rs) throws SQLException {
        PaymentInfo paymentInfo = new PaymentInfo(rs.getInt("id"), rs.getInt("payment_id"));
        HashMap<String, String> info = new HashMap<String, String>();
        while (rs.next()) {
            info.put(rs.getString("key"), rs.getString("value"));
        }
        paymentInfo.setInfo(info);
        return paymentInfo;
    }

    @Override
    protected void updateImpl(PaymentInfo paymentInfo) throws SQLException {
        String querySet = "payment_id=?, `key`=?, value=?";
        try (PreparedStatement ps = this.prepareStatement(paymentInfo, querySet);){
            int paymentId = paymentInfo.getPaymentId();
            Map<String, String> info = paymentInfo.getInfo();
            for (String key : info.keySet()) {
                ps.setInt(1, paymentId);
                ps.setString(2, key);
                ps.setString(3, info.get(key));
                if (paymentInfo.getId() > 0) {
                    ps.setInt(4, paymentInfo.getId());
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public PaymentInfo getInfoByPaymentId(int paymentId) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE payment_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, paymentId);
            PaymentInfo paymentInfo = this.getFromRS(ps.executeQuery());
            return paymentInfo;
        }
    }

    public List<PaymentInfo> getInfoByPaymentIds(int ... paymentIds) throws SQLException {
        return this.getInfoByPaymentIds(Arrays.stream(paymentIds).boxed().collect(Collectors.toList()));
    }

    public List<PaymentInfo> getInfoByPaymentIds(List<Integer> paymentIds) throws SQLException {
        ArrayList<PaymentInfo> result = new ArrayList<PaymentInfo>();
        if (Utils.isEmptyCollection(paymentIds)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE payment_id IN (" + Utils.toString(paymentIds) + ")";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }
}

