/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotType;
import ru.bitel.bgbilling.modules.botmanager.server.bean.UserBotData;
import ru.bitel.common.model.Id;

public class BotDao
extends AbstractIdDao<Bot> {
    public BotDao(Connection con, int moduleId) {
        this(con, moduleId, "bot_manager_bots");
    }

    private BotDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<Bot> getBots() throws SQLException {
        return super.list(null, null, new Object[0]);
    }

    protected void updateImpl(Bot bot) throws SQLException {
        String querySet = "title=?, bot_type=?, token=?, state=?";
        try (PreparedStatement ps = this.prepareStatement((Id)bot, querySet);){
            int index = 1;
            ps.setString(index++, bot.getTitle());
            ps.setInt(index++, bot.getBotType().ordinal());
            ps.setString(index++, bot.getToken());
            ps.setInt(index++, bot.getState());
            this.executeUpdate((Id)bot, index, ps);
        }
    }

    protected Bot getFromRS(ResultSet rs) throws SQLException {
        return Bot.builder().setId(rs.getInt("id")).setBotType(BotType.getTypeByCode((int)rs.getInt("bot_type"))).setTitle(rs.getString("title")).setToken(rs.getString("token")).setState(rs.getInt("state")).build();
    }

    public UserBotData getBotData(int botId) throws SQLException {
        UserBotData botData = new UserBotData(botId);
        String query = "SELECT bot_data FROM " + this.tableName + " WHERE id=" + botId;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            if (rs.next()) {
                HashMap<Long, JSONObject> data = new HashMap<Long, JSONObject>();
                String s = rs.getString("bot_data");
                JSONObject json = new JSONObject(s == null ? "{}" : s);
                json.keySet().forEach(key -> data.put(Long.valueOf(key), new JSONObject(json.get(key))));
                botData.setData(data);
            }
        }
        return botData;
    }

    public void updateBotData(int botId, UserBotData userData) throws SQLException {
        JSONObject data = new JSONObject();
        if (userData != null && userData.getData().size() > 0) {
            userData.getData().forEach((chatId, json) -> data.put(String.valueOf(chatId), json));
        }
        String query = "UPDATE " + this.tableName + " SET bot_data=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, data.toString());
            ps.setInt(2, botId);
            ps.executeUpdate();
        }
    }
}

