/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGNotImplementedException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.server.util.Setup;

public abstract class CheckMaker {
    public void init(Setup setup, Connection con, Connection conSlave) throws BGException {
    }

    public abstract void addPayment(Payment var1, Check var2, Printer var3) throws BGException;

    public void endCreate(Set<Integer> cids, Check check, Printer printer) throws BGException {
    }

    public abstract void addPaymentRefund(Payment var1, Check var2, Printer var3) throws BGException;

    public void endCreateRefund(int cid, Check check, Printer printer) throws BGException {
    }

    public void addPaymentAuto(Payment payment, Check check, Printer printer) throws BGException {
        throw new BGNotImplementedException("cashcheck autoprint requires implementation of CheckMaker.addPaymentAuto(...)");
    }

    public void addPaymentAutoDelay(Payment payment, Check check, Printer printer) throws BGException {
        throw new BGNotImplementedException("cashcheck autoprint-delay requires implementation of CheckMaker.addPaymentAutoDelay(...)");
    }

    public boolean makeCheckZA(Contract contract, Check check, Printer printer, LocalDate dateMonth) throws BGException {
        throw new BGNotImplementedException("cashcheck ZA requires implementation of CheckMaker.makeCheckZA(...)");
    }

    public void makeCheckAdvancePayments(LocalDate dateMonth, List<Integer> contractsIds, CheckCallback check) throws BGException {
        throw new BGNotImplementedException("cashcheck ZA requires implementation of CheckMaker.makeCheckAdvancePayments(...)");
    }

    public static interface CheckCallback {
        public void print(Check var1, Printer var2, int var3);
    }
}

