/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

public class AgentAVDManager
extends AbstractIdDao<AgentAVD> {
    public AgentAVDManager(Connection con, int mid) {
        super(con, mid, "drweb_contract_agent");
    }

    protected AgentAVD getFromRS(ResultSet rs) throws SQLException {
        AgentAVD result = new AgentAVD();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setAgentUUID(rs.getString("agent_uuid"));
        result.setName(rs.getString("description"));
        result.setExpires((Date)rs.getDate("expires"));
        result.setStatus(rs.getInt("status"));
        result.setBlockBegin((Date)rs.getDate("block_begin"));
        result.setBlockEnd((Date)rs.getDate("block_end"));
        result.setNextStatus(rs.getInt("next_status"));
        result.setLock(rs.getBoolean("lock_agent"));
        result.setGraceperiod(rs.getBoolean("graceperiod"));
        result.setTariffId(rs.getInt("tariff_id"));
        result.setNextTariffId(rs.getInt("next_tariff_id"));
        result.setNewAgent(rs.getBoolean("new_agent"));
        return result;
    }

    public void updateNotLog(AgentAVD agent) throws SQLException {
        this.updateAndLog(agent, false);
    }

    private void updateAndLog(AgentAVD agent, boolean log) throws SQLException {
        String querySet = "cid=?, agent_uuid=?, description=?, expires = ?, status = ?, block_begin=?, block_end=?, next_status=?, lock_agent=?, graceperiod=?, tariff_id=?, next_tariff_id=?, new_agent=?";
        try (PreparedStatement ps = this.prepareStatement((Id)agent, querySet);){
            int index = 1;
            ps.setInt(index++, agent.getContractId());
            ps.setString(index++, agent.getAgentUUID());
            ps.setString(index++, agent.getName());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getExpires()));
            ps.setInt(index++, agent.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getBlockBegin()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getBlockEnd()));
            ps.setInt(index++, agent.getNextStatus());
            ps.setBoolean(index++, agent.isLock());
            ps.setBoolean(index++, agent.isGraceperiod());
            ps.setInt(index++, agent.getTariffId());
            ps.setInt(index++, agent.getNextTariffId());
            ps.setBoolean(index++, agent.isNewAgent());
            this.executeUpdate((Id)agent, index, ps);
            if (log) {
                this.updateLog(agent);
            }
        }
    }

    protected void updateImpl(AgentAVD agent) throws SQLException {
        this.updateAndLog(agent, true);
    }

    public List<AgentAVD> getListById(int contractId) throws SQLException {
        return super.list("cid=?", null, new Object[]{contractId});
    }

    public List<AgentAVD> getListLockAgent() throws SQLException {
        return super.list("lock_agent=?", null, new Object[]{true});
    }

    public List<AgentAVD> getListWithNextStatus(int nextStatus) throws SQLException {
        return super.list("next_status=?", null, new Object[]{nextStatus});
    }

    public List<AgentAVD> getListByDate(Date date) throws SQLException {
        return super.list("expires<? AND status!=3", null, new Object[]{date});
    }

    public List<AgentAVD> getListAll() throws SQLException {
        return super.list(null, null, new Object[0]);
    }

    public int getAgentCount(int contractId) throws SQLException {
        int res = 0;
        String query = "SELECT count(*) FROM " + this.tableName + " WHERE cid =?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    res = rs.getInt(1);
                }
            }
        }
        return res;
    }

    private void updateLog(AgentAVD agent) throws SQLException {
        String logTableName = this.getTableName("drweb_contract_agent_log", this.moduleId, null);
        PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + logTableName + " (date_log, id,cid, agent_uuid, description, expires, status,block_begin,block_end, next_status,lock_agent, graceperiod, tariff_id, next_tariff_id, new_agent ) VALUES (?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )", 1);
        int index = 1;
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)new Date()));
        ps.setInt(index++, agent.getId());
        ps.setInt(index++, agent.getContractId());
        ps.setString(index++, agent.getAgentUUID());
        ps.setString(index++, agent.getName());
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getExpires()));
        ps.setInt(index++, agent.getStatus());
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getBlockBegin()));
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)agent.getBlockEnd()));
        ps.setInt(index++, agent.getNextStatus());
        ps.setBoolean(index++, agent.isLock());
        ps.setBoolean(index++, agent.isGraceperiod());
        ps.setInt(index++, agent.getTariffId());
        ps.setInt(index++, agent.getNextTariffId());
        ps.setBoolean(index++, agent.isNewAgent());
        ps.executeUpdate();
        ps.close();
    }

    public int getActualAgentCount(int contractId) throws SQLException {
        int res = 0;
        String query = "SELECT count(*) FROM " + this.tableName + " WHERE cid =? AND status <>3";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    res = rs.getInt(1);
                }
            }
        }
        return res;
    }

    public void checkAgents() throws SQLException {
        String query = "SELECT t1.* FROM " + this.tableName + " AS t1 LEFT OUTER JOIN contract_module AS t2 ON t1.cid=t2.cid AND mid=? WHERE t2.cid is null AND t1.status <>3";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, this.moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    AgentAVD agent = this.getFromRS(rs);
                    agent.setNextStatus(2);
                    this.updateAndLog(agent, true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AgentAVD> getListWithStatus(int status, Calendar date) throws SQLException {
        String logTableName = this.getTableName("drweb_contract_agent_log", this.moduleId, null);
        ArrayList<AgentAVD> res = new ArrayList<AgentAVD>();
        Calendar beginDate = TimeUtils.getStartMonth((Calendar)date);
        Calendar expireDate = (Calendar)beginDate.clone();
        beginDate.add(2, -1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)beginDate);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)expireDate);
        Calendar endDate = TimeUtils.getEndMonth((Calendar)date);
        TimeUtils.moveToStartNextDay((Calendar)endDate);
        String query = "SELECT max(t1.date_log) as dtl, t1.id FROM " + logTableName + " AS t1 INNER JOIN " + this.tableName + " AS t2 ON t1.id=t2.id  WHERE t1.status = ? AND t1.date_log>=? AND t1.date_log<=? AND t1.expires>=? AND t1.expires<=? GROUP BY t1.id";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM " + logTableName + " WHERE id=? AND date_log=? ");){
            int index = 1;
            ps.setInt(index++, status);
            ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)beginDate));
            ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)endDate));
            ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)expireDate));
            ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)endDate));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    psSelect.setInt(1, rs.getInt("id"));
                    psSelect.setTimestamp(2, rs.getTimestamp("dtl"));
                    ResultSet rsSelect = psSelect.executeQuery();
                    try {
                        if (!rsSelect.next()) continue;
                        AgentAVD agent = this.getFromRS(rsSelect);
                        this.getLogger().debug("date_log=" + rs.getTime("dtl") + " agent id = " + agent);
                        res.add(agent);
                    }
                    finally {
                        if (rsSelect == null) continue;
                        rsSelect.close();
                    }
                }
                return res;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AgentAVD> getListById(int contractId, Calendar date) throws SQLException {
        String logTableName = this.getTableName("drweb_contract_agent_log", this.moduleId, null);
        ArrayList<AgentAVD> res = new ArrayList<AgentAVD>();
        Calendar beginDate = TimeUtils.getStartMonth((Calendar)date);
        Calendar expireDate = (Calendar)beginDate.clone();
        beginDate.add(2, -1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)beginDate);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)expireDate);
        Calendar endDate = TimeUtils.getEndMonth((Calendar)date);
        TimeUtils.moveToStartNextDay((Calendar)endDate);
        String query = "SELECT max(t1.date_log), t1.id FROM " + logTableName + " AS t1 INNER JOIN " + this.tableName + " AS t2 ON t1.id=t2.id  WHERE t1.cid = ? AND t1.date_log>=? AND t1.date_log<=? AND t1.expires>=? AND t1.expires<=? GROUP BY t1.id";
        try (PreparedStatement psLog = this.con.prepareStatement(query);){
            int index = 1;
            psLog.setInt(index++, contractId);
            psLog.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)beginDate));
            psLog.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)endDate));
            psLog.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)expireDate));
            psLog.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)endDate));
            try (ResultSet rsLog = psLog.executeQuery();){
                while (rsLog.next()) {
                    query = "SELECT * FROM " + logTableName + " WHERE cid=? AND date_log=? AND id=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    try {
                        index = 1;
                        ps.setInt(index++, contractId);
                        ps.setTimestamp(index++, rsLog.getTimestamp(1));
                        ps.setInt(index++, rsLog.getInt(2));
                        ResultSet rs = ps.executeQuery();
                        try {
                            if (!rs.next()) continue;
                            res.add(this.getFromRS(rs));
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                return res;
            }
        }
    }
}

