/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.client;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.plugins.message4user.common.service.MessagesForUsersService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ShowMessageForUsers
extends BGDialog {
    private JPanel messagePanel = null;
    private JLabel messageLabel = new JLabel();
    private JTextArea messageText = new JTextArea();
    private List<Message> messageList = null;
    private int messageIndex = 0;
    private JLabel date = new JLabel();

    public ShowMessageForUsers() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.messageText.setEditable(false);
        this.messagePanel = new JPanel(new GridBagLayout());
        this.setTitlePanel(0, 0);
        Dimension frame = JOptionPane.getRootFrame().getSize();
        this.messagePanel.setPreferredSize(new Dimension(frame.width / 2, frame.height / 2));
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel idLabel = new JLabel("ID:");
        JLabel l2 = new JLabel("-");
        idLabel.setEnabled(false);
        l2.setEnabled(false);
        this.messageLabel.setEnabled(false);
        this.date.setEnabled(false);
        panel.add((Component)idLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.messageLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.messageText.setMargin(new Insets(5, 10, 5, 10));
        this.messageText.setLineWrap(true);
        this.messageText.setFont(new Font("Dialog", 0, 14));
        this.messagePanel.add((Component)panel, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.messagePanel.add((Component)new JScrollPane(this.messageText), new GridBagConstraints(0, 1, 10, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGButtonPanel backNextClosePanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.GLUE, new BGButtonPanel.ButtonItem("\u041d\u0430\u0437\u0430\u0434", "back"), new BGButtonPanel.ButtonItem("\u0412\u043f\u0435\u0440\u0435\u0434", "next"), new BGButtonPanel.ButtonItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", "close")});
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        this.getContentPane().add((Component)this.messagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add((Component)backNextClosePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        backNextClosePanel.addActionListener(e -> this.buttonPanelActionPerformed(e));
        okCancelPanel.addActionListener(e -> this.buttonPanelActionPerformed(e));
    }

    private void buttonPanelActionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("next".equals(actionCommand)) {
            if (this.messageIndex + 1 < this.messageList.size()) {
                ++this.messageIndex;
                Message msg = this.messageList.get(this.messageIndex);
                this.setMessageToDialog(msg);
                this.setTitlePanel(this.messageList.size(), this.messageIndex);
                this.setMessageReadForUser(msg);
            }
        } else if ("back".equals(actionCommand)) {
            if (this.messageIndex > 0) {
                --this.messageIndex;
                this.setMessageToDialog(this.messageList.get(this.messageIndex));
                this.setTitlePanel(this.messageList.size(), this.messageIndex);
            }
        } else if ("close".equals(actionCommand)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setMessageReadForUser(Message msg) {
        try {
            ((MessagesForUsersService)this.getContext().getPort(MessagesForUsersService.class)).updateUserConfig(msg.getId());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setData() {
        new SwingWorker<MessagesForUsersService, Void>(){

            @Override
            protected MessagesForUsersService doInBackground() throws Exception {
                return (MessagesForUsersService)ShowMessageForUsers.this.getContext().getPort(MessagesForUsersService.class);
            }

            @Override
            protected void done() {
                try {
                    ShowMessageForUsers.this.setDataImpl((MessagesForUsersService)this.get());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }.execute();
    }

    private void setDataImpl(MessagesForUsersService messagesForUsers) {
        try {
            int lastMessageId = messagesForUsers.getLastMessageId();
            String userId = messagesForUsers.getUserId();
            if (lastMessageId > -1 && userId != null) {
                this.messageList = messagesForUsers.getMessageListFromLastMessageId(lastMessageId, userId);
                if (this.messageList.size() > this.messageIndex) {
                    Message msg = this.messageList.get(this.messageIndex);
                    this.setMessageToDialog(msg);
                    this.setTitlePanel(this.messageList.size(), this.messageIndex);
                    this.setMessageReadForUser(msg);
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                    this.dispose();
                }
            } else {
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setMessageToDialog(Message message) {
        this.messageLabel.setText(String.valueOf(message.getId()));
        String dateTo = TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm");
        String dateFrom = TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm");
        this.date.setText(dateFrom + " - " + dateTo);
        if (Utils.notBlankString((String)message.getMessageTitle())) {
            this.messageText.setText(message.getMessageTitle() + "\n\n" + message.getText());
        } else {
            this.messageText.setText(message.getText());
        }
    }

    private void setTitlePanel(int messageListSize, int messageIndex) {
        this.messagePanel.setBorder((Border)new BGTitleBorder("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + (messageIndex + 1) + " \u0438\u0437 " + messageListSize));
    }
}

