/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.atollibfptr;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import ru.atol.drivers10.fptr.Fptr;
import ru.atol.drivers10.fptr.IFptr;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Driver
extends BGLogger
implements ICashCheckDriver {
    private IFptr fptr = null;
    private String defaultCashierName = null;
    private String defaultCashierINN = null;
    private int reconnectAttemptsNum = 3;
    private int reconnectBusyTimeout = -1;
    private boolean setUserPasswordFromInput = false;
    private String lastPasswordFromInput = null;
    private boolean reportElectronically = false;
    private boolean autoOpenClosedDay = false;

    @Override
    public void init(Map<String, String> config) throws Exception {
        try {
            String libraryPath = config.get("libraryPath");
            this.fptr = Utils.notBlankString((String)libraryPath) ? new Fptr(libraryPath) : new Fptr();
        }
        catch (UnsatisfiedLinkError e) {
            throw new DriverException("error init native libfptr10 (not installed?): " + e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new DriverException("error init libfptr10: " + e.getMessage(), e);
        }
        for (Map.Entry<String, String> s : config.entrySet()) {
            String settingsKey = this.getValueOrConstValue(s.getKey());
            String settingsValue = this.getValueOrConstValue(s.getValue());
            if ("UserPassword".equalsIgnoreCase(settingsKey) && "input".equalsIgnoreCase(settingsValue)) {
                this.setUserPasswordFromInput = true;
                continue;
            }
            this.fptr.setSingleSetting(settingsKey, settingsValue);
        }
        this.fptr.applySingleSettings();
        this.defaultCashierName = config.get("defaultCashierName");
        this.defaultCashierINN = config.get("defaultCashierINN");
        this.reconnectAttemptsNum = Utils.parseInt((String)config.get("reconnectAttemptsNum"), (int)this.reconnectAttemptsNum);
        this.reconnectBusyTimeout = Utils.parseInt((String)config.get("reconnectBusyTimeout"), (int)this.reconnectBusyTimeout);
        this.reconnectAttemptsNum = Math.min(this.reconnectAttemptsNum, 20);
        this.reconnectBusyTimeout = Math.min(this.reconnectBusyTimeout, 120);
        this.reportElectronically = Utils.parseBoolean((String)config.get("reportElectronically"), (boolean)this.reportElectronically);
        this.autoOpenClosedDay = Utils.parseBoolean((String)config.get("autoOpenClosedDay"), (boolean)this.autoOpenClosedDay);
    }

    private String getValueOrConstValue(String value) {
        try {
            Field field = IFptr.class.getDeclaredField("LIBFPTR_" + value);
            return String.valueOf(field.get(null));
        }
        catch (Exception e1) {
            try {
                Field field = IFptr.class.getDeclaredField(value);
                return String.valueOf(field.get(null));
            }
            catch (Exception e2) {
                return value;
            }
        }
    }

    @Override
    public void touchDriver() throws Exception {
        this.getLogger().debug("not implemented");
    }

    @Override
    public void shutdown() {
        try {
            this._runCommand(() -> ((IFptr)this.fptr).close(), "close()");
        }
        catch (PrinterErrorException printerErrorException) {
        }
        this._runCommand(() -> ((IFptr)this.fptr).destroy(), "destroy()");
    }

    @Override
    public String getStatus() {
        String driverversion = this.fptr.version();
        String wrapperversion = this.fptr.wrapperVersion();
        String settings = this.fptr.getSettings().replace('\n', ' ').replace('\r', ' ').replace("    ", " ").replace("\" :", "\":");
        return String.format("driver: %s, wrapper: %s, settings: %s", driverversion, wrapperversion, settings);
    }

    private void _open() throws PrinterErrorException {
        int error2num = 0;
        long error3start = System.currentTimeMillis();
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            try {
                this._runCommand(() -> ((IFptr)this.fptr).open(), "open()" + (String)(i > 1 ? ", [!] try #" + i : ""));
                return;
            }
            catch (PrinterErrorException e) {
                if (this.fptr.errorCode() == 2) {
                    if (++error2num >= this.reconnectAttemptsNum) {
                        throw new PrinterErrorException("\u041d\u0435\u0442 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0443. \u041c\u0435\u0442\u043e\u0434 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e (" + this.reconnectAttemptsNum + ") \u0440\u0430\u0437 \u0432\u0435\u0440\u043d\u0443\u043b \u043e\u0448\u0438\u0431\u043a\u0443 \"#2 \u041d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438\"");
                    }
                } else if (this.fptr.errorCode() == 3 && this.reconnectBusyTimeout > 0) {
                    if (System.currentTimeMillis() - error3start > (long)this.reconnectBusyTimeout * 1000L) {
                        throw new PrinterErrorException("\u041d\u0435\u0442 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0443. \u041f\u043e\u0440\u0442 \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 " + this.reconnectBusyTimeout + " \u0441\u0435\u043a \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.");
                    }
                } else {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    throw new PrinterErrorException(e2.toString());
                }
            }
        }
    }

    private void _openFptr(String userPassword) throws PrinterErrorException {
        if (!this.fptr.isOpened()) {
            this._open();
        }
        this.fptr.setParam(65587, 13);
        int retcode = this.fptr.queryData();
        if (retcode < 0 && this.fptr.errorCode() == 2) {
            this.getLogger().warn("! detected device connection loss");
            this._open();
        }
        this.setUserPasswordFromInput(userPassword);
    }

    private void _runCommand(Supplier<Integer> method, String commandTitle) throws PrinterErrorException {
        this.$trace("run libfptr command: " + commandTitle);
        int retcode = method.get();
        if (retcode < 0) {
            this.$trace("get error code " + this.fptr.errorCode() + " (" + this.fptr.errorDescription() + "), throw exception");
            throw new PrinterErrorException(String.format("#%d: %s", this.fptr.errorCode(), this.fptr.errorDescription()));
        }
    }

    private void _runCommand(Runnable method, String commandTitle) {
        this.$trace("run libfptr command: " + commandTitle);
        method.run();
    }

    @Override
    public synchronized void printtext(String ... parameters) throws PrinterErrorException {
        this._openFptr(null);
        this._runCommand(() -> ((IFptr)this.fptr).beginNonfiscalDocument(), "beginNonfiscalDocument()");
        for (int i = 1; i < parameters.length; ++i) {
            if ("!CUT%)".equals(parameters[i])) {
                if (i >= parameters.length - 1) continue;
                this.fptr.setParam(65721, false);
                this._runCommand(() -> ((IFptr)this.fptr).endNonfiscalDocument(), "cut-> endNonfiscalDocument()");
                this._runCommand(() -> ((IFptr)this.fptr).beginNonfiscalDocument(), "cut-> beginNonfiscalDocument()");
                continue;
            }
            this.fptr.setParam(65536, parameters[i]);
            this._runCommand(() -> ((IFptr)this.fptr).printText(), "printText(" + parameters[i] + ")");
        }
        this.fptr.setParam(65721, false);
        this._runCommand(() -> ((IFptr)this.fptr).endNonfiscalDocument(), "endNonfiscalDocument()");
    }

    @Override
    public synchronized String name(String operatorPass) throws PrinterErrorException {
        this._openFptr(operatorPass);
        this.fptr.setParam(65587, 17);
        this._runCommand(() -> ((IFptr)this.fptr).queryData(), "queryData(LIBFPTR_DT_MODEL_INFO)");
        long model = this.fptr.getParamInt(65544);
        String modelName = this.fptr.getParamString(65603);
        String firmwareVersion = this.fptr.getParamString(65604);
        return String.format("%s (%s) %s", modelName, model, firmwareVersion);
    }

    @Override
    public synchronized String status(String operatorPass) throws PrinterErrorException {
        this._openFptr(operatorPass);
        this.fptr.setParam(65587, 0);
        this._runCommand(() -> ((IFptr)this.fptr).queryData(), "queryData(LIBFPTR_DT_STATUS)");
        long operatorID = this.fptr.getParamInt(65588);
        long logicalNumber = this.fptr.getParamInt(65589);
        long shiftState = this.fptr.getParamInt(65592);
        long model = this.fptr.getParamInt(65544);
        long mode = this.fptr.getParamInt(65547);
        long submode = this.fptr.getParamInt(65596);
        long receiptNumber = this.fptr.getParamInt(65597);
        long documentNumber = this.fptr.getParamInt(65598);
        long shiftNumber = this.fptr.getParamInt(65599);
        long receiptType = this.fptr.getParamInt(65545);
        long documentType = this.fptr.getParamInt(65872);
        long lineLength = this.fptr.getParamInt(65601);
        long lineLengthPix = this.fptr.getParamInt(65602);
        double receiptSum = this.fptr.getParamDouble(65600);
        boolean isOperatorRegistered = this.fptr.getParamBool(65914);
        boolean isFiscalDevice = this.fptr.getParamBool(65591);
        boolean isFiscalFN = this.fptr.getParamBool(65662);
        boolean isFNPresent = this.fptr.getParamBool(65707);
        boolean isInvalidFN = this.fptr.getParamBool(65679);
        boolean isCashDrawerOpened = this.fptr.getParamBool(65593);
        boolean isPaperPresent = this.fptr.getParamBool(65594);
        boolean isPaperNearEnd = this.fptr.getParamBool(65748);
        boolean isCoverOpened = this.fptr.getParamBool(65595);
        boolean isPrinterConnectionLost = this.fptr.getParamBool(65605);
        boolean isPrinterError = this.fptr.getParamBool(65606);
        boolean isCutError = this.fptr.getParamBool(65607);
        boolean isPrinterOverheat = this.fptr.getParamBool(65608);
        boolean isDeviceBlocked = this.fptr.getParamBool(65708);
        Date dateTime = this.fptr.getParamDateTime(65590);
        String serialNumber = this.fptr.getParamString(65559);
        String modelName = this.fptr.getParamString(65603);
        String firmwareVersion = this.fptr.getParamString(65604);
        this.fptr.setParam(65622, 1);
        this._runCommand(() -> ((IFptr)this.fptr).fnQueryData(), "fnQueryData(LIBFPTR_FNDT_OFD_EXCHANGE_STATUS)");
        long unsentDocumentsCount = this.fptr.getParamInt(65625);
        long firstUnsentDocumentNumber = this.fptr.getParamInt(65598);
        Date firstUnsentDocumentDate = this.fptr.getParamDateTime(65590);
        return "\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0441\u0441\u0438\u0440\u0430: " + operatorID + "\n\u041d\u043e\u043c\u0435\u0440 \u041a\u041a\u0422 \u0432 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0435: " + logicalNumber + "\n\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422: " + dateTime + "\n\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043a\u0430\u0441\u0441\u0438\u0440\u0430: " + isOperatorRegistered + "\n\u0424\u043b\u0430\u0433 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u041a\u041a\u0422: " + isFiscalDevice + "\n\u0424\u043b\u0430\u0433 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0424\u041d: " + isFiscalFN + "\n\u0424\u043b\u0430\u0433 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0424\u041d \u0432 \u041a\u041a\u0422: " + isFNPresent + "\n\u0424\u043b\u0430\u0433 (\u043d\u0435)\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0441\u0442\u0438 \u0424\u041d: " + isInvalidFN + "\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0441\u043c\u0435\u043d\u044b: " + Driver._shiftState(shiftState) + "\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a \u043e\u0442\u043a\u0440\u044b\u0442: " + isCashDrawerOpened + "\n\u041d\u0430\u043b\u0438\u0447\u0438\u0435 \u0431\u0443\u043c\u0430\u0433\u0438: " + isPaperPresent + "\n\u0411\u0443\u043c\u0430\u0433\u0430 \u0441\u043a\u043e\u0440\u043e \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u0442\u0441\u044f: " + isPaperNearEnd + "\n\u041a\u0440\u044b\u0448\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430: " + isCoverOpened + "\n\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u041a\u041a\u0422: " + serialNumber + "\n\u041d\u043e\u043c\u0435\u0440 \u043c\u043e\u0434\u0435\u043b\u0438 \u041a\u041a\u0422: " + model + "\n\u0420\u0435\u0436\u0438\u043c.\u041f\u043e\u0434\u0440\u0435\u0436\u0438\u043c \u041a\u041a\u0422: " + mode + "." + submode + "\n\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430 (\u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a \u041a\u041a\u0422): " + receiptNumber + "\n\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (\u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0441\u0447\u0435\u0442\u0447\u0438\u043a \u041a\u041a\u0422): " + documentNumber + "\n\u041d\u043e\u043c\u0435\u0440 \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0439 \u0441\u043c\u0435\u043d\u044b: " + shiftNumber + "\n\u0422\u0438\u043f \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u0447\u0435\u043a\u0430: " + Driver._receiptType(receiptType) + "\n\u0422\u0438\u043f \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + Driver._documentType(documentType) + "\n\u0421\u0443\u043c\u043c\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0447\u0435\u043a\u0430: " + receiptSum + "\n\u0428\u0438\u0440\u0438\u043d\u0430 \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b, \u0441\u0438\u043c\u0432.: " + lineLength + "\n\u0428\u0438\u0440\u0438\u043d\u0430 \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b, \u043f\u0438\u043a\u0441.: " + lineLengthPix + "\n\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u041a\u041a\u0422: " + modelName + "\n\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u041a\u041a\u0422: " + firmwareVersion + "\n\u041f\u043e\u0442\u0435\u0440\u044f\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u043f\u0435\u0447\u0430\u0442\u043d\u044b\u043c \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u043e\u043c: " + isPrinterConnectionLost + "\n\u041d\u0435\u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043c\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0447\u0430\u0442\u043d\u043e\u0433\u043e \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u0430: " + isPrinterError + "\n\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u0440\u0435\u0437\u0447\u0438\u043a\u0430: " + isCutError + "\n\u041f\u0435\u0440\u0435\u0433\u0440\u0435\u0432 \u043f\u0435\u0447\u0430\u0442\u043d\u043e\u0433\u043e \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u0430: " + isPrinterOverheat + "\n\u041a\u041a\u0422 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043e\u043a: " + isDeviceBlocked + "\n\u041d\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + unsentDocumentsCount + (String)(unsentDocumentsCount > 0L ? " (\u043f\u0435\u0440\u0432\u044b\u0439 N: " + firstUnsentDocumentNumber + " \u043e\u0442 " + TimeUtils.format((Date)firstUnsentDocumentDate, (String)"dd.MM.yyyy HH:mm") + ")" : "") + "\n";
    }

    private static String _shiftState(long shiftState) {
        switch ((int)shiftState) {
            case 0: {
                return "\u0441\u043c\u0435\u043d\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0430";
            }
            case 1: {
                return "\u0441\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430";
            }
            case 2: {
                return "\u0441\u043c\u0435\u043d\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u0430";
            }
        }
        return "?" + shiftState;
    }

    private static String _receiptType(long receiptType) {
        switch ((int)receiptType) {
            case 0: {
                return "\u0447\u0435\u043a \u0437\u0430\u043a\u0440\u044b\u0442";
            }
            case 1: {
                return "\u0447\u0435\u043a \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 2: {
                return "\u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 7: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 8: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 4: {
                return "\u0447\u0435\u043a \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 5: {
                return "\u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 9: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 10: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
        }
        return "?" + receiptType;
    }

    private static String _documentType(long documentType) {
        switch ((int)documentType) {
            case 0: {
                return "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442";
            }
            case 1: {
                return "\u0447\u0435\u043a \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 2: {
                return "\u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 3: {
                return "\u0447\u0435\u043a \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 4: {
                return "\u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 5: {
                return "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b";
            }
            case 6: {
                return "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b";
            }
            case 7: {
                return "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0435\u0440\u0435/\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438";
            }
            case 8: {
                return "\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0430\u0440\u0445\u0438\u0432\u0430 \u0424\u041d";
            }
            case 11: {
                return "\u043e\u0442\u0447\u0451\u0442 \u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0440\u0430\u0441\u0447\u0451\u0442\u043e\u0432";
            }
            case 12: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 14: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 13: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0430";
            }
            case 15: {
                return "\u0447\u0435\u043a \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0440\u0430\u0441\u0445\u043e\u0434\u0430";
            }
            case 20: {
                return "\u0441\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442";
            }
            case 21: {
                return "\u043a\u043e\u043f\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430";
            }
        }
        return "?" + documentType;
    }

    @Override
    public synchronized void xreport(String adminPass) throws PrinterErrorException {
        this._openFptr(adminPass);
        this.fptr.setParam(65546, 1);
        this._runCommand(() -> ((IFptr)this.fptr).report(), "report(LIBFPTR_RT_X)");
    }

    @Override
    public synchronized void divreport(String adminPass) throws PrinterErrorException {
        this._openFptr(adminPass);
        this.fptr.setParam(65546, 9);
        this._runCommand(() -> ((IFptr)this.fptr).report(), "report(LIBFPTR_RT_DEPARTMENTS)");
    }

    @Override
    public synchronized void zreport(String adminPass) throws PrinterErrorException {
        this._openFptr(adminPass);
        this._operatorLogin(this.defaultCashierName, this.defaultCashierINN);
        if (this.reportElectronically) {
            this._runCommand(() -> this.fptr.setParam(65749, true), "setParam(LIBFPTR_PARAM_REPORT_ELECTRONICALLY, true)");
        }
        this.fptr.setParam(65546, 0);
        this._runCommand(() -> ((IFptr)this.fptr).report(), "report(LIBFPTR_RT_CLOSE_SHIFT)");
        this._runCommand(() -> ((IFptr)this.fptr).checkDocumentClosed(), "checkDocumentClosed()");
        if (this.autoOpenClosedDay) {
            this.__openday();
        }
    }

    @Override
    public synchronized String closecheck_fix(String adminPass, String summa) throws NotImplementedException {
        throw new NotImplementedException("closecheck_fix", "\u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u0442\u044c");
    }

    @Override
    public synchronized void buzzer(String operatorPass) throws PrinterErrorException {
        this._openFptr(operatorPass);
        this._runCommand(() -> ((IFptr)this.fptr).beep(), "beep()");
    }

    private void _setTags(Map<Integer, Object> customTags) {
        for (Map.Entry<Integer, Object> tag : customTags.entrySet()) {
            Object value;
            Integer ntag = tag.getKey();
            Object vtag = tag.getValue();
            if (vtag instanceof byte[]) {
                value = (byte[])vtag;
                this._runCommand(() -> this.lambda$_setTags$1(ntag, (byte[])value), "setParam(" + ntag + ", [...])");
                continue;
            }
            if (vtag instanceof Long) {
                long value2 = (Long)vtag;
                this._runCommand(() -> this.fptr.setParam(ntag.intValue(), value2), "setParam(" + ntag + ", " + value2 + ")");
                continue;
            }
            if (!(vtag instanceof String)) continue;
            value = (String)vtag;
            this._runCommand(() -> this.lambda$_setTags$3(ntag, (String)value), "setParam(" + ntag + ", \"" + (String)value + "\")");
        }
    }

    private void _setTagsSTAG(Map<Integer, Object> customTags) throws PrinterErrorException {
        Integer ntag;
        HashMap<Integer, byte[]> _tlvTagValues = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Object> entry : customTags.entrySet()) {
            ntag = entry.getKey();
            Object vtag = entry.getValue();
            if (!(vtag instanceof Check.STAG)) continue;
            Check.STAG value = (Check.STAG)vtag;
            for (Map.Entry tlv_tag : value.entrySet()) {
                Integer tlv_ntag = (Integer)tlv_tag.getKey();
                Object tlv_vtag = tlv_tag.getValue();
                if (tlv_vtag instanceof Long) {
                    long tlv_value = (Long)tlv_vtag;
                    this._runCommand(() -> this.fptr.setParam(tlv_ntag.intValue(), tlv_value), "setParam(" + tlv_ntag + ", " + tlv_value + ")");
                    continue;
                }
                if (tlv_vtag instanceof String) {
                    String tlv_value = (String)tlv_vtag;
                    this._runCommand(() -> this.fptr.setParam(tlv_ntag.intValue(), tlv_value), "setParam(" + tlv_ntag + ", \"" + tlv_value + "\")");
                    continue;
                }
                if (tlv_vtag instanceof byte[]) {
                    byte[] tlv_value = (byte[])tlv_vtag;
                    this._runCommand(() -> this.fptr.setParam(tlv_ntag.intValue(), tlv_value), "setParam(" + tlv_ntag + ", 0x" + Utils.bytesToHexString((byte[])tlv_value) + ")");
                    continue;
                }
                throw new PrinterErrorException("error tag type " + tlv_vtag.getClass());
            }
            this._runCommand(() -> ((IFptr)this.fptr).utilFormTlv(), "utilFormTlv()");
            byte[] tlvtag = this.fptr.getParamByteArray(65624);
            _tlvTagValues.put(ntag, tlvtag);
        }
        for (Map.Entry<Integer, Object> entry : _tlvTagValues.entrySet()) {
            ntag = entry.getKey();
            byte[] tlvtag = (byte[])entry.getValue();
            this._runCommand(() -> this.fptr.setParam(ntag.intValue(), tlvtag), "setParam(" + ntag + ", [" + Utils.bytesToString((byte[])tlvtag) + "])");
        }
    }

    private int vat_convert(Integer vat) {
        if (vat == null) {
            return 0;
        }
        switch (vat) {
            default: {
                return vat;
            }
            case -1: 
            case 1000999: {
                return 6;
            }
            case 1000000: {
                return 5;
            }
            case 10: 
            case 1000010: {
                return 2;
            }
            case 110: 
            case 1000110: {
                return 4;
            }
            case 20: 
            case 1000020: {
                return 7;
            }
            case 120: 
            case 1000120: {
                return 8;
            }
            case 1000005: {
                return 9;
            }
            case 1000105: {
                return 11;
            }
            case 1000007: {
                return 10;
            }
            case 1000107: {
                return 12;
            }
            case 1000022: {
                return 13;
            }
            case 1000122: 
        }
        return 14;
    }

    private int payment_type_convert(Integer payment_type) {
        if (payment_type == null) {
            return 0;
        }
        switch (payment_type) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
        }
        return payment_type;
    }

    private static Integer payMethod_convert(Integer payMethod) {
        if (payMethod == null) {
            return null;
        }
        switch (payMethod) {
            case 1214001: {
                return 1;
            }
            case 1214002: {
                return 2;
            }
            case 1214003: {
                return 3;
            }
            case 1214004: {
                return 4;
            }
            case 1214005: {
                return 5;
            }
            case 1214006: {
                return 6;
            }
            case 1214007: {
                return 7;
            }
        }
        return payMethod;
    }

    private static Integer payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            case 1212001: {
                return 1;
            }
            case 1212003: {
                return 3;
            }
            case 1212004: {
                return 4;
            }
            case 1212010: {
                return 10;
            }
            case 1212011: {
                return 11;
            }
            case 1212013: {
                return 13;
            }
        }
        return payObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String _check(int type, String ... parameters) throws PrinterErrorException, DriverException {
        CheckFiscalData fiscal_data;
        double change;
        BigDecimal clientsumma;
        Check commandCheckParameters;
        block26: {
            commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, this.getLogger());
            String oppass = parameters[0];
            BigDecimal par1 = FrkUtils.parseBigDecimal(parameters[1]);
            clientsumma = type == 1 ? par1 : BigDecimal.ZERO;
            this.getLogger().debug("Driver: check/checkreturn(clientsumma=" + clientsumma + ",type=" + type + "):");
            BigDecimal totalsum = commandCheckParameters.getPaymentsum();
            if (type == 2) {
                clientsumma = totalsum;
            }
            if (commandCheckParameters.getCheckType() != null) {
                int newtype = -1;
                switch (commandCheckParameters.getCheckType()) {
                    case PAYMENT: {
                        newtype = 1;
                        break;
                    }
                    case PAYMENTREFUND: {
                        newtype = 2;
                        break;
                    }
                    case PAYMENTCORRECTION: {
                        newtype = 7;
                        break;
                    }
                    case PAYMENTREFUNDCORRECTION: {
                        newtype = 8;
                    }
                }
                if (newtype != type) {
                    this.getLogger().debug("Driver: overwrite check type from " + type + " to " + newtype);
                    type = newtype;
                }
            }
            Integer taxTotal = commandCheckParameters.getTax();
            Integer payMethodTotal = commandCheckParameters.getPayMethod();
            Integer payObjectTotal = commandCheckParameters.getPayObject();
            String cashierName = commandCheckParameters.getCashierName();
            Integer paymentType = commandCheckParameters.getPaymentType();
            if (cashierName == null) {
                cashierName = this.defaultCashierName;
            }
            String cashierINN = commandCheckParameters.getCashierINN();
            if (type == 1 && clientsumma.compareTo(totalsum) < 0) {
                throw new PrinterErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + totalsum.toPlainString() + ")");
            }
            Exception esave = null;
            change = 0.0;
            fiscal_data = null;
            this._openFptr(oppass);
            try {
                this._operatorLogin(cashierName, cashierINN);
                this.fptr.setParam(65545, type);
                this._setTagsSTAG(commandCheckParameters.getCustomTags());
                if (commandCheckParameters.isOnlyElCheck()) {
                    this._runCommand(() -> this.fptr.setParam(65572, true), "setParam(LIBFPTR_PARAM_RECEIPT_ELECTRONICALLY, true)");
                }
                if (commandCheckParameters.getCustomerEmail() != null) {
                    this._runCommand(() -> this.fptr.setParam(1008, commandCheckParameters.getCustomerEmail()), "setParam(1008, " + commandCheckParameters.getCustomerEmail() + ")");
                }
                this._setTags(commandCheckParameters.getCustomTags());
                this._runCommand(() -> ((IFptr)this.fptr).openReceipt(), "openReceipt(LIBFPTR_PARAM_RECEIPT_TYPE=" + type + ")");
                for (Check.CheckLine cl : commandCheckParameters.getLines()) {
                    if (cl.getSumma() == null) {
                        this.fptr.setParam(65536, cl.getText());
                        this.fptr.setParam(65537, 1);
                        this._runCommand(() -> ((IFptr)this.fptr).printText(), "printText(" + cl.getText() + ")");
                        continue;
                    }
                    this._setTagsSTAG(cl.customTags);
                    this._runCommand(() -> this.fptr.setParam(65631, cl.getText()), "setParam(LIBFPTR_PARAM_COMMODITY_NAME, " + cl.getText() + ")");
                    this._runCommand(() -> this.fptr.setParam(65632, cl.getSumma().doubleValue()), "setParam(LIBFPTR_PARAM_PRICE, " + cl.getSumma().doubleValue() + ")");
                    this._runCommand(() -> this.fptr.setParam(65633, 1), "setParam(LIBFPTR_PARAM_QUANTITY, 1)");
                    this._runCommand(() -> this.fptr.setParam(65654, true), "setParam(LIBFPTR_PARAM_COMMODITY_PIECE, true)");
                    Integer tax = cl.tax != null ? cl.tax : taxTotal;
                    Integer taxKkt = this.vat_convert(tax);
                    this._runCommand(() -> this.fptr.setParam(65569, taxKkt.intValue()), "setParam(LIBFPTR_PARAM_TAX_TYPE, " + taxKkt + ")");
                    Integer payMethod = Driver.payMethod_convert(cl.payMethod != null ? cl.payMethod : payMethodTotal);
                    Integer payObject = Driver.payObject_convert(cl.payObject != null ? cl.payObject : payObjectTotal);
                    if (payObject != null) {
                        this._runCommand(() -> this.fptr.setParam(1212, payObject.intValue()), "setParam(1212[payObject], " + payObject + ")");
                    }
                    if (payMethod != null) {
                        this._runCommand(() -> this.fptr.setParam(1214, payMethod.intValue()), "setParam(1214[payMethod], " + payMethod + ")");
                    }
                    this._runCommand(() -> this.fptr.setParam(65568, cl.getDep()), "setParam(LIBFPTR_PARAM_DEPARTMENT, " + cl.getDep() + ")");
                    this._setTags(cl.customTags);
                    this._runCommand(() -> ((IFptr)this.fptr).registration(), "registration()");
                }
                this.fptr.setParam(65564, this.payment_type_convert(paymentType));
                this.fptr.setParam(65565, clientsumma.doubleValue());
                this._runCommand(() -> ((IFptr)this.fptr).payment(), "payment(TYPE=" + this.payment_type_convert(paymentType) + ", SUM=" + clientsumma.doubleValue() + ")");
                change = this.fptr.getParamDouble(65567);
                this._runCommand(() -> ((IFptr)this.fptr).closeReceipt(), "closeReceipt()");
            }
            catch (Exception e) {
                esave = e;
                return esave;
            }
            finally {
                if (this.testOnOpenCheckAndNulled()) {
                    esave = esave == null ? new PrinterErrorException("\u041f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0447\u0435\u043a \u043f\u043e\u0447\u0435\u043c\u0443-\u0442\u043e \u043e\u0441\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442. \u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d.") : new PrinterErrorException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u0432\u0438\u0434\u0443 \u043e\u0448\u0438\u0431\u043a\u0438 \"" + esave.toString() + "\" \u0447\u0435\u043a \u043e\u0441\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442. \u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d.");
                }
                if (esave == null) break block26;
                if (esave instanceof PrinterErrorException) {
                    throw (PrinterErrorException)esave;
                }
                throw new PrinterErrorException(esave.toString());
            }
        }
        fiscal_data = new CheckFiscalData();
        try {
            String fnSerial;
            fiscal_data.type = commandCheckParameters.getCheckType();
            fiscal_data.total = clientsumma;
            this.fptr.setParam(65622, 5);
            this._runCommand(() -> ((IFptr)this.fptr).fnQueryData(), "fnQueryData(LIBFPTR_FNDT_LAST_DOCUMENT)");
            long documentNumber = this.fptr.getParamInt(65598);
            String fiscalSign = this.fptr.getParamString(65626);
            Date dateTime = this.fptr.getParamDateTime(65590);
            fiscal_data.time(dateTime);
            fiscal_data.fd = String.valueOf(documentNumber);
            fiscal_data.fp = fiscalSign;
            this.fptr.setParam(65622, 2);
            this._runCommand(() -> ((IFptr)this.fptr).fnQueryData(), "fnQueryData(LIBFPTR_FNDT_FN_INFO)");
            fiscal_data.fn = fnSerial = this.fptr.getParamString(65559);
            this.fptr.setParam(65622, 6);
            this._runCommand(() -> ((IFptr)this.fptr).fnQueryData(), "fnQueryData(LIBFPTR_FNDT_SHIFT)");
            long shift = this.fptr.getParamInt(65599);
            fiscal_data.attrs.put("shift", String.valueOf(shift));
            this.fptr.setParam(65622, 9);
            this._runCommand(() -> ((IFptr)this.fptr).fnQueryData(), "fnQueryData(LIBFPTR_FNDT_REG_INFO)");
            String ofdVATIN = this.fptr.getParamString(1017);
            String ofdName = this.fptr.getParamString(1046);
            String registrationNumber = this.fptr.getParamString(1037);
            fiscal_data.ofd_inn = ofdVATIN;
            fiscal_data.attrs.put("ofd_name", ofdName);
            fiscal_data.attrs.put("registration_number", registrationNumber);
        }
        catch (Exception ex) {
            this.getLogger().error("error get fiscal check info", (Throwable)ex);
            fiscal_data.comment = "error get fiscal check info " + ex.toString();
        }
        return CheckPrintResult.sync(String.valueOf(change), fiscal_data).toJson();
    }

    private boolean testOnOpenCheckAndNulled() {
        try {
            this._runCommand(() -> ((IFptr)this.fptr).checkDocumentClosed(), "checkDocumentClosed()");
        }
        catch (PrinterErrorException e) {
            this.$trace("error call checkDocumentClosed, call the method cancelReceipt()");
            this.fptr.cancelReceipt();
            return true;
        }
        if (!this.fptr.getParamBool(65644)) {
            this.$trace("checkDocumentClosed() said that the document is not close, call the method cancelReceipt()");
            this.fptr.cancelReceipt();
            return true;
        }
        return false;
    }

    @Override
    public synchronized String check(String ... parameters) throws PrinterErrorException, DriverException {
        return this._check(1, parameters);
    }

    @Override
    public synchronized String checkreturn(String ... parameters) throws PrinterErrorException, DriverException {
        return this._check(2, parameters);
    }

    @Override
    public synchronized void repeatcheck(String operatorPass) throws PrinterErrorException {
        this._openFptr(operatorPass);
        this.fptr.setParam(65546, 2);
        this._runCommand(() -> ((IFptr)this.fptr).report(), "report(LIBFPTR_RT_LAST_DOCUMENT)");
    }

    @Override
    public synchronized String purecommand(String operatorPass, String command) throws PrinterErrorException {
        String ret = "?";
        this._openFptr(operatorPass);
        this.fptr.setParam(65556, 10000);
        this.fptr.setParam(65557, new BGByteBuffer(command).getBytes());
        this._runCommand(() -> ((IFptr)this.fptr).runCommand(), "runCommand(" + command + ")");
        byte[] answer = this.fptr.getParamByteArray(65558);
        if (answer != null) {
            ret = new BGByteBuffer(answer).toString();
        }
        return ret;
    }

    @Override
    public synchronized void continueprint(String pass) throws PrinterErrorException {
        this._openFptr(pass);
        this._runCommand(() -> ((IFptr)this.fptr).continuePrint(), "continuePrint()");
    }

    @Override
    public synchronized void cancelcheck(String pass) throws PrinterErrorException {
        this._openFptr(pass);
        this._runCommand(() -> ((IFptr)this.fptr).cancelReceipt(), "cancelReceipt()");
    }

    @Override
    public synchronized void openday(String pass) throws PrinterErrorException {
        this._openFptr(pass);
        this._operatorLogin(this.defaultCashierName, this.defaultCashierINN);
        this.__openday();
    }

    private void __openday() throws PrinterErrorException {
        if (this.reportElectronically) {
            this._runCommand(() -> this.fptr.setParam(65749, true), "setParam(LIBFPTR_PARAM_REPORT_ELECTRONICALLY, true)");
        }
        this._runCommand(() -> ((IFptr)this.fptr).openShift(), "openShift()");
        this._runCommand(() -> ((IFptr)this.fptr).checkDocumentClosed(), "checkDocumentClosed()");
    }

    private void _operatorLogin(String name, String inn) throws PrinterErrorException {
        if (name != null) {
            this.fptr.setParam(1021, name);
        }
        if (inn != null) {
            this.fptr.setParam(1203, inn);
        }
        this._runCommand(() -> ((IFptr)this.fptr).operatorLogin(), "operatorLogin(" + name + ", " + inn + ")");
    }

    private void $trace(String message) {
        this.getLogger().trace("atollibfptr-driver: " + message);
    }

    private void setUserPasswordFromInput(String pass) {
        if (this.setUserPasswordFromInput && pass != null && !pass.equals(this.lastPasswordFromInput)) {
            this.$trace("set user password");
            this.fptr.setSingleSetting("UserPassword", pass);
            this.fptr.applySingleSettings();
        }
    }

    private /* synthetic */ void lambda$_setTags$3(Integer ntag, String value) {
        this.fptr.setParam(ntag.intValue(), value);
    }

    private /* synthetic */ void lambda$_setTags$1(Integer ntag, byte[] value) {
        this.fptr.setParam(ntag.intValue(), value);
    }
}

