/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public abstract class AgentDriver {
    private Socket socket;
    private String billId;

    public AgentDriver(Preferences moduleSetup) {
        this.billId = moduleSetup.get("bill.id", "bgbilling");
    }

    public abstract void connect() throws Exception;

    public abstract String getName();

    public void reload() throws Exception {
        StringBuilder req = this.getCommandTemplate("reload");
        String result = this.sendCommand(req.toString());
        if (!result.equals("ok")) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0441\u043b\u0443\u0436\u0431\u044b:" + result);
        }
    }

    protected void connect(String addr) throws Exception {
        String[] host_port = addr.split(":");
        if (host_port.length != 2) {
            throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0430\u0434\u0440\u0435\u0441\u0430: " + addr);
        }
        int port = Utils.parseInt((String)host_port[1]);
        if (port <= 0 || port >= 65535) {
            throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430: " + port);
        }
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(host_port[0], port), 2000);
    }

    protected String sendCommand(String command) {
        String result = null;
        try {
            PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
            writer.write(command);
            writer.write("\n");
            writer.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            result = reader.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void disconnect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected StringBuilder getCommandTemplate(String command) {
        StringBuilder result = new StringBuilder();
        result.append("id=");
        result.append(this.billId);
        result.append("&command=");
        result.append(command);
        return result;
    }

    protected void addRequestParam(StringBuilder req, String param, String value) {
        req.append("&");
        req.append(param);
        req.append("=");
        req.append(value);
    }
}

