/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNasConnection;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class InetNasList
extends NasList<InetNasConnection, InetNas> {
    private static final Logger logger = LogManager.getLogger();
    private final Access access;
    private final Accounting accounting;

    public InetNasList(Access access, Accounting accounting) {
        this.access = access;
        this.accounting = accounting;
    }

    protected InetNas newNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<InetNasConnection, InetNas, ?> processor, int id, InetNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, InetNasConnection> connections, String _nil, NasConnectionInspector inspector, Object ... params) {
        return new InetNas((Preferences)setup, moduleId, (InetRadiusProcessor)processor, (Access)((Object)params[0]), id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, null, (InetDeviceRuntime)params[2], inspector);
    }

    public synchronized void load(DefaultServerSetup setup, RadiusProcessor<InetNasConnection, InetNas, ?> _processor, Connection con, int moduleId) {
        logger.info("Loading NAS list...");
        try {
            InetRadiusProcessor processor = (InetRadiusProcessor)_processor;
            Map<Integer, InetDeviceRuntime> deviceMap = this.access != null ? this.access.deviceMap.getMap() : this.accounting.deviceMap.getMap();
            int rootDeviceId = this.access != null ? this.access.rootDeviceId : this.accounting.rootDeviceId;
            InetDeviceRuntime root = deviceMap.get(rootDeviceId);
            Set deviceTypeIds = Utils.toIntegerSet((String)root.config.get("radius.deviceTypeIds", root.config.get("nas.deviceTypeIds", "")));
            for (InetDeviceRuntime deviceRuntime : deviceMap.values()) {
                try {
                    int id = deviceRuntime.inetDevice.getId();
                    ParameterMap params = deviceRuntime.config;
                    if (deviceTypeIds.size() > 0 && !deviceTypeIds.contains(deviceRuntime.inetDevice.getDeviceTypeId()) || deviceRuntime.inetDevice.getDateTo() != null && TimeUtils.dateBefore((Date)deviceRuntime.inetDevice.getDateTo(), (Date)new Date())) continue;
                    String nasIdentifier = deviceRuntime.inetDevice.getIdentifier();
                    if (nasIdentifier == null) {
                        logger.error("device[id=" + id + "]: nasIdentifier is null. Discard device as not nas!!!");
                        continue;
                    }
                    byte[] secret = Utils.maskNull((String)params.get("radius.secret", deviceRuntime.inetDevice.getSecret())).getBytes(StandardCharsets.UTF_8);
                    int vendor = params.getInt("radius.vendor", params.getInt("nas.vendor", 0));
                    List hosts = deviceRuntime.inetDevice.getHosts();
                    InetAddress nasIPAddress = hosts != null && hosts.size() > 0 ? ((InetSocketAddress)hosts.get(0)).getAddress() : InetAddress.getByName(deviceRuntime.inetDevice.getHost());
                    this.setNas(setup, moduleId, processor, id, nasIPAddress, nasIdentifier, secret, vendor, deviceRuntime.config, null, new Object[]{this.access, this.accounting, deviceRuntime});
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

