/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.max;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.inet.server.InetTariffUtils;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public class TrafficMaxTariffTreeNode
extends TariffTreeNode<InetTariffRequest, InetTariffContext, TreeContext, InetTariffWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    private final int trafficType1;
    private final int trafficType2;
    private final int mode;
    private final Integer tariffOptionId;
    private final int serviceId;
    private final int labelId;

    public int getTrafficType1() {
        return this.trafficType1;
    }

    public int getTrafficType2() {
        return this.trafficType2;
    }

    public int getMode() {
        return this.mode;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public TrafficMaxTariffTreeNode(int id, ParameterMap params) {
        super(id, params);
        this.trafficType1 = -params.getInt("trafficTypeId1", 0) - 1;
        this.trafficType2 = -params.getInt("trafficTypeId2", 0) - 1;
        this.mode = params.getInt("mode", 0);
        this.tariffOptionId = params.getInt("tariffOptionId", 0);
        this.serviceId = params.getInt("serviceId", 0);
        this.labelId = params.getInt("labelId", 0);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffTreeNodeHolder holder, InetTariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        int result;
        block24: {
            int size2;
            int size1;
            int contractTariffOptionId;
            ContractTariffOptionList.OptionItem contractTariffOption;
            result = 1;
            if (this.mode == 5) {
                ContractTariffOptionList.OptionItem contractOption;
                Map options = req.getTariffOptionMap();
                if (options != null && (contractOption = (ContractTariffOptionList.OptionItem)options.get(this.tariffOptionId)) != null) {
                    contractTariffOption = contractOption;
                    contractTariffOptionId = contractTariffOption.contractOptionId;
                } else {
                    result = 0;
                    contractTariffOption = null;
                    contractTariffOptionId = 0;
                }
            } else {
                contractTariffOption = null;
                contractTariffOptionId = 0;
            }
            if (result != true) break block24;
            List serviceCostList1 = (List)req.getServiceCost().get(this.trafficType1);
            List serviceCostList2 = (List)req.getServiceCost().get(this.trafficType2);
            if (serviceCostList1 != null) {
                size1 = serviceCostList1.size();
                serviceCostList1 = size1 > 0 ? new ArrayList(serviceCostList1) : Collections.emptyList();
            } else {
                size1 = 0;
                serviceCostList1 = Collections.emptyList();
            }
            if (serviceCostList2 != null) {
                size2 = serviceCostList2.size();
                if (size2 > 0) {
                    serviceCostList2 = new ArrayList(serviceCostList2);
                } else if (size1 == 0) {
                    result = 0;
                } else {
                    serviceCostList2 = Collections.emptyList();
                }
            } else {
                size2 = 0;
                if (size1 == 0) {
                    result = 0;
                } else {
                    serviceCostList2 = Collections.emptyList();
                }
            }
            if (result == 1) {
                if (size1 == size2) {
                    int size = size1;
                    for (i = 0; i < size; ++i) {
                        InetServiceCost serviceCost1 = (InetServiceCost)((Object)serviceCostList1.get(i));
                        InetServiceCost serviceCost2 = (InetServiceCost)((Object)serviceCostList2.get(i));
                        this.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption, contractTariffOptionId, serviceCost1, serviceCost2);
                    }
                } else if (size1 > size2) {
                    InetServiceCost serviceCost1;
                    int size = size2;
                    while (i < size) {
                        serviceCost1 = (InetServiceCost)((Object)serviceCostList1.get(i));
                        InetServiceCost serviceCost2 = (InetServiceCost)((Object)serviceCostList2.get(i));
                        this.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption, contractTariffOptionId, serviceCost1, serviceCost2);
                        ++i;
                    }
                    size = size1;
                    while (i < size) {
                        serviceCost1 = (InetServiceCost)((Object)serviceCostList1.get(i));
                        this.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption, contractTariffOptionId, serviceCost1, null);
                        ++i;
                    }
                } else {
                    int size = size1;
                    while (i < size) {
                        InetServiceCost serviceCost1 = (InetServiceCost)((Object)serviceCostList1.get(i));
                        InetServiceCost serviceCost2 = (InetServiceCost)((Object)serviceCostList2.get(i));
                        this.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption, contractTariffOptionId, serviceCost1, serviceCost2);
                        ++i;
                    }
                    size = size2;
                    while (i < size) {
                        InetServiceCost serviceCost2 = (InetServiceCost)((Object)serviceCostList2.get(i));
                        this.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption, contractTariffOptionId, null, serviceCost2);
                        ++i;
                    }
                }
            }
        }
        return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, (ThreadContext)workerContext, result);
    }

    private void execute(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, TariffTreeNodeHolder holder, InetTariffContext ctx, TreeContext treeContext, InetTariffWorkerContext workerContext, ContractTariffOptionList.OptionItem contractTariffOption, int contractTariffOptionId, InetServiceCost serviceCost1, InetServiceCost serviceCost2) {
        try {
            InetServiceCost cost = req.connectionRuntime != null ? ctx.maxTrafficManager.addMaxTraffic(workerContext, req.connectionRuntime, contractTariffOptionId, treeNodeId, this.mode, req.getTime(), serviceCost1, serviceCost2) : ctx.maxTrafficManager.addMaxTraffic(workerContext, req.contractId, req.accountingPeriodId, req.accountingPeriodMillisFrom, contractTariffOptionId, treeNodeId, this.mode, req.getTime(), serviceCost1, serviceCost2);
            if (cost == null) {
                return;
            }
            if (cost != serviceCost2) {
                if (serviceCost2 != null) {
                    InetTariffUtils.serviceCostRemove(req, serviceCost2);
                }
            } else if (serviceCost1 != null) {
                InetTariffUtils.serviceCostRemove(req, serviceCost1);
            }
            req.serviceCost = cost;
            if (this.serviceId > 0) {
                ArrayList<InetServiceCost> serviceCosts = (ArrayList<InetServiceCost>)req.getServiceCost().get(cost.getServiceId());
                if (serviceCosts != null) {
                    serviceCosts.remove((Object)cost);
                }
                cost.setServiceId(this.serviceId);
                serviceCosts = (List)req.getServiceCost().get(this.serviceId);
                if (serviceCosts == null) {
                    serviceCosts = new ArrayList<InetServiceCost>();
                    req.getServiceCost().put(this.serviceId, serviceCosts);
                }
                serviceCosts.add(cost);
            }
            this.executeChildren(treeNodeId, req, holder, ctx, treeContext, (ThreadContext)workerContext);
            req.serviceCost = null;
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, InetTariffRequest req, InetTariffContext context, TreeContext treeContext, InetTariffWorkerContext workerContext) {
        throw new UnsupportedOperationException();
    }
}

