/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.netflow.ipn.BinaryLogProcessIn;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.modules.ipn.server.DataProcess;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.worker.WorkerTask;

public class Processor
extends Thread {
    private BGLogger logger = new BGLogger((Object)this);
    private Setup setup;
    private String sources;
    private int mid;
    private CompletionService<Integer> completionService;
    private int processCount = 0;

    public Processor(Setup setup) {
        this.setup = setup;
        this.sources = setup.get("process.sources", setup.get("sources", "0"));
        this.mid = setup.getInt("collector.mid", 0);
        int threads = setup.getInt("process.thread.count", 1);
        if (threads > 1) {
            ExecutorService executor = WorkerTask.newBlockingFixedThreadPool((String)"data-process", null, null, (int)threads, (int)0);
            this.completionService = new ExecutorCompletionService<Integer>(executor);
        }
        this.setPriority(1);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BGNestedContext.push((String)"dataloader");
        boolean wasTask = true;
        Set<Integer> currentTaskSet = Collections.synchronizedSet(new HashSet());
        block5: while (true) {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                if (!wasTask) {
                    Processor.sleep(1000L);
                }
                wasTask = false;
                Object query = "SELECT dt, param, task_proccess.id FROM task_proccess INNER JOIN source ON task_proccess.param=source.id AND source.id IN (" + this.sources + ") WHERE isNull( start_process_time ) AND task_proccess.mid=? ORDER BY param, dt LIMIT 1";
                PreparedStatement psSelectTaskProcess = con.prepareStatement((String)query);
                psSelectTaskProcess.setInt(1, this.mid);
                ResultSet rs = psSelectTaskProcess.executeQuery();
                while (rs.next() && !wasTask) {
                    final Calendar hour = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(1));
                    final int sourceId = rs.getInt(2);
                    final int task_id = rs.getInt(3);
                    if (currentTaskSet.contains(task_id)) continue;
                    wasTask = true;
                    query = "UPDATE task_proccess SET start_process_time=NOW() WHERE id=? AND isNull( start_process_time )";
                    PreparedStatement psUpdateStartProcessTime = con.prepareStatement((String)query);
                    this.logger.getLogger().info("Processing source:" + rs.getInt(2) + " time: " + rs.getString(1));
                    psUpdateStartProcessTime.setInt(1, task_id);
                    if (psUpdateStartProcessTime.executeUpdate() <= 0) continue;
                    currentTaskSet.add(task_id);
                    Callable<Integer> task = new Callable<Integer>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Integer call() {
                            Connection con = Processor.this.setup.getDBConnectionFromPool();
                            try {
                                DataProcess proccess = new DataProcess();
                                Source source = new SourceManager(con).getSource(sourceId);
                                BinaryLogProcessIn processIn = new BinaryLogProcessIn(Processor.this.setup, source, hour);
                                proccess.proccess(con, Processor.this.setup, new IPHourlyDataLog((ParameterMap)Processor.this.setup, source.getId(), hour), source, hour);
                                processIn.finishProcess();
                            }
                            finally {
                                ServerUtils.closeConnection((Connection)con);
                            }
                            return task_id;
                        }
                    };
                    if (this.completionService != null) {
                        this.completionService.submit(task);
                        continue;
                    }
                    task.call();
                    this.removeTask(con, task_id);
                    currentTaskSet.remove(task_id);
                    ++this.processCount;
                }
                if (this.completionService == null) continue;
                while (true) {
                    Future<Integer> f;
                    if ((f = this.completionService.poll()) == null) continue block5;
                    int task_id = f.get();
                    this.removeTask(con, task_id);
                    currentTaskSet.remove(task_id);
                    ++this.processCount;
                }
            }
            catch (Exception ex) {
                this.logger.logError((Throwable)ex);
                continue;
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
                continue;
            }
            break;
        }
    }

    protected void removeTask(Connection con, int task_id) throws SQLException {
        PreparedStatement psDeleteTaskProcess = con.prepareStatement("DELETE FROM task_proccess where id=?");
        psDeleteTaskProcess.setInt(1, task_id);
        psDeleteTaskProcess.executeUpdate();
        psDeleteTaskProcess.close();
    }

    public String getStatus() {
        return "Hour logs  processed: " + this.processCount;
    }
}

