/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.tariff.voice.CodeEditor;
import bitel.billing.module.tariff.voice.ExportEditor;
import bitel.billing.module.tariff.voice.ImportEditor;
import bitel.billing.module.tariff.voice.table.CodeModel;
import bitel.billing.module.tariff.voice.table.CodeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.common.model.IdTitle;

public abstract class ServiceConfigGeographicCode
extends ServiceConfigTabbedPanel {
    private CodeModel model = new CodeModel();
    private JTreeTable tree = new JTreeTable(this.model);
    private Directory dir;
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private List<JPanel> editors = new ArrayList<JPanel>();
    private CodeEditor codeEditor = new CodeEditor(this);
    private ExportEditor exportEditor = new ExportEditor(this);
    private ImportEditor importEditor = new ImportEditor(this);

    public ServiceConfigGeographicCode() {
        this.dir = this.getDestDir();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.rb_name = "bitel.billing.module.tariff.voice.setup";
        this.getModuleDoc(ServiceConfigGeographicCode.class);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        BGTextField find = new BGTextField(20);
        BGButton findButton = new BGButton("\u041d\u0430\u0439\u0442\u0438");
        panel.add((Component)find, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        ActionListener l = e -> {
            String text = find.getText();
            CodeNode root = (CodeNode)this.model.getRoot();
            CodeNode node = root.findParentNode(text);
            while (node != null && !node.prefix.equals(text)) {
                String findedPrefix = node.prefix;
                this.tree.getTree().expandPath(new TreePath(node.getPath()));
                node = root.findParentNode(text);
                if (!findedPrefix.equals(node.prefix)) continue;
                break;
            }
            if (node != null) {
                this.tree.getTree().scrollPathToVisible(new TreePath(node.getPath()));
                node = root.findParentNode(text);
                TreePath path = new TreePath(node.getPath());
                this.tree.getTree().expandPath(path);
                this.tree.getTree().setSelectionPath(path);
                this.tree.getTree().scrollPathToVisible(path);
            }
        };
        findButton.addActionListener(l);
        find.addActionListener(l);
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.tree), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.toolBar.setDefaultButtons(e -> this.toolBarAction(e), BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM, BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT);
        this.toolBar.setFloatable(false);
        this.editors.add(this.codeEditor);
        this.editors.add(this.exportEditor);
        this.editors.add(this.importEditor);
        ComponentAdapter editorsListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component comp = e.getComponent();
                for (JPanel editor : ServiceConfigGeographicCode.this.editors) {
                    if (comp == editor) continue;
                    editor.setVisible(false);
                }
            }
        };
        int pos = 3;
        for (JPanel editor : this.editors) {
            editor.addComponentListener(editorsListener);
            this.add((Component)editor, new GridBagConstraints(0, pos++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            editor.setVisible(false);
        }
        TreeWillExpandListener tweListener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                CodeNode node = (CodeNode)event.getPath().getLastPathComponent();
                if (!node.loaded) {
                    node.loaded = true;
                    ServiceConfigGeographicCode.this.model.fireTreeStructureChanged(node);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        };
        this.tree.getTree().setRootVisible(true);
        this.tree.addTreeWillExpandListener(tweListener);
        this.tree.setRowHeight(20);
        this.tree.setSelectionMode(0);
        this.tree.getColumnModel().getColumn(0).setPreferredWidth(500);
        this.tree.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.tree.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tree.getColumnModel().getColumn(1).setMinWidth(80);
        this.tree.getColumnModel().getColumn(2).setMinWidth(80);
        final JPopupMenu menu = new JPopupMenu();
        ActionListener al = e -> this.toolBarAction(e);
        JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.setActionCommand("editItem");
        editItem.addActionListener(al);
        JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteItem.setActionCommand("deleteItem");
        deleteItem.addActionListener(al);
        JMenuItem addItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        addItem.setActionCommand("newItem");
        addItem.addActionListener(al);
        menu.add(addItem);
        menu.add(editItem);
        menu.add(deleteItem);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = ServiceConfigGeographicCode.this.tree.rowAtPoint(e.getPoint());
                    if (row > 0) {
                        ServiceConfigGeographicCode.this.tree.getSelectionModel().setSelectionInterval(row, row);
                    }
                    menu.show(ServiceConfigGeographicCode.this.tree, e.getX(), e.getY());
                }
            }
        });
    }

    public abstract GeographicCode getGeographicCode();

    @Override
    public void setData() {
        this.model.load(this.getGeographicCode());
        Object root = this.model.getChild(this.model.getRoot(), 0);
        if (root != null) {
            CodeNode r = (CodeNode)root;
            r.dest = "\u0413\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043e\u0434\u044b";
            TreePath path = new TreePath(this.model.getPathToRoot(r));
            this.tree.getTree().expandPath(path);
            this.tree.getTree().setSelectionPath(path);
        }
        this.tree.updateUI();
    }

    public void toolBarAction(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            CodeNode node;
            TreePath path = this.tree.getTree().getSelectionPath();
            CodeNode codeNode = node = path != null ? (CodeNode)path.getLastPathComponent() : null;
            if (command.equals("deleteItem") || command.equals("editItem")) {
                if (node == null) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0443\u0437\u0435\u043b!");
                    return;
                }
                if (node.prefix == null || node.prefix.equals("")) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0440\u0430\u043d \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b!");
                    return;
                }
            }
            if (command.equals("deleteItem") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u0434?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.deleteCode(node, false);
            } else if (command.equals("deleteAllItem") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u043e\u0434\u044b?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.deleteCode(node, true);
            } else if (command.equals("editItem")) {
                this.codeEditor.startEdit(node);
            } else if (command.equals("newItem")) {
                this.codeEditor.startEdit(null);
            } else if (command.equals("export")) {
                this.exportEditor.startEdit();
            } else if (command.equals("import")) {
                this.importEditor.startEdit();
            }
        }
    }

    public JTreeTable getTree() {
        return this.tree;
    }

    public boolean saveToFile(File file, String fromPrefix) {
        Document doc;
        boolean result = false;
        Request request = new Request();
        request.setModule("tariff.voice");
        request.setModuleId(this.getModuleId());
        request.setAction("GeographicCodeExport");
        if (fromPrefix != null) {
            request.setAttribute("from_prefix", fromPrefix);
        }
        if (ClientUtils.checkStatus(doc = this.getDocument(request))) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(ClientUtils.linesToString(doc.getDocumentElement()).replaceAll(" x000A ", "\t").getBytes("UTF-8"));
                fos.close();
                result = true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return result;
    }

    public boolean loadFromFile(String data, String prfx, boolean addNew, boolean updateExist) {
        boolean result = false;
        Request request = new Request();
        request.setModule("tariff.voice");
        request.setModuleId(this.getModuleId());
        request.setAction("GeographicCodeImport");
        try {
            request.setAttribute("data", data);
            request.setAttribute("prefix", prfx);
            request.setAttribute("add", addNew ? 1 : 0);
            request.setAttribute("update", updateExist ? 1 : 0);
            Document doc = this.getDocument(request);
            result = ClientUtils.checkStatus(doc);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return result;
    }

    public void loadDest(BGComboBox<ComboBoxItem> dirCombo) throws Exception {
        this.dir.init(this.getModuleId());
        dirCombo.removeAllItems();
        for (IdTitle val : this.dir.getItems()) {
            dirCombo.addItem(new ComboBoxItem(String.valueOf(val.getId()), val.getTitle()));
        }
    }

    public void createDest(String title, BGComboBox<ComboBoxItem> dirCombo) throws Exception {
        int destId = this.dir.getCode(title);
        if (destId <= 0) {
            destId = this.dir.addValue(title);
            dirCombo.removeAllItems();
            for (IdTitle val : this.dir.getItems()) {
                dirCombo.addItem(new ComboBoxItem(String.valueOf(val.getId()), val.getTitle()));
            }
        }
        ClientUtils.setComboBoxSelection(dirCombo, String.valueOf(destId));
    }

    public boolean updateCode(CodeNode node) {
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("GeographicCodeUpdate");
        req.setAttribute("code", node.prefix);
        req.setAttribute("start_level", node.levelStart);
        req.setAttribute("end_level", node.levelEnd);
        req.setAttribute("destId", node.destId);
        Document doc = this.getDocument(req);
        boolean status = ClientUtils.checkStatus(doc);
        return status;
    }

    private void deleteCode(CodeNode node, boolean isDeleteAll) {
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("GeographicCodeDelete");
        req.setAttribute("code", node.prefix);
        req.setAttribute("deleteAll", isDeleteAll);
        if (ClientUtils.checkStatus(this.getDocument(req))) {
            node.removeFromParent();
            this.tree.updateUI();
        }
    }

    protected abstract Directory getDestDir();
}

