/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforeRequestEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class EasyPayTransactionManager
extends MPSTransactionManager {
    private static final String PARAM_LANG = "Lang";
    private static final String PARAM_CHECKSUM = "Checksum";
    private static final String PARAM_INPUTS = "Inputs";
    private static final String PARAM_TRANSACT_ID = "TransactID";
    private static final String PARAM_AMOUNT = "Amount";
    private static final String PARAM_DT_TIME = "DtTime";
    private static final String PARAM_DEBT = "Debt";
    private static final String PARAM_RESPONSE_MESSAGE = "ResponseMessage";
    private static final String PARAM_RESPONSE_CODE = "ResponseCode";
    private static final String PARAM_PROPERTY_LIST = "PropertyList";
    private static final String PARAM_CURRENCY = "Currency";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final int SUCCESS_RESULT = 0;
    private static final String RESPONSE_PARAMETERS_NAME = "response_parameters";
    private static final String CHECK_ACTION = "check";
    private static final String PAYMENT_ACTION = "payment";
    private ObjectMapper mapper = new ObjectMapper();

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9);
            }
            mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            try {
                event = new MPSBeforeRequestEvent(moduleId, mpsRequest, mpsResponse);
                event = (MPSBeforeRequestEvent)EventProcessor.getInstance().request((QueueEvent)event);
                eventParameters = event.getParameters();
                if (eventParameters != null && eventParameters.size() > 0) {
                    mpsResponse.getParameters().put("response_parameters", eventParameters);
                }
            }
            catch (BGException e) {
                throw new MPSException(-1, e.getMessage());
            }
            switch (mpsRequest.getAction()) {
                case 1: {
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    contract = this.actionCheck(mpsRequest);
                    debt = "";
                    if (eventParameters == null || !eventParameters.containsKey("Debt")) ** GOTO lbl26
                    debt = eventParameters.remove("Debt");
                    ** GOTO lbl33
lbl26:
                    // 1 sources

                    bu = new BalanceUtils(con);
                    try {
                        debt = Utils.formatBigDecimalSumm((BigDecimal)bu.getBalanceOut(new Date(), contract.getId()));
                    }
                    finally {
                        bu.close();
                    }
lbl33:
                    // 2 sources

                    mpsResponse.getParameters().put("Debt", debt);
                    mpsResponse.setMessage("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d - \u043e\u043f\u043b\u0430\u0442\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                    break;
                }
                case 2: {
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                    contract = this.actionCheck(mpsRequest);
                    try {
                        transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                        if (transaction != null) {
                            throw new MPSException(4);
                        }
                        this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getNumber(), mpsRequest.getType(), "");
                        mpsResponse.setTime(mpsRequest.getTime());
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                        mpsResponse.getParameters().put("DtTime", TimeUtils.format((Date)new Date(), (DateFormat)EasyPayTransactionManager.TIME_FORMAT));
                        break;
                    }
                    catch (Exception e) {
                        throw new MPSException(-1, e.getMessage());
                    }
                }
                default: {
                    throw new MPSException(21);
                }
            }
            mpsResponse.setResult(0);
        }
        catch (MPSException e) {
            this.processError(e, mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        String val1;
        String currency;
        JSONArray jsonArray;
        JSONObject jsonObject;
        String method;
        this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        String pathInfo = request.getPathInfo();
        switch (method = pathInfo.substring(pathInfo.lastIndexOf("/") + 1)) {
            case "check": {
                result.setAction(1);
                break;
            }
            case "payment": {
                result.setAction(2);
                break;
            }
            default: {
                throw new MPSException(2, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 - " + method + "!");
            }
        }
        StringBuilder json = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        }
        catch (IOException e1) {
            throw new MPSException(-1, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430 (\u0441\u044b\u0440\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435): %s", json.toString()));
        }
        if (Utils.isBlankString((String)json.toString())) {
            throw new MPSException(2, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        try {
            jsonObject = new JSONObject(json.toString());
        }
        catch (JSONException e) {
            throw new MPSException(2, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 json-\u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        JSONArray jSONArray = jsonArray = jsonObject.has(PARAM_INPUTS) ? this.getJsonArray(jsonObject) : null;
        if (jsonArray == null || jsonArray.length() <= 0) {
            throw new MPSException(2, "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Inputs");
        }
        String checksum = jsonObject.has(PARAM_CHECKSUM) ? jsonObject.getString(PARAM_CHECKSUM) : null;
        String lang = jsonObject.has(PARAM_LANG) ? jsonObject.getString(PARAM_LANG) : null;
        String amount = jsonObject.has(PARAM_AMOUNT) ? jsonObject.getString(PARAM_AMOUNT) : null;
        String transId = jsonObject.has(PARAM_TRANSACT_ID) ? jsonObject.getString(PARAM_TRANSACT_ID) : null;
        String dateTime = jsonObject.has(PARAM_DT_TIME) ? jsonObject.getString(PARAM_DT_TIME) : null;
        String string = currency = jsonObject.has(PARAM_CURRENCY) ? jsonObject.getString(PARAM_CURRENCY) : null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430 (\u043f\u043e\u0441\u043b\u0435 \u0440\u0430\u0437\u0431\u043e\u0440\u0430): action = %s; inputs = %s; checksum = %s; lang = %s; amount = %s; transId = %s; dateTime = %s", method, jsonArray, checksum, lang, amount, transId, dateTime));
        }
        if (Utils.isBlankString((String)(val1 = jsonArray.optString(0)))) {
            throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 Inputs");
        }
        result.setNumber(val1);
        result.setRawNumber(val1);
        String val2 = jsonArray.optString(1);
        String val3 = jsonArray.optString(2);
        String val4 = jsonArray.optString(3);
        if (result.getAction() == 1 && Utils.isBlankString((String)lang)) {
            throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Lang");
        }
        if (result.getAction() == 2) {
            if (Utils.isBlankString((String)amount)) {
                throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Amount");
            }
            result.setSum(Utils.parseBigDecimal((String)amount, (BigDecimal)BigDecimal.ZERO));
            if (result.getSum().compareTo(BigDecimal.ZERO) <= 0) {
                throw new MPSException(2, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!");
            }
            if (Utils.isBlankString((String)transId)) {
                throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 TransactID");
            }
            result.setTransId(transId);
            if (Utils.isBlankString((String)dateTime)) {
                throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 DtTime");
            }
            result.setTime(TimeUtils.parseDate((String)dateTime, (DateFormat)TIME_FORMAT));
        }
        if (Utils.isBlankString((String)checksum)) {
            throw new MPSException(2, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Checksum");
        }
        String str2Hash = val1 + val2 + val3 + val4;
        switch (result.getAction()) {
            case 1: {
                str2Hash = str2Hash + lang;
                break;
            }
            case 2: {
                str2Hash = str2Hash + amount + transId;
                break;
            }
            default: {
                throw new MPSException(21);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            this.getLogger().debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f hash: <secret>" + str2Hash);
        }
        str2Hash = system.secret + str2Hash;
        String hashValue = Utils.getDigest((String)str2Hash, (String)(Utils.isBlankString((String)system.requestEncoding) ? "UTF-8" : system.requestEncoding));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u043e\u0434\u043f\u0438\u0441\u044c, \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c: " + hashValue);
        }
        if (!hashValue.equalsIgnoreCase(checksum)) {
            throw new MPSException(10, "\u041f\u043e\u0434\u043f\u0438\u0441\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!");
        }
        result.parameters.put(PARAM_INPUTS, jsonArray.toString());
        result.parameters.put(PARAM_DT_TIME, dateTime);
        result.parameters.put(PARAM_CHECKSUM, checksum);
        result.parameters.put(PARAM_LANG, lang);
        result.parameters.put(PARAM_AMOUNT, amount);
        result.parameters.put(PARAM_TRANSACT_ID, transId);
        result.parameters.put(PARAM_CURRENCY, currency);
        return result;
    }

    private JSONArray getJsonArray(JSONObject jsonObject) throws MPSException {
        JSONArray result = null;
        try {
            result = jsonObject.getJSONArray(PARAM_INPUTS);
        }
        catch (JSONException e) {
            throw new MPSException(2, "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u043c\u0430\u0441\u0441\u0438\u0432 Inputs");
        }
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        response.setResult(ex.error);
        response.setMessage(ex.message);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        HashMap<String, Object> answerItems = new HashMap<String, Object>();
        try {
            answerItems.put(PARAM_RESPONSE_CODE, response.getResult());
            answerItems.put(PARAM_RESPONSE_MESSAGE, response.getMessage());
            ArrayList<SimpleKeyValue> items = new ArrayList<SimpleKeyValue>(response.getParameters().size());
            if (response.getParameters().containsKey(RESPONSE_PARAMETERS_NAME)) {
                Map paramsFromEvent = (Map)response.getParameters().get(RESPONSE_PARAMETERS_NAME);
                for (Map.Entry entry : paramsFromEvent.entrySet()) {
                    items.add(new SimpleKeyValue((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            answerItems.put(PARAM_PROPERTY_LIST, items);
            Object str2Hash = null;
            switch (response.getAction()) {
                case 1: {
                    answerItems.put(PARAM_DEBT, response.getParameters().remove(PARAM_DEBT));
                    str2Hash = this.mapper.writeValueAsString(items);
                    break;
                }
                case 2: {
                    String date = (String)response.getParameters().get(PARAM_DT_TIME);
                    answerItems.put(PARAM_DT_TIME, date);
                    str2Hash = date;
                    break;
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0441\u0435\u0440\u0432\u0435\u0440 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442 \u043f\u043e\u0434\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u043e\u0442\u0432\u0435\u0442\u0430: <secret>" + str2Hash);
            }
            str2Hash = system.secret + str2Hash;
            String hashValue = Utils.getDigest((String)str2Hash, (String)(Utils.isBlankString((String)system.requestEncoding) ? "UTF-8" : system.requestEncoding));
            answerItems.put(PARAM_CHECKSUM, hashValue.toLowerCase());
        }
        catch (JsonProcessingException e) {
            answerItems.put(PARAM_RESPONSE_CODE, -1);
            answerItems.put(PARAM_RESPONSE_MESSAGE, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u043e\u0442\u0432\u0435\u0442\u0430.");
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        byte[] result = null;
        try {
            String answer = this.mapper.writeValueAsString((Object)this.getResponse(answerItems, response.getAction()));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0443: " + answer);
            }
            result = answer.getBytes(Utils.isBlankString((String)system.responseEncoding) ? "UTF-8" : system.responseEncoding);
        }
        catch (JsonProcessingException | UnsupportedEncodingException ex) {
            this.logError(ex);
        }
        return result;
    }

    private EasyPayResponse getResponse(Map<String, Object> answerItems, int action) {
        EasyPayResponse result = new EasyPayResponse();
        switch (action) {
            case 1: {
                EasyPayCHECKResponse checkResponse = new EasyPayCHECKResponse();
                checkResponse.setDebt((String)answerItems.get(PARAM_DEBT));
                result = checkResponse;
                break;
            }
            case 2: {
                EasyPayPAYResponse payResponse = new EasyPayPAYResponse();
                payResponse.setDtTime((String)answerItems.get(PARAM_DT_TIME));
                result = payResponse;
                break;
            }
        }
        if (answerItems.containsKey(PARAM_RESPONSE_CODE)) {
            result.setResponseCode((Integer)answerItems.get(PARAM_RESPONSE_CODE));
        }
        if (answerItems.containsKey(PARAM_RESPONSE_MESSAGE)) {
            result.setResponseMessage((String)answerItems.get(PARAM_RESPONSE_MESSAGE));
        }
        if (answerItems.containsKey(PARAM_CHECKSUM)) {
            result.setChecksum((String)answerItems.get(PARAM_CHECKSUM));
        }
        if (answerItems.containsKey(PARAM_PROPERTY_LIST)) {
            result.setPropertyList((List)answerItems.get(PARAM_PROPERTY_LIST));
        }
        return result;
    }

    @JsonPropertyOrder(value={"key", "value"})
    private class SimpleKeyValue {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="value")
        private String value;

        public SimpleKeyValue(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }

    private class EasyPayResponse {
        @JsonProperty(value="ResponseCode")
        private int ResponseCode;
        @JsonProperty(value="ResponseMessage")
        private String ResponseMessage;
        @JsonProperty(value="PropertyList")
        private List<SimpleKeyValue> PropertyList;
        @JsonProperty(value="Checksum")
        private String Checksum;

        private EasyPayResponse() {
        }

        public void setResponseCode(int responseCode) {
            this.ResponseCode = responseCode;
        }

        public void setResponseMessage(String responseMessage) {
            this.ResponseMessage = responseMessage;
        }

        public void setPropertyList(List<SimpleKeyValue> propertyList) {
            this.PropertyList = propertyList;
        }

        public void setChecksum(String checksum) {
            this.Checksum = checksum;
        }
    }

    @JsonPropertyOrder(value={"ResponseMessage", "ResponseCode", "Debt", "Checksum", "PropertyList"})
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class EasyPayCHECKResponse
    extends EasyPayResponse {
        @JsonProperty(value="Debt")
        private String Debt;

        private EasyPayCHECKResponse() {
        }

        public void setDebt(String debt) {
            this.Debt = debt;
        }
    }

    @JsonPropertyOrder(value={"ResponseCode", "ResponseMessage", "PropertyList", "Checksum", "DtTime"})
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class EasyPayPAYResponse
    extends EasyPayResponse {
        @JsonProperty(value="DtTime")
        private String DtTime;

        private EasyPayPAYResponse() {
        }

        public void setDtTime(String dtTime) {
            this.DtTime = dtTime;
        }
    }
}

