/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server;

import java.util.ArrayList;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntimeMap;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.server.ProductSpecMap;
import ru.bitel.oss.systems.order.product.common.event.ProductOfferingListEvent;

public class ProductOfferingListEventHandler
implements EventListener<ProductOfferingListEvent> {
    private static final Logger logger = LogManager.getLogger();
    private final Set<Integer> moduleIds;

    public ProductOfferingListEventHandler(Set<Integer> moduleIds) {
        this.moduleIds = moduleIds;
    }

    public void notify(ProductOfferingListEvent e, EventListenerContext ctx) throws Exception {
        int moduleId = e.getSubjectModuleId();
        if (!this.moduleIds.contains(moduleId)) {
            return;
        }
        ProductSpecMap productSpecMap = ProductSpecMap.getInstance();
        TvAccountSpecRuntimeMap tvAccountSpecRuntimeMap = TvAccountSpecRuntimeMap.getInstance(ctx.getConnectionSet(), moduleId);
        if (e.getAccountId() <= 0) {
            return;
        }
        TvAccount tvAccount = (TvAccount)new TvAccountDao(ctx.getConnection(), moduleId).get(e.getAccountId());
        int tvAccountSpecId = tvAccount.getSpecId();
        TvAccountSpecRuntime tvAccountSpecRuntime = (TvAccountSpecRuntime)tvAccountSpecRuntimeMap.get(tvAccountSpecId);
        Set productSpecRootIds = Utils.toIntegerSet((String)tvAccountSpecRuntime.config.get("productSpecRootIds", null));
        if (productSpecRootIds == null || productSpecRootIds.size() == 0) {
            return;
        }
        ArrayList<ProductSpecMap.ProductSpecItem> productSpecRootList = new ArrayList<ProductSpecMap.ProductSpecItem>();
        for (Integer productSpecId : productSpecRootIds) {
            ProductSpecMap.ProductSpecItem item = productSpecMap.get(productSpecId.intValue());
            if (item == null) continue;
            productSpecRootList.add(item);
        }
        if (productSpecRootList == null || productSpecRootList.size() == 0) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Filter productSpecList by productSpecRootIds=" + productSpecRootIds);
        }
        ArrayList<ProductOffering> productOfferingList = new ArrayList<ProductOffering>(e.getProductOfferingList().size());
        block1: for (ProductOffering productOffering : e.getProductOfferingList()) {
            for (ProductSpecMap.ProductSpecItem root : productSpecRootList) {
                if (!root.isDescendant(productOffering.getProductSpec().getId())) continue;
                productOfferingList.add(productOffering);
                continue block1;
            }
        }
        e.setProductOfferingList(productOfferingList);
    }
}

