/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.server.task.AssistRecurringRunTask;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class AssistPaymentRecurringManager {
    private Connection con;
    private int moduleId;
    private final String tablename;

    public AssistPaymentRecurringManager(Connection con, int moduleId) {
        this.moduleId = moduleId;
        this.con = con;
        this.tablename = "assist_payment_recurring_" + moduleId;
    }

    public int add(AssistPaymentRecurring pr) throws SQLException {
        int result = 0;
        String query = "INSERT INTO " + this.tablename + " SET cid=?, date=?, amount=?, ordernumber=?, recurringMinAmount=?, recurringMaxAmount=?, recurringPeriod=?, recurringMaxDate=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, pr.getContractId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)pr.getDate()));
            ps.setBigDecimal(3, pr.getAmount());
            ps.setLong(4, pr.getOrdernumber());
            ps.setBigDecimal(5, pr.getRecurringMinAmount());
            ps.setBigDecimal(6, pr.getRecurringMaxAmount());
            ps.setInt(7, pr.getRecurringPeriod());
            ps.setDate(8, TimeUtils.convertDateToSqlDate((Date)pr.getRecurringMaxDate()));
            ps.executeUpdate();
            result = ServerUtils.lastInsertId((PreparedStatement)ps);
        }
        return result;
    }

    public static AssistPaymentRecurring getRecurringFromRS(ResultSet rs, boolean contractTitle) throws SQLException {
        AssistPaymentRecurring payment = new AssistPaymentRecurring();
        payment.setId(rs.getInt("id"));
        payment.setContractId(rs.getInt("cid"));
        if (contractTitle) {
            payment.setContractTitle(rs.getString("con_title"));
            payment.setContractComment(rs.getString("con_comment"));
        }
        payment.setDate((Date)rs.getTimestamp("date"));
        payment.setAmount(rs.getBigDecimal("amount"));
        payment.setBillnumber(rs.getLong("billnumber"));
        payment.setOrdernumber(rs.getInt("ordernumber"));
        payment.setRecurringMinAmount(rs.getBigDecimal("recurringMinAmount"));
        payment.setRecurringMaxAmount(rs.getBigDecimal("recurringMaxAmount"));
        payment.setRecurringPeriod(rs.getInt("recurringPeriod"));
        payment.setRecurringMaxDate((Date)rs.getDate("recurringMaxDate"));
        return payment;
    }

    public boolean updateBillnumber(long ordernumber, int contractId, long billnumber) throws SQLException {
        boolean result = false;
        String query = "UPDATE " + this.tablename + " SET billnumber=? WHERE ordernumber=? AND cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, billnumber);
            ps.setLong(2, ordernumber);
            ps.setInt(3, contractId);
            result = ps.executeUpdate() > 0;
        }
        return result;
    }

    public List<AssistPaymentRecurring> getRecurringList(int contractId) throws SQLException {
        ArrayList<AssistPaymentRecurring> result = new ArrayList<AssistPaymentRecurring>();
        String query = "SELECT apr.*, contract.title AS con_title, contract.comment AS con_comment  FROM " + this.tablename + " as apr  LEFT JOIN contract ON contract.id=apr.cid  WHERE (CURDATE()<=apr.recurringMaxDate) ";
        if (contractId > 0) {
            query = query + " AND (apr.cid=?) ";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int i = 1;
            if (contractId > 0) {
                ps.setInt(i++, contractId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(AssistPaymentRecurringManager.getRecurringFromRS(rs, true));
                }
            }
        }
        return result;
    }

    public AssistPaymentRecurring getRecurring(int contractId) throws SQLException {
        List<AssistPaymentRecurring> list = this.getRecurringList(contractId);
        return list.isEmpty() ? null : list.get(0);
    }

    public void deleteRecurring(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tablename + " WHERE cid=" + contractId;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void runRecurring(int contractId, BigDecimal sum) {
        new RunTaskDataManager(this.con).addTask((RunTask)new AssistRecurringRunTask(this.moduleId, contractId, sum));
    }
}

