/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.connection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;

public abstract class InetConnectionMap<D, K, E> {
    private static final Logger logger = LogManager.getLogger();
    protected ConcurrentMap<Object, E> connectionMap = new ConcurrentHashMap<Object, E>();
    protected final InetApplication application;
    protected final boolean newSearch;
    protected final boolean needAccessAccept;
    protected final boolean needAccounting;
    private static final Pattern macrosPattern = Pattern.compile("\\$\\w+");

    protected E put(Object key, boolean accounting, int ipResourceId, byte[] address, int servId, long connectionId) {
        return this.connectionMap.put(key, this.newEntry(ipResourceId, address, servId, connectionId));
    }

    protected void remove(Object key, byte[] address, E entry) {
        this.connectionMap.remove(key, entry);
    }

    private K getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetServ inetServ, InetServ parentInetServ, String mac, byte[] address, Object circuitId) {
        if (parentInetServ == null) {
            InetServRuntime inetServRuntime = this.application.getInetServRuntimeMap().get(inetServ.getId());
            InetServRuntime parentInetServRuntime = inetServRuntime.getRootInetServRuntime(this.application);
            parentInetServ = parentInetServRuntime.getInetServ();
        }
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = parentInetServ.getInterfaceId();
                if (interfaceId == -1 && circuitId != null) {
                    int n = interfaceId = circuitId instanceof Number ? ((Number)circuitId).intValue() : Utils.parseInt((String)circuitId.toString(), (int)-1);
                }
                if (interfaceId != -1) {
                    return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
                }
                logger.info("interfaceId not set");
                return null;
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = parentInetServ.getVlan();
                if (vlanId == -1) {
                    int n = vlanId = circuitId instanceof Number ? ((Number)circuitId).intValue() : Utils.parseInt((String)circuitId.toString(), (int)-1);
                }
                if (vlanId != -1) {
                    return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
                }
                logger.info("vlanId not set");
                return null;
            }
        }
        return this.getKey(device, deviceId, agentDeviceId, 0, mac, address);
    }

    protected abstract K getKey(D var1, int var2, int var3, int var4, String var5, byte[] var6);

    public InetConnectionMap(InetApplication application, boolean newSearch, boolean needAccessAccept, boolean needAccounting) throws BGException {
        this.application = application;
        this.newSearch = newSearch;
        this.needAccessAccept = needAccessAccept;
        this.needAccounting = needAccounting;
    }

    protected void init() throws BGException {
        if (this.needAccessAccept) {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetRadiusProcessor.AuthAcceptEvent>(){

                public void notify(InetRadiusProcessor.AuthAcceptEvent e, EventListenerContext ctx) throws BGException {
                    int deviceId = e.getDeviceId();
                    Object device = InetConnectionMap.this.getDevice(deviceId);
                    if (!InetConnectionMap.this.isAccessAcceptUsed(device)) {
                        return;
                    }
                    RadiusPacket request = e.getRequest();
                    RadiusPacket response = e.getResponse();
                    byte[] address = response.getByteAttribute(-1, 8, null);
                    if (address == null) {
                        address = request.getByteAttribute(2352, 132, null);
                    }
                    String userName = request.getStringAttribute(-1, 1, null);
                    String callingStationId = request.getStringAttribute(-1, 31, null);
                    int servSearchMode = InetConnectionMap.this.getServSearchMode(device);
                    if (InetConnectionMap.this.newSearch || device != null && servSearchMode != 0) {
                        Object key = InetConnectionMap.this.getKey(device, servSearchMode, deviceId, e.getAgentDeviceId(), e.getInetServ(), null, callingStationId, address, e.getCircuitId());
                        if (key != null) {
                            logger.info("Put auth accept " + key);
                            InetConnectionMap.this.put(key, false, e.getIpResourceId(), address, e.getInetServ().getId(), 0L);
                        }
                    } else if (Utils.notBlankString((String)userName) && Utils.notBlankString((String)callingStationId) && address != null) {
                        String key = InetConnectionMap.this.getKeyOld(deviceId, userName, callingStationId);
                        if (key != null) {
                            logger.info("Put auth accept " + key);
                            InetConnectionMap.this.put(key, false, e.getIpResourceId(), address, e.getInetServ().getId(), 0L);
                        }
                    } else {
                        logger.info("Skip userName: " + userName);
                    }
                }
            }, InetRadiusProcessor.AuthAcceptEvent.class);
        }
        if (!this.needAccounting) {
            return;
        }
        if (this.application instanceof Access) {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionAddEvent>(){

                public void notify(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionAdd(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionUpdateEvent>(){

                public void notify(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionUpdate(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionRemoveEvent>(){

                public void notify(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionRemove(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionRemoveEvent.class);
        } else {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionAddEvent>(){

                public void notify(Accounting.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionAdd(e.getConnection());
                }
            }, Accounting.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionUpdateEvent>(){

                public void notify(Accounting.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionUpdate(e.getConnection());
                }
            }, Accounting.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionRemoveEvent>(){

                public void notify(Accounting.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        return;
                    }
                    InetConnectionMap.this.connectionRemove(e.getConnection());
                }
            }, Accounting.ConnectionRemoveEvent.class);
        }
    }

    private void connectionAdd(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (!this.isAccountingUsed(device)) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            K key;
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime != null && (key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes(), con.getCircuitId())) != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + key);
                    this.put(key, true, con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId());
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + key);
                    this.put(key, true, con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId());
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionUpdate(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (!this.isAccountingUsed(device)) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            K key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes(), con.getCircuitId());
            if (key == null) {
                return;
            }
            if (con.getInetAddressBytes() != null) {
                logger.info("Put connection update " + key);
                this.put(key, true, con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId());
            } else {
                logger.info("Ip is null " + key);
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection update " + key);
                    this.put(key, true, con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId());
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionRemove(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (!this.isAccountingUsed(device)) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            K key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes(), con.getCircuitId());
            if (key == null) {
                return;
            }
            logger.info("Remove connection remove " + key);
            Object entry = this.connectionMap.get(key);
            if (entry != null && this.getConnectionId(entry) == con.getId()) {
                this.remove(key, con.getInetAddressBytes(), entry);
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                logger.info("Remove connection remove " + key);
                Object entry = this.connectionMap.get(key);
                if (entry != null && this.getConnectionId(entry) == con.getId()) {
                    this.remove(key, con.getInetAddressBytes(), entry);
                }
            }
        }
    }

    protected void load() {
        if (!this.needAccounting) {
            return;
        }
        logger.info("Restore connections on InetConnectionKeyMap");
        InetServRuntimeMap inetServRuntimeMap = this.application.getInetServRuntimeMap();
        StringBuffer sb = new StringBuffer();
        if (this.application instanceof Access) {
            for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> me : ((Access)this.application).connectionManager.deviceConnectionEntrySet()) {
                try {
                    Integer deviceId = me.getKey();
                    ConcurrentMap<Long, InetConnectionRuntime> map = me.getValue();
                    D device = this.getDevice(deviceId);
                    if (!this.isAccountingUsed(device)) continue;
                    for (InetConnectionRuntime connectionRuntime : map.values()) {
                        try {
                            if (connectionRuntime.connection.getParentConnectionId() > 0L) {
                                logger.debug("Skip service connection");
                                continue;
                            }
                            this.put(inetServRuntimeMap, device, deviceId, connectionRuntime.connection, sb);
                        }
                        catch (Exception ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            for (Map.Entry<Long, InetConnectionCallRuntime> me : ((Accounting)this.application).connectionMapCall.getSessionMap().entrySet()) {
                try {
                    InetConnectionCallRuntime connectionCallRuntime = me.getValue();
                    InetConnection connection = connectionCallRuntime.connection;
                    if (connection.getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                        continue;
                    }
                    Integer deviceId = connection.getDeviceId();
                    D device = this.getDevice(deviceId);
                    if (!this.isAccountingUsed(device)) continue;
                    this.put(inetServRuntimeMap, device, deviceId, connection, sb);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void put(InetServRuntimeMap inetServRuntimeMap, D device, int deviceId, InetConnection connection, StringBuffer sb) {
        String key;
        Integer inetServId = connection.getServId();
        InetServRuntime inetServRuntime = inetServRuntimeMap.get(inetServId);
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            if (inetServRuntime == null && logger.isDebugEnabled()) {
                logger.debug("InetServ not found: " + inetServId);
                return;
            }
            sb.setLength(0);
            key = this.getKey(device, servSearchMode, deviceId, connection.getAgentDeviceId(), inetServRuntime.getInetServ(), inetServRuntime.getRootInetServRuntime(this.application).getInetServ(), connection.getCallingStationId(), connection.getInetAddressBytes(), connection.getCircuitId());
        } else {
            key = this.getKeyOld(connection);
        }
        if (key != null) {
            logger.info("Restored connection add " + key);
            this.put(key, true, connection.getIpResourceId(), connection.getInetAddressBytes(), connection.getServId(), connection.getId());
        }
    }

    private String getKeyOld(InetConnection con) {
        int deviceId = con.getDeviceId();
        String userName = Utils.maskBlank((String)con.getUsername(), (String)"").toUpperCase();
        String callingStationId = con.getCallingStationId();
        return this.getKeyOld(deviceId, userName, callingStationId);
    }

    private String getKeyOld(int deviceId, String userName, String callingStationId) {
        String[] remote_circuit = userName.toUpperCase().replaceAll("[#_\\-\\|]", ":").split(":");
        if (remote_circuit.length != 2) {
            logger.error("Incorrect userName: " + userName);
            return null;
        }
        String mac = Utils.maskBlank((String)callingStationId, (String)"").toUpperCase().replaceAll("\\.", "");
        return this.getKeyOld(deviceId, remote_circuit[0], remote_circuit[1], mac);
    }

    protected String getKeyOld(int deviceId, String remoteId, String circuitId, String mac) {
        D device = this.getDevice(deviceId);
        String pattern = this.getPattern(device);
        StringBuffer sb = new StringBuffer(48);
        Matcher m = macrosPattern.matcher(pattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, remoteId);
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, circuitId);
                continue;
            }
            if ("$mac".equals(param)) {
                m.appendReplacement(sb, mac);
                continue;
            }
            logger.error("Unknown parameter in pattern: " + pattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected abstract E newEntry(int var1, byte[] var2, int var3, long var4);

    protected abstract E[] newArray(int var1);

    protected abstract E[] newArray(E var1);

    protected abstract int getServSearchMode(D var1);

    protected abstract long getConnectionId(E var1);

    protected abstract D getDevice(int var1);

    protected abstract String getPattern(D var1);

    protected abstract boolean isAccountingUsed(D var1);

    protected abstract boolean isAccessAcceptUsed(D var1);

    private K getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, DhcpPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return this.getKey(device, deviceId, agentDeviceId, 0, mac, address);
    }

    public E getBacked(InetDeviceRuntime deviceRuntime, D device, InetDeviceRuntime agentDeviceRuntime, DhcpPacket request) {
        Object key;
        int servSearchMode = this.getServSearchMode(device);
        if (!this.newSearch && servSearchMode == 0) {
            String circuitId = Utils.bytesToHexString((byte[])request.getSubOption((byte)1).value);
            String remoteId = Utils.bytesToHexString((byte[])request.getSubOption((byte)2).value);
            String macString = Utils.bytesToHexString((byte[])request.chaddr);
            key = this.getKeyOld(deviceRuntime.inetDeviceId, remoteId, circuitId, macString);
        } else {
            String macString = Utils.bytesToString((byte[])request.chaddr, (boolean)true, null);
            key = this.getKey(device, servSearchMode, (int)deviceRuntime.inetDeviceId, deviceRuntime == agentDeviceRuntime ? 0 : agentDeviceRuntime.inetDeviceId, agentDeviceRuntime, request, macString, null);
        }
        return (E)this.connectionMap.get(key);
    }

    public E get(InetDeviceRuntime deviceRuntime, D device, InetDeviceRuntime agentDeviceRuntime, D agentDevice, DhcpPacket request) {
        Object key;
        int servSearchMode = this.getServSearchMode(agentDevice);
        if (!this.newSearch && servSearchMode == 0) {
            String circuitId = Utils.bytesToHexString((byte[])request.getSubOption((byte)1).value);
            String remoteId = Utils.bytesToHexString((byte[])request.getSubOption((byte)2).value);
            String macString = Utils.bytesToHexString((byte[])request.chaddr);
            key = this.getKeyOld(deviceRuntime.inetDeviceId, remoteId, circuitId, macString);
        } else {
            String macString = Utils.bytesToString((byte[])request.chaddr, (boolean)true, null);
            key = this.getKey(device, servSearchMode, (int)deviceRuntime.inetDeviceId, deviceRuntime == agentDeviceRuntime ? 0 : agentDeviceRuntime.inetDeviceId, agentDeviceRuntime, request, macString, null);
        }
        return (E)this.connectionMap.get(key);
    }

    private K getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, RadiusPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return null;
    }

    public E get(Object key) {
        return (E)this.connectionMap.get(key);
    }

    public E get(RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, D device, InetDeviceRuntime agentDeviceRuntime, RadiusPacket request, String macString) {
        int agentDeviceId;
        int servSearchMode = this.getServSearchMode(device);
        if (agentDeviceRuntime != null) {
            agentDeviceId = agentDeviceRuntime != deviceRuntime ? agentDeviceRuntime.inetDeviceId : 0;
        } else {
            agentDeviceId = 0;
            agentDeviceRuntime = deviceRuntime;
        }
        K key = this.getKey(device, servSearchMode, (int)deviceRuntime.inetDeviceId, agentDeviceId, agentDeviceRuntime, request, macString, null);
        return (E)this.connectionMap.get(key);
    }
}

