/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.UtilEvalError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.modules.ipn.server.BGMethodNotFoundException;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;

public abstract class GateWorker
extends Thread {
    protected int mid;
    protected Gate gate;
    protected final Logger log = LogManager.getLogger();
    protected Connection con;
    protected StringBuilder gateErrors = new StringBuilder(256);
    protected List<UserStatus> statusList = new ArrayList<UserStatus>();
    protected Map<Integer, RuleType> ruleTypeMap = null;
    protected Map<Integer, GateType> gateTypeMap = null;
    protected GateType gateType = null;
    private boolean useScript = false;

    public void init(Gate gate, Map<Integer, RuleType> ruleTypeMap, Map<Integer, GateType> gateTypeMap, int mid) {
        this.gate = gate;
        this.ruleTypeMap = ruleTypeMap;
        this.gateTypeMap = gateTypeMap;
        this.mid = mid;
        this.gateType = gateTypeMap.get(gate.getTypeId());
        Preferences gateTypeSetup = new Preferences(this.gateType.getConfig(), "\r\n");
        this.useScript = gateTypeSetup.getInt("use.script", 0) == 1;
    }

    public void addUserStatus(int contractId, int status, RuleType ruleType, GateType gateType, UserGateRule rule, int mid) {
        UserStatus userStatus = new UserStatus();
        userStatus.contractId = contractId;
        userStatus.status = status;
        userStatus.ruleType = ruleType;
        userStatus.rule = rule;
        userStatus.mid = mid;
        userStatus.gateType = gateType;
        this.statusList.add(userStatus);
    }

    public String getGateErrors() {
        return this.gateErrors.toString();
    }

    @Override
    public void run() {
        this.con = null;
        try {
            this.log.debug("run");
            this.con = Setup.getSetup().getDBConnectionFromPool();
            this.doParentSync();
            this.runSync();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("Gate unaccesible - " + this.gate.getHost());
            this.log.error("-------------------------");
            this.log.error("error: " + e.getLocalizedMessage(), (Throwable)e);
            this.gateErrors.append("\u0428\u043b\u044e\u0437 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d - ");
            this.gateErrors.append(this.gate.getHost());
            this.gateErrors.append(" (" + this.gate.getComment() + ")");
            this.gateErrors.append("\n");
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                if (!(ex instanceof InterruptedException)) continue;
                this.log.error("thread was interrupted!!!!!!!!");
                this.interrupt();
            }
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    protected void runSync() throws EvalError, IOException {
        GateType gateType = this.gateTypeMap.get(this.gate.getTypeId());
        if (!this.useScript || !new Scripter(this.gate, this).runScriptSync(gateType.getScript())) {
            this.doSync();
        }
    }

    public boolean isWorking() {
        return this.isAlive();
    }

    protected abstract void doSync();

    public Gate getGate() {
        return this.gate;
    }

    public void doParentSync() throws ClassNotFoundException, InstantiationException, IllegalAccessException, EvalError, IOException {
        GateType type;
        Class<?> clazz;
        this.log.debug("doParentSync");
        Gate g = this.gate;
        while ((g = g.getParent()) != null && g.getTypeId() == 0) {
        }
        Gate parent = g;
        Gate child = this.gate;
        if (parent != null && GateWorker.class.isAssignableFrom(clazz = Class.forName((type = this.gateTypeMap.get(parent.getTypeId())).getGateManager()))) {
            GateWorker parentGateWorker = clazz.asSubclass(GateWorker.class).newInstance();
            parentGateWorker.init(parent, this.ruleTypeMap, this.gateTypeMap, this.mid);
            parentGateWorker.gateErrors = this.gateErrors;
            GateType parentGateType = this.gateTypeMap.get(parent.getTypeId());
            Preferences parentGateTypeSetup = new Preferences(parentGateType.getConfig(), "\r\n");
            boolean parentUseScript = parentGateTypeSetup.getInt("use.script", 0) == 1;
            for (UserStatus status : this.statusList) {
                parentGateWorker.addUserStatus(status.contractId, status.status, status.ruleType, type, status.rule, status.mid);
            }
            if (!parentUseScript || !new ScripterParent(parent, parentGateWorker, this, child).runScriptSync(type.getScript())) {
                parentGateWorker.parentSync(child, this);
            }
        }
    }

    public void parentSync(Gate child, GateWorker childWorker) {
        try {
            this.doParentSync();
            this.runSync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGateErrors(StringBuilder gateErrors) {
        this.gateErrors = gateErrors;
    }

    class Scripter {
        protected Gate gate;
        private GateWorker worker;

        public Scripter(Gate gate, GateWorker worker) {
            this.gate = gate;
            this.worker = worker;
        }

        public boolean runScriptSync(String script) throws EvalError, IOException {
            boolean result = true;
            Interpreter it = new Interpreter();
            it.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
            GateWorker.this.log.info("Running script ");
            it.set("con", (Object)GateWorker.this.con);
            it.set("gate", (Object)this.gate);
            it.set("ruleTypeMap", GateWorker.this.ruleTypeMap);
            it.set("gateTypeMap", GateWorker.this.gateTypeMap);
            it.set("log", (Object)GateWorker.this.log);
            it.set("statusList", GateWorker.this.statusList);
            it.set("gateErrors", (Object)GateWorker.this.gateErrors);
            it.set("mid", GateWorker.this.mid);
            it.set("worker", (Object)this.worker);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ByteArrayOutputStream exeption = new ByteArrayOutputStream();
            StringBuilder warnings = new StringBuilder();
            it.setOut(new PrintStream(out));
            it.setErr(new PrintStream(err));
            long time = System.currentTimeMillis();
            try {
                result = this.invokeMethod(it, script);
                ScriptInstance.DeprecatedCheker.checkOnDeprecated((Interpreter)it, (String)(this.gate.getHost() + ":" + this.gate.getPort() + "[" + this.gate.getComment() + "]"), (StringBuilder)warnings);
            }
            catch (BGMethodNotFoundException ex) {
                return false;
            }
            catch (Exception ex) {
                GateWorker.this.log.error("Eval error2: " + ex.getMessage(), (Throwable)ex);
                exeption.write(ex.getMessage().getBytes());
                ex.printStackTrace(new PrintStream(exeption));
                throw new RuntimeException(ex);
            }
            long processTime = System.currentTimeMillis() - time;
            GateWorker.this.log.info("Process time => " + processTime);
            if (out.size() > 0) {
                GateWorker.this.log.info(out.toString());
            }
            if (err.size() > 0) {
                GateWorker.this.log.error(err.toString());
            }
            return result;
        }

        protected boolean invokeMethod(Interpreter it, String script) throws EvalError, BGMethodNotFoundException, UtilEvalError {
            BshMethod method = null;
            it.eval(script);
            method = it.getNameSpace().getMethod("doSync", new Class[0]);
            if (method != null) {
                method.invoke(new Object[0], it);
            }
            return method != null;
        }
    }

    class ScripterParent
    extends Scripter {
        private GateWorker childWorker;
        private Gate child;

        public ScripterParent(Gate gate, GateWorker worker, GateWorker childWorker, Gate child) {
            super(gate, worker);
            this.childWorker = childWorker;
            this.gate = gate;
            this.child = child;
        }

        @Override
        protected boolean invokeMethod(Interpreter it, String script) throws EvalError, BGMethodNotFoundException, UtilEvalError {
            BshMethod method = null;
            Class[] clList = new Class[]{Gate.class, GateWorker.class};
            it.eval(script);
            method = it.getNameSpace().getMethod("parentSync", clList);
            Object[] params = new Object[]{this.child, this.childWorker};
            if (method != null) {
                method.invoke(params, it);
            }
            return method != null;
        }
    }
}

