/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class WebLogTabLogon
extends BGUPanel {
    public static final String LOG_TYPE_OK = "ok";
    public static final String LOG_TYPE_ERROR = "error";
    private String logType = null;
    private BGTable table = new BGTable();

    public WebLogTabLogon(String logType) {
        String rbName = this.getClass().getPackage().getName() + ".setup";
        Document moduleDoc = ClientUtils.getModuleDoc(rbName);
        if (logType != null && LOG_TYPE_OK.equals(logType)) {
            this.logType = logType;
            this.table.setHeader(rbName, moduleDoc, "logon.ok");
        } else if (logType != null && LOG_TYPE_ERROR.equals(logType)) {
            this.logType = logType;
            this.table.setHeader(rbName, moduleDoc, "logon.error");
        } else {
            this.logType = null;
        }
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public Document setQuery(int pageIndex, int pageSize, String date1, String date2, String conId, String filterQuery) {
        Document doc;
        Request request = new Request().setModule("admin").setAction("WebLogonLog").setPageIndex(pageIndex).setPageSize(pageSize).setAttribute("logType", this.logType).setAttribute("query_filter", filterQuery);
        Optional.ofNullable(date1).ifPresent(a -> request.setAttribute("date1", (String)a));
        Optional.ofNullable(date2).ifPresent(a -> request.setAttribute("date2", (String)a));
        if (conId != null && conId.length() > 0) {
            request.setAttribute("contracts", conId);
        }
        if (ClientUtils.checkStatus(doc = TransferManager.getDocument(request))) {
            Node node = XMLUtils.getNode(doc, "table");
            this.table.updateData(node);
        }
        return doc;
    }

    public void clearTable() {
        this.table.removeRows();
    }
}

