/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.updater.server.bean;

import io.jsonwebtoken.io.IOException;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.Setup;

public class UpdaterUtils {
    private static Logger logger = LogManager.getLogger();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void scanNewTask() {
        try {
            for (BGInstalledModule module : ModuleCache.getInstance().getInstalledModulesList()) {
                String path = (File.separatorChar + module.getPackageServer() + ".updater").replace('.', File.separatorChar);
                System.out.println(path);
                URL url = UpdaterUtils.class.getResource(path);
                System.out.println(url);
                if (url == null) continue;
                String dirName = url.getFile();
                System.out.println("dirName = " + dirName);
                File directory = new File(url.toURI());
                if (directory != null && directory.exists()) {
                    for (String file : directory.list()) {
                        if (!file.endsWith(".class")) continue;
                        Class<?> clazz = Class.forName(module.getPackageServer() + ".updater." + file.substring(0, file.length() - 6));
                        System.out.println(clazz);
                    }
                    continue;
                }
                try {
                    String jarPath = url.getFile().replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
                    JarFile jarFile = new JarFile(jarPath);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(path) || entryName.length() <= path.length() + "/".length()) continue;
                        System.out.println("ClassDiscovery: JarEntry: " + entryName);
                        String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
                        System.out.println("ClassDiscovery: className = " + className);
                        try {
                            Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("ClassNotFoundException loading " + className);
                        }
                    }
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(path + " (" + directory + ") does not appear to be a valid package", e);
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        Setup.setSetup((Setup)new Setup("data", "data"));
        UpdaterUtils.scanNewTask();
    }
}

