/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.common.bean;

import java.util.Calendar;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.common.TimeUtils;

public class StatusEvent {
    private int cardPacketId;
    private int status;
    private Calendar time;
    private int userId;

    public int getCardPacketId() {
        return this.cardPacketId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStringStatus() {
        return CardPacket.getStringStatus(this.status);
    }

    public Calendar getTime() {
        return this.time;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setCardPacketId(int cardPacketId) {
        this.cardPacketId = cardPacketId;
    }

    public void setStatus(int type) {
        this.status = type;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "cardPacket#%d; %s; %s; user#%d".formatted(this.cardPacketId, TimeUtils.formatDate((Calendar)this.time), this.getStringStatus(), this.userId);
    }

    public static class Builder {
        private StatusEvent event = new StatusEvent();

        private Builder() {
        }

        public Builder setCardPacketId(int cardPacketId) {
            this.event.cardPacketId = cardPacketId;
            return this;
        }

        public Builder setStatus(int type) {
            this.event.status = type;
            return this;
        }

        public Builder setTime(Calendar time) {
            this.event.time = time;
            return this;
        }

        public Builder setUserId(int userId) {
            this.event.userId = userId;
            return this;
        }

        public StatusEvent build() {
            try {
                StatusEvent statusEvent = this.event;
                return statusEvent;
            }
            finally {
                this.event = null;
            }
        }
    }
}

