/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.plugins.crm.common.model.AddressFilter;
import ru.bitel.bgbilling.plugins.crm.server.model.PhoneParam;
import ru.bitel.common.Utils;

public class TaskFilter {
    public int id;
    public int contractId;
    public int processed;
    public String types;
    public String statusMask;
    public String dateType;
    public String fioParams;
    public String executors;
    public String groups;
    public Calendar dateFrom;
    public Calendar dateTo;
    public AddressFilter addressFilter;
    public List<String> orders;
    private List<PhoneParam> phoneParams = new ArrayList<PhoneParam>();

    public List<PhoneParam> getPhoneParams() {
        return this.phoneParams;
    }

    public void setPhoneParams(String value) {
        this.phoneParams.clear();
        if (value != null) {
            StringTokenizer st1 = new StringTokenizer(value, ",");
            while (st1.hasMoreTokens()) {
                String param = st1.nextToken().trim();
                int paramType = 9;
                int paramId = 0;
                int pos = param.indexOf(58);
                if (pos > -1) {
                    String type = param.substring(0, pos);
                    if ("text".equalsIgnoreCase(type)) {
                        paramType = 1;
                    }
                    paramId = Utils.parseInt((String)param.substring(pos + 1), (int)0);
                } else {
                    paramId = Utils.parseInt((String)param, (int)0);
                }
                if (paramId <= 0) continue;
                PhoneParam phoneParam = new PhoneParam();
                phoneParam.paramId = paramId;
                phoneParam.paramType = paramType;
                this.phoneParams.add(phoneParam);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TaskFilter filter = new TaskFilter();

        private Builder() {
        }

        public Builder setId(int id) {
            this.filter.id = id;
            return this;
        }

        public Builder setContractId(int contractId) {
            this.filter.contractId = contractId;
            return this;
        }

        public Builder setTypes(String types) {
            this.filter.types = types;
            return this;
        }

        public Builder setFioParams(String fioParams) {
            this.filter.fioParams = fioParams;
            return this;
        }

        public Builder setProcessed(int processed) {
            this.filter.processed = processed;
            return this;
        }

        public TaskFilter build() {
            try {
                TaskFilter taskFilter = this.filter;
                return taskFilter;
            }
            finally {
                this.filter = null;
            }
        }
    }
}

