/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.common.Preferences;

public class ActionGateRuleControl
extends AbstractAction {
    public ActionGateRuleControl() {
        super("ipn");
    }

    public void execute() throws BGException {
        if (this.req.get("save", null) != null) {
            this.update();
        }
        this.list();
    }

    private void list() throws BGException {
        ArrayList<String> gates = new ArrayList<String>();
        try {
            UserGateRuleManager man = new UserGateRuleManager(this.con, this.moduleId);
            List<UserGateRule> rules = man.getUserGateRules(this.contractId);
            for (UserGateRule rule : rules) {
                Gate gate;
                Preferences gateSetup;
                if (rule.getRuleTypeId() <= 0 || (gateSetup = new Preferences((gate = new GateManager(this.con, this.moduleId).getGateById(rule.getGateId())).getConfig(), "\r\n")).getInt("customer.control", 0) <= 0) continue;
                JSONObject map = new JSONObject();
                map.put("id", gate.getId());
                map.put("title", (Object)gate.getTitle());
                map.put("ruleTypeId", rule.getRuleTypeId());
                RuleTypeManager typeManager = new RuleTypeManager(this.con, this.moduleId);
                JSONArray list = new JSONArray();
                List<RuleType> types = typeManager.getTypeList(gate.getTypeId());
                boolean found = false;
                for (RuleType type : types) {
                    this.addRuleType(list, type);
                    found |= type.getId() == rule.getRuleTypeId();
                }
                if (!found) {
                    this.addRuleType(list, typeManager.getType(rule.getRuleTypeId()));
                }
                map.put("list", (Object)list);
                gates.add(map.toString());
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        this.setResultParam("gates", gates);
    }

    private void addRuleType(JSONArray list, RuleType type) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", type.getId());
        jsonObject.put("title", (Object)type.getTitle());
        list.put((Object)jsonObject);
    }

    private void update() {
        for (Map.Entry e : this.req.sub("gate_").entrySet()) {
            int gateId = Integer.valueOf((String)e.getKey());
            int ruleTypeId = Integer.valueOf((String)e.getValue());
            UserGateRuleManager man = new UserGateRuleManager(this.con, this.moduleId);
            UserGateRule rule = man.getUserGateRule(gateId, this.contractId);
            rule.setRuleTypeId(ruleTypeId);
            man.updateUserGateRule(String.valueOf(rule.getId()), rule, -1);
        }
    }
}

