jQuery.noConflict();

jQuery(document).ready( function() {
	init();
});

init = function() {
	var i = navigator.userAgent.indexOf("MSIE");
	if ( i!=0 ) {
		window.__browserIE = true;
		window.__browserVersion = parseFloat(navigator.userAgent.substring(i+5));
	}
}

$ = function( element ) {
	return document.getElementById(element);
}

setPage = function ( page_num ) {
	var page = document.getElementById("idPageIndex");
	page.value = page_num;
	page.form.submit();
}

getWidth = function() {
	if (window.__browserIE&&window.__browserVersion<7)
		return (document.body.clientWidth > 1100)?"800px":((document.body.clientWidth > 900)?"100%":"600px");
	else
		return "100%";
}

function setPageTitle( title )
{
	jQuery("div#pageTitle").html( title );
}

function disableButton( button ) 
{	
	button.disabled = true;	   
}

function showBlock( id, operation, inQuery, dataType ) 
{
	dataType = dataType || 'html';
	let processData = true;
	let contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
	let query = Object.assign({}, inQuery);
	if ( typeof operation == 'string' ) {
		query.operation = operation; 
	} 
	else if ( operation instanceof FormData ) {
		operation.set( 'action', inQuery.action );
		operation.set( 'module', inQuery.module );
		operation.set( 'mid', inQuery.mid );
		operation.set( 'contractId', inQuery.contractId );
		query = operation;
		processData = false;
		contentType = false;
	}
	else { jQuery.extend( query, operation ) };
	//
	let url = contextPath + "/" + webexecuter;
	if ( !query.module )
	{
		url = url + "/" + query.mid + "/" + query.action; 
	}
    jQuery.ajax(
	{
		url: url,
		type: 'POST',
		dataType: dataType,    
		data: query,
		processData: processData,
	    contentType: contentType,
		statusCode: { 302: function() {  } }	    
	})
	.done(function( data, textStatus, jqXHR  )
	{
		let bgRedirectPage = jqXHR.getResponseHeader( "bg-redirect-to" );
		if ( bgRedirectPage )
		{
			window.location.replace( bgRedirectPage );
			return false;
		}
		
		if ( typeof( data ) == 'string' )
		{
			let divEl = document.getElementById(id);
			if ( typeof divEl !== 'undefined' )
			{
				jQuery( "div#"+id ).html(data); 
				window.scrollBy(0, -1000);
			}
		}
		else if ( typeof( data ) == 'object' )
		{
			//alert( JSON.stringify( data ) );
			if ( data.errorList )
			{
				let text = "";
				data.errorList.forEach( (item) => { text = text + "<p>* " + item + "</p>" } );
				showError( { text: text } );
			}
			else if ( data.operation )
			{
				showBlock( id, data.operation, Object.assign(inQuery, data.queryParam) );
			}
		}
		return false;
	});
	return false;
}

function showError( message )
{
	document.getElementById( "bgModal2" ).style.display = 'block';
	document.getElementById( "bgModal2-message-title" ).innerHTML = message.title ? message.title : "Ошибка";
	document.getElementById( "bgModal2-message-text" ).innerHTML = message.text;
}

//function showPopup( name )
//{
//	var elem = null;
//	if ( document.getElementById )
//	{
//	  elem = document.getElementById(name);
//	}
//	else
//	{
//	  elem = eval("document.all." + name );
//	}
//	if ( elem != null )
//	{
//		elem.style.visibility = "visible";
//		elem.style.display = 'block';
//	}
//}
//
//function hidePopup( name )
//{
//	var elem = null;
//	if ( document.getElementById )
//	{
//	  elem = document.getElementById(name);
//	}
//	else
//	{
//	  elem = eval("document.all." + name );
//	}
//	if ( elem != null )
//	{
//		elem.style.visibility = 'hidden';
//		elem.style.display = 'none';
//	}
//}
