/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.inet;

import java.util.Arrays;
import java.util.Comparator;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.util.Ranger;
import ru.bitel.common.util.SegmentedRangeSet;

public class IpAddressRangeSet<R>
extends SegmentedRangeSet<IpAddress, byte[], R> {
    protected static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return IpAddress.compare(o1, o2);
        }
    };
    protected final IpAddressSegmenter<R> segmenter;

    public static <K extends IpRange> IpAddressRangeSet<K> newInstance(Class<K> clazz, int maskLength) {
        return new IpAddressRangeSet<K>(clazz, new IpRanger(), false, maskLength);
    }

    public IpAddressRangeSet(Class<R> clazz, Ranger<R, byte[]> ranger, boolean bites, int maskLength) {
        super(clazz, byte[].class, COMPARATOR, ranger, bites ? new BitsIpAddressSegmenter<R>(ranger, maskLength) : new IpAddressSegmenter<R>(ranger, maskLength));
        this.segmenter = (IpAddressSegmenter)((SegmentedRangeSet)this).segmenter;
    }

    public static final class IpRanger<R extends IpRange>
    implements Ranger<R, byte[]> {
        @Override
        public byte[] getMinValue(R r) {
            return ((IpRange)r).getAddressFrom();
        }

        @Override
        public byte[] getMaxValue(R r) {
            return ((IpRange)r).getAddressTo();
        }
    }

    static class BitsIpAddressSegmenter<R>
    extends IpAddressSegmenter<R> {
        BitsIpAddressSegmenter(Ranger<R, byte[]> ranger, int maskLength) {
            super(ranger, maskLength);
        }

        @Override
        public byte[] segmentKey(byte[] address) {
            byte[] segmentKey = Arrays.copyOf(address, address.length);
            for (int i = 0; i < this.maskLength; ++i) {
                int n = segmentKey.length - i / 8 - 1;
                segmentKey[n] = (byte)(segmentKey[n] & ~(1 << i % 8));
            }
            return segmentKey;
        }

        @Override
        public IpAddress segmentKey(R serv) {
            byte[] addressFrom = (byte[])this.ranger.getMinValue(serv);
            byte[] addressTo = (byte[])this.ranger.getMaxValue(serv);
            byte[] addressMaskFrom = Arrays.copyOf(addressFrom, addressFrom.length);
            byte[] addressMaskTo = Arrays.copyOf(addressTo, addressTo.length);
            for (int i = 0; i < this.maskLength; ++i) {
                int n = addressFrom.length - i / 8 - 1;
                addressMaskFrom[n] = (byte)(addressMaskFrom[n] & ~(1 << i % 8));
                int n2 = addressMaskTo.length - i / 8 - 1;
                addressMaskTo[n2] = (byte)(addressMaskTo[n2] & ~(1 << i % 8));
            }
            if (IpAddress.equals(addressMaskFrom, addressMaskTo)) {
                return new IpAddress(addressMaskFrom);
            }
            return null;
        }
    }

    public static class IpAddressSegmenter<R>
    implements SegmentedRangeSet.Segmenter<IpAddress, R> {
        protected final int maskLength;
        protected final Ranger<R, byte[]> ranger;

        IpAddressSegmenter(Ranger<R, byte[]> ranger, int maskLength) {
            this.ranger = ranger;
            this.maskLength = maskLength;
        }

        @Override
        public byte[] segmentKey(byte[] address) {
            return Arrays.copyOf(address, address.length - this.maskLength);
        }

        @Override
        public IpAddress segmentKey(R serv) {
            byte[] addressFrom = this.ranger.getMinValue(serv);
            byte[] addressTo = this.ranger.getMaxValue(serv);
            byte[] addressMaskFrom = Arrays.copyOf(addressFrom, addressFrom.length - this.maskLength);
            for (int i = addressMaskFrom.length - 1; i >= 0; --i) {
                if (addressMaskFrom[i] == addressTo[i]) continue;
                return null;
            }
            return new IpAddress(addressMaskFrom);
        }
    }
}

