/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.net.SocketAddress;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.processor.Processor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public abstract class DhcpProcessor<D extends Idable>
extends Processor {
    protected final String module;
    protected final int mid;
    public final int sendFix;

    public DhcpProcessor(Setup setup, String module, int mid) {
        super(setup);
        this.module = module;
        this.mid = mid;
        Preferences moduleSetup = setup.getModuleSetup(mid);
        if (moduleSetup == null) {
            moduleSetup = setup;
        }
        this.sendFix = moduleSetup.getInt("dhcp.sendFix", 2);
    }

    public abstract void processRequest(DhcpListenerWorker<D> var1, SocketAddress var2, DhcpPacket var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(DhcpListenerWorker<D> req, int[] requestPositions, int[] responsePositions, long now) throws BGException {
        if (req.isConnectionModified() && req.connectionId != 0L) {
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);
                 ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.mid);){
                ConnectionLogEntry entry = new ConnectionLogEntry();
                entry.setApplicationId(SetupParam.getApplicationId((ParameterMap)this.setup));
                entry.setDeviceId(req.device.getId());
                entry.setDevicePort(req.interfaceId);
                entry.setTime(new Date(now));
                entry.setAcctSessId(Integer.toHexString(req.request.xid));
                entry.setConnectionId(req.connectionId);
                entry.setLogType(5);
                entry.setRequestDataLogId(requestPositions[0]);
                entry.setRequestChunkId(requestPositions[1]);
                entry.setRequestPosition(requestPositions[2]);
                entry.setResponseDataLogId(responsePositions[0]);
                entry.setResponseChunkId(responsePositions[1]);
                entry.setResponsePosition(responsePositions[2]);
                dataLogEntryDao.update(entry);
            }
        }
    }
}

