/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractCityItemDao;

public class StreetDao
extends AbstractCityItemDao<Street> {
    public StreetDao(Connection con) {
        super(con, "address_street");
    }

    @Override
    protected Street newBean() {
        return new Street();
    }

    public String getPostIndex(int streetId) throws BGException {
        String index = null;
        String query = "SELECT p_index FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, streetId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    index = rs.getString(1);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return index;
    }

    public List<Street> search(int cityId, String title, String cityTitle, Page page) throws BGException {
        ArrayList<Street> arrayList;
        block24: {
            if (Utils.isBlankString((String)title) && Utils.isBlankString((String)cityTitle)) {
                return this.list(cityId, title);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT address_street.*, city.title as cityTitle, CONCAT(city.title, ', ', address_street.title) as tt, country.*, city.* FROM " + this.tableName + " ");
            sb.append(" LEFT JOIN address_city as city ON city.id=address_street.cityid");
            sb.append(" LEFT JOIN address_country as country ON country.id=city.country_id");
            sb.append(" WHERE true");
            if (!Utils.isBlankString((String)cityTitle)) {
                sb.append(" AND city.title LIKE ?");
            }
            String[] args = title.split("\\s+");
            if (Utils.notBlankString((String)title)) {
                sb.append(" AND address_street.title LIKE ?".repeat(args.length));
            }
            sb.append(" ORDER BY address_street.title");
            int pageSize = 0;
            int pageIndex = 0;
            if (page != null) {
                pageSize = page.getPageSize();
                pageIndex = page.getPageIndex();
                if (pageIndex <= 0) {
                    pageSize = 0;
                }
            }
            sb.append(this.sqlLimit(page));
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            try {
                int idx = 0;
                if (!Utils.isBlankString((String)cityTitle)) {
                    ps.setString(++idx, "%" + cityTitle + "%");
                }
                if (Utils.notBlankString((String)title)) {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].length() <= 0) continue;
                        ps.setString(++idx, "%" + args[i] + "%");
                    }
                }
                ArrayList<Street> result = new ArrayList<Street>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add((Street)this.getFromRS(rs));
                    }
                }
                arrayList = result;
                if (ps == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return arrayList;
    }

    @Override
    public List<Street> list() throws BGException {
        return super.list(null, this.tableName + ".title", new Object[0]);
    }

    public void searchStreetList(SearchResult<Street> searchResult, int cityId, String streetMask) {
        if (searchResult != null) {
            super.searchStreetList(searchResult, cityId, streetMask, a -> {
                try {
                    return (Street)this.getFromRS((ResultSet)a);
                }
                catch (Exception ex) {
                    this.logError(ex);
                    return null;
                }
            });
        }
    }

    public int cityStreetCount(int cityId) throws BGException {
        return this.getEntityCount(cityId, "cityid");
    }
}

