/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;

public class ProductPeriodDao
extends AbstractIdDao<ProductPeriod> {
    public ProductPeriodDao(Connection con, int userId) {
        super(con, 0, "inv_product_period");
    }

    private int getVersion() throws SQLException {
        String query = "SELECT @vrsn";
        try (PreparedStatement selectVersionPS = this.con.prepareStatement(query);){
            int result;
            try (ResultSet rs = selectVersionPS.executeQuery();){
                result = rs.next() ? rs.getInt(1) + 1 : -1;
            }
            int n = result;
            return n;
        }
    }

    private ProductPeriod getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return ProductPeriod.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contractId")).setAccountId(rs.getInt("accountId")).setProductSpecId(rs.getInt("productSpecId")).setProductId(rs.getInt("productId")).setActivationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activationTime"))).setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeFrom"))).setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("timeTo"))).setProlongationTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("prolongationTime"))).setFlags(rs.getInt("flags")).build();
    }

    protected ProductPeriod getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(ProductPeriod b) throws BGException {
        try {
            this.updateImpl(b);
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    protected void updateImpl(ProductPeriod productPeriod) throws BGException, SQLException {
        if (productPeriod.getId() <= 0) {
            String query = "INSERT INTO " + this.tableName + " SET contractId=?, accountId=?, productSpecId=?, productId=?, activationTime=?, timeFrom=?, timeTo=?, prolongationTime=?, flags=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                Timestamp timeFrom = TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeFrom());
                int index = 1;
                ps.setInt(index++, productPeriod.getContractId());
                ps.setInt(index++, productPeriod.getAccountId());
                ps.setInt(index++, productPeriod.getProductSpecId());
                ps.setInt(index++, productPeriod.getProductId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getActivationTime()));
                ps.setTimestamp(index++, timeFrom);
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeTo()));
                ps.setTimestamp(index++, timeFrom);
                ps.setInt(index++, productPeriod.getFlags());
                ps.executeUpdate();
                productPeriod.setId(ServerUtils.lastInsertId(ps));
            }
        }
        String query = "UPDATE " + this.tableName + " SET timeFrom=?, timeTo=?, flags=?, version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)productPeriod.getTimeTo()));
            ps.setInt(index++, productPeriod.getFlags());
            ps.setInt(index++, productPeriod.getId());
            ps.executeUpdate();
            productPeriod.setVersion(this.getVersion());
        }
    }

    public int addFlag(int id, int flag) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET flags=flags|(?), version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL";
        try (PreparedStatement updateFlagsPS = this.con.prepareStatement(query);){
            int index = 1;
            updateFlagsPS.setInt(index++, flag);
            updateFlagsPS.setInt(index++, id);
            updateFlagsPS.executeUpdate();
        }
        return this.getVersion();
    }

    public int updatePeriod(int id, Date time, Date prolongationTime) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET timeTo=?, prolongationTime=?, flags=flags&~(1<<0), version=version+1 WHERE id=? AND (@vrsn:=version) IS NOT NULL";
        try (PreparedStatement updatePeriodPS = this.con.prepareStatement(query);){
            updatePeriodPS.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds((Date)time));
            updatePeriodPS.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds((Date)prolongationTime));
            updatePeriodPS.setInt(3, id);
            updatePeriodPS.executeUpdate();
        }
        return this.getVersion();
    }

    public List<ProductPeriod> list(int moduleId, int contractId, int accountId, boolean kernel, Date time) throws SQLException {
        return this.list(moduleId, contractId, accountId, kernel, time, time, true);
    }

    public Map<Integer, List<ProductPeriod>> contractProductPeriodListMap(Date timeTo) throws SQLException {
        HashMap<Integer, List<ProductPeriod>> result = new HashMap<Integer, List<ProductPeriod>>();
        String query = "SELECT product_period.* FROM " + this.tableName + " AS product_period LEFT JOIN inv_product_spec as spec ON product_period.productSpecId=spec.id  WHERE ? OR product_period.timeTo IS NULL OR product_period.timeTo>=? ORDER BY product_period.contractId, product_period.timeFrom";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setBoolean(index++, timeTo == null);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)timeTo));
            int curContractId = 0;
            ArrayList<ProductPeriod> productPeriods = new ArrayList<ProductPeriod>();
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int contractId = rs.getInt("contractId");
                    if (curContractId != contractId) {
                        curContractId = contractId;
                        productPeriods = new ArrayList();
                        result.put(curContractId, productPeriods);
                    }
                    productPeriods.add(this.getFromRS(rs, true));
                }
            }
        }
        return result;
    }

    public List<ProductPeriod> list(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, boolean needNonActive) throws SQLException {
        ArrayList<ProductPeriod> result = new ArrayList<ProductPeriod>();
        StringBuilder sb = new StringBuilder().append("SELECT product_period.* FROM ").append(this.tableName).append(" AS product_period").append(" LEFT JOIN inv_product_spec as spec ON product_period.productSpecId=spec.id ").append(" WHERE product_period.contractId=? AND (((? OR product_period.accountId=?) AND (? OR spec.moduleId=?)) OR (? AND spec.moduleId=0))").append(" AND (? OR product_period.timeFrom IS NULL OR product_period.timeFrom<=?)").append(" AND (? OR product_period.timeTo IS NULL OR product_period.timeTo>=?)");
        if (!needNonActive) {
            sb.append(" AND (product_period.timeTo IS NULL OR product_period.timeFrom<product.timeTo)");
        }
        sb.append(" ORDER BY product_period.timeFrom");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setInt(1, contractId);
            ps.setBoolean(2, accountId <= 0);
            ps.setInt(3, accountId);
            ps.setBoolean(4, moduleId <= 0);
            ps.setInt(5, moduleId);
            ps.setBoolean(6, kernel);
            ps.setBoolean(7, timeFrom == null);
            ps.setTimestamp(8, TimeUtils.convertDateToTimestamp((Date)timeFrom));
            ps.setBoolean(9, timeTo == null);
            ps.setTimestamp(10, TimeUtils.convertDateToTimestamp((Date)timeTo));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        return result;
    }

    public int deleteByProductId(int contractId, int id) throws Exception {
        return this.delete("contractId=? AND productId=?", new Object[]{contractId, id});
    }

    public List<ProductPeriod> list(int contractId, int productId) throws BGException {
        return this.list("contractId=? AND productId=?", "id", new Object[]{contractId, productId});
    }
}

