/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class TvAccountSpecTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    private final Set<Integer> tvAccountSpecIds;

    public TvAccountSpecTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.tvAccountSpecIds = Utils.toIntegerSet((String)parameterMap.get("tvAccountSpecIds", ""));
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        if (req.getTvAccountId() == 0) {
            return 0;
        }
        if (this.tvAccountSpecIds.size() == 0) {
            Set acceptedSet = req.getAcceptedSet(TvAccountSpecTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        TvAccountRuntimeMap tvAccountRuntimeMap = ctx.getTvAccountRuntimeMap();
        try {
            tvAccountRuntimeMap.load(workerContext.getConnectionSet(), req.contractId);
            TvAccountRuntime tvAccountRuntime = tvAccountRuntimeMap.get(req.getTvAccountId());
            if (!this.tvAccountSpecIds.contains(tvAccountRuntime.getTvAccount().getSpecId())) {
                return 0;
            }
            Set acceptedSet = req.getAcceptedSet(TvAccountSpecTariffTreeNode.class);
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        catch (Exception ex) {
            this.logError(ex);
            return 0;
        }
    }
}

