/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import bitel.billing.server.util.MonthForRecalc;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSessionUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoiceIpLoginManager
extends LoginManager {
    public VoiceIpLoginManager(Connection con, int moduleId) {
        super(con, moduleId);
    }

    public VoiceIpLogin getLoginFromResultSet(ResultSet rs) throws SQLException {
        VoiceIpLogin login = new VoiceIpLogin();
        login.setId(rs.getInt("id"));
        login.setContractId(rs.getInt("cid"));
        login.setLogin(rs.getLong("login"));
        login.setPswd(rs.getString("pswd"));
        login.setStatus(rs.getInt("status") == 0);
        login.setMaxSession(rs.getInt("session"));
        login.setType(rs.getInt("type"));
        login.setDate1(rs.getDate("date1"));
        login.setDate2(rs.getDate("date2"));
        login.setComment(rs.getString("comment"));
        login.setObjectId(rs.getInt("object_id"));
        return login;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAlias(String alias) {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT login_id FROM user_alias_" + this.mid + " WHERE login_alias=?");){
            ps.setString(1, alias);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<Long> getFirstAliases(List<long[]> ranges, int count) {
        ArrayList<Long> free;
        block7: {
            free = null;
            if (ranges != null) {
                try {
                    Collections.sort(ranges, new Comparator<long[]>(){

                        @Override
                        public int compare(long[] o1, long[] o2) {
                            return o1[0] < o2[0] ? -1 : (o1[0] == o2[0] ? 0 : 1);
                        }
                    });
                    HashSet<Long> z = new HashSet<Long>();
                    PreparedStatement ps = this.con.prepareStatement("SELECT login_alias FROM user_alias_" + this.mid + " WHERE login_alias regexp '^[0-9]+$'");
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        z.add(rs.getLong(1));
                    }
                    rs.close();
                    ps.close();
                    free = new ArrayList<Long>();
                    for (long[] range : ranges) {
                        for (long j = range[0]; j <= range[1]; ++j) {
                            if (z.contains(j)) continue;
                            free.add(j);
                            if (free.size() < count) {
                                continue;
                            }
                            break block7;
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return free;
    }

    public List<Integer> getFirstAliases(int[][] ranges) {
        if (ranges == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT login_alias FROM user_alias_" + this.mid + " WHERE ");
        for (int i = ranges.length; i > 0; --i) {
            sb.append("(login_alias>=? AND login_alias<=?) OR");
        }
        if (ranges.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        try {
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            LinkedList<Integer> free = new LinkedList<Integer>();
            ArrayList<Integer> z = new ArrayList<Integer>(3000);
            for (int i = 0; i < ranges.length; ++i) {
                for (int j = ranges[i][0]; j <= ranges[i][1]; ++j) {
                    free.add(j);
                }
            }
            int j = 1;
            for (int i = 0; i < ranges.length; ++i) {
                ps.setInt(j++, ranges[i][0]);
                ps.setInt(j++, ranges[i][1]);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int i = Utils.parseInt((String)rs.getString(1), (int)-1);
                if (i <= 0) continue;
                z.add(i);
            }
            rs.close();
            ps.close();
            free.removeAll(z);
            return free;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void moveLoginData(Login login, int cidFrom, int cidTo) throws SQLException {
        int lid = login.getId();
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)login.getDate1());
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)login.getDate2());
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                String query = "UPDATE " + sessionTable + " SET cid=? WHERE lid=?";
                PreparedStatement psUpdateSession = this.con.prepareStatement(query);
                psUpdateSession.setInt(1, cidTo);
                psUpdateSession.setInt(2, lid);
                psUpdateSession.executeUpdate();
                psUpdateSession.close();
            }
            dateMonth.add(2, 1);
        }
    }

    protected void wrapLoginData(Login loginFrom, Login loginTo) throws SQLException {
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)loginTo.getDate1());
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)loginTo.getDate2());
        if (date2 == null) {
            date2 = new GregorianCalendar();
        }
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                String query = "UPDATE " + sessionTable + " SET cid=?, lid=? WHERE lid=? AND session_start>=?";
                PreparedStatement psUpdateSession = this.con.prepareStatement(query);
                psUpdateSession.setInt(1, loginTo.getContractId());
                psUpdateSession.setInt(2, loginTo.getId());
                psUpdateSession.setInt(3, loginFrom.getId());
                psUpdateSession.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
                psUpdateSession.executeUpdate();
                psUpdateSession.close();
            }
            dateMonth.add(2, 1);
        }
    }

    public void recalcAfterMove(MonthForRecalc months, int cidFrom, int cidTo) throws SQLException {
        String sids = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)this.con, (int)this.mid, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)));
        if (Utils.notBlankString((String)sids)) {
            String query = "DELETE FROM contract_account WHERE cid IN (" + cidFrom + ", " + cidTo + ") AND yy=? AND mm=? AND sid IN ( " + sids + ")";
            PreparedStatement psDeleteAccount = this.con.prepareStatement(query);
            VoiceIpSessionUtils su = new VoiceIpSessionUtils(this.con, this.mid);
            BalanceUtils bu = new BalanceUtils(this.con);
            for (Calendar month : months.getMonths()) {
                psDeleteAccount.setInt(1, month.get(1));
                psDeleteAccount.setInt(2, month.get(2) + 1);
                psDeleteAccount.executeUpdate();
                su.setContractAccountFromSession(month.getTime(), cidFrom);
                bu.setBalanceFromAccount(cidFrom, month);
                su.setContractAccountFromSession(month.getTime(), cidTo);
                bu.setBalanceFromAccount(cidTo, month);
            }
            psDeleteAccount.close();
            bu.close();
        }
    }

    public VoiceIpLogin addLogin(Login login, Preferences moduleSetup) {
        VoiceIpLogin result = null;
        try {
            String query = null;
            PreparedStatement ps = null;
            int topNocardLogin = moduleSetup.getInt("top.nocard.login", 10000);
            query = "INSERT INTO " + this.tableName + " ( cid, login, date1, date2, status, comment, object_id, type, pswd ) SELECT ?, IF(MAX(login) IS NULL, 0, MAX(login) + 1), ?, ?, ?, ?, ?, ?, ? FROM " + this.tableName + " WHERE login<" + topNocardLogin;
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, login.getContractId());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)login.getDate1()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)login.getDate2()));
            ps.setInt(4, login.getStatus() ? 0 : 1);
            ps.setString(5, login.getComment());
            ps.setInt(6, login.getObjectId());
            ps.setInt(7, ((VoiceIpLogin)login).getType());
            ps.setString(8, login.getPswd());
            ps.executeUpdate();
            result = (VoiceIpLogin)this.getLoginById(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateLogin(Login login) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "UPDATE user_login_" + this.mid + " SET date1=?, date2=?, status=?, comment=?, object_id=?, type=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)login.getDate1()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)login.getDate2()));
            ps.setInt(3, login.getStatus() ? 0 : 1);
            ps.setString(4, login.getComment());
            ps.setInt(5, login.getObjectId());
            ps.setInt(6, ((VoiceIpLogin)login).getType());
            ps.setInt(7, login.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void doSpecificWrapActions(int newLoginId, Date dateOpen, Date dateClose, Login login, TableCopier tableCopier) throws SQLException {
    }

    public String checkAliases(Login login, Set<String> aliases) {
        return this.checkConflictAliases(login, aliases);
    }
}

