/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.script.FunctionEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.script.client.EventScriptTabPanel;
import ru.bitel.bgbilling.kernel.script.common.service.EventScriptService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class ScriptFunctions
extends BGTabPanel {
    private boolean globalScript = false;
    private FunctionEditor editor = null;
    private CardLayout cardLayout = new CardLayout();
    private BGTable table = new BGTable();
    private BGUComboBox<IdTitle> script_CB;

    public ScriptFunctions(boolean globalScript, EventScriptTabPanel parent) {
        super("ScriptFunctions", "\u0421\u043a\u0440\u0438\u043f\u0442\u044b \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
        this.module = "script";
        this.globalScript = globalScript;
        if (globalScript) {
            this.tabTitle = "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0445 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 ";
            this.tabID = "GlobalScriptFunctions";
        }
        this.editor = new FunctionEditor(this);
        this.editor.init(this.module, 0);
        try {
            this.script_CB = parent.getScriptCombo();
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "function");
        this.setData();
    }

    private void jbInit() throws Exception {
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)this.editor, "editor");
        this.add((Component)jPanel1, "table");
        this.cardLayout.show(this, "table");
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.editItem());
    }

    private void startEdit(String id) {
        IdTitle scriptItem = (IdTitle)this.script_CB.getSelectedItem();
        if (scriptItem != null || this.globalScript) {
            this.editor.setId(id);
            this.cardLayout.show(this, "editor");
            this.editor.trySetData();
        }
    }

    public void hideEditor() {
        this.cardLayout.show(this, "table");
        this.setData();
    }

    @Override
    public void setData() {
        Request req;
        Document doc;
        String scriptId = null;
        if (this.globalScript) {
            scriptId = "0";
        } else {
            IdTitle scriptItem = (IdTitle)this.script_CB.getSelectedItem();
            if (scriptItem != null) {
                scriptId = Integer.toString(scriptItem.getId());
            }
        }
        if (scriptId != null && ClientUtils.checkStatus(doc = this.getDocument(req = new Request().setModule(this.module).setAction("FunctionTable").setAttribute("script_id", scriptId)))) {
            this.tryCall(() -> this.table.updateData(XMLUtils.selectNode(doc, "/data/table")));
        }
        this.init = false;
    }

    @Override
    public void newItem() {
        if (this.editor.isShowing()) {
            this.editor.newItem();
            return;
        }
        this.startEdit("new");
    }

    @Override
    public void editItem() {
        if (this.editor.isShowing()) {
            this.editor.editItem();
            return;
        }
        String id = ClientUtils.getRowId(this.table);
        this.startEdit(id);
    }

    @Override
    public void deleteItem() {
        if (this.editor.isShowing()) {
            this.editor.deleteItem();
            return;
        }
        String id = ClientUtils.getRowId(this.table);
        if (id != null && JOptionPane.showConfirmDialog(BGClientBase.getFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u0441\u044f \u0432\u043c\u0435\u0441\u0442\u0435 \u0441 \u0431\u044d\u043a\u0430\u043f\u0430\u043c\u0438. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0443\u043d\u043a\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getContext().getPort(EventScriptService.class).deleteFunction(Utils.parseInt(id));
                this.setData();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    public boolean isGlobalScript() {
        return this.globalScript;
    }
}

