/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.util.Iter;
import bitel.billing.server.util.PagedList;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.phone.server.action.ActionMailDispatch;
import ru.bitel.bgbilling.modules.phone.server.bean.Report;
import ru.bitel.bgbilling.modules.phone.server.bean.ReportManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReportAmount
extends ActionMailDispatch {
    private static final HashMap<String, Integer> paramMap = new HashMap();

    @Override
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        super.doAction();
        if (this.showAll || this.html) {
            this.page.setPageSize(-1);
        }
        ReportManager reportManager = new ReportManager(this.con, this.mid);
        PagedList<Report> pointCostList = reportManager.getCostList(this.cid, this.items, this.date1, this.date2, this.type, this.noFree, this.page);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Report report : pointCostList.list) {
            Element rep = this.createElement(data, "row");
            rep.setAttribute("item_id", String.valueOf(report.getClientItemId()));
            rep.setAttribute("item", report.getClientItem());
            rep.setAttribute("number", String.valueOf(report.getNumber()));
            rep.setAttribute("time", Utils.formatSessionTime((int)report.getTime()));
            rep.setAttribute("time_round", Utils.formatSessionTime((int)report.getTimeRound()));
            rep.setAttribute("cost", Utils.formatSessionCost((BigDecimal)report.getCost()));
        }
        this.setPageAttribute(table, pointCostList.page);
        table.setAttribute("count", String.valueOf(pointCostList.records));
        table.setAttribute("total_number", String.valueOf(((Report)pointCostList.total).getNumber()));
        table.setAttribute("total_cost", Utils.formatCost((BigDecimal)((Report)pointCostList.total).getCost()));
        float time = ((Report)pointCostList.total).getTime();
        table.setAttribute("total_time", Utils.formatSessionTime((int)((Report)pointCostList.total).getTime()) + " [" + Math.round(time / 60.0f) + "]");
        time = ((Report)pointCostList.total).getTimeRound();
        table.setAttribute("total_time_round", Utils.formatSessionTime((int)((Report)pointCostList.total).getTimeRound()) + " [" + Math.round(time / 60.0f) + "]");
        this.rootNode.setAttribute("action", "DispatchSession");
        this.rootNode.setAttribute("xslt", "phone.xsl");
        if (this.html) {
            this.rootNode.setAttribute("action", "DispatchSession");
            if (this.csv) {
                this.rootNode.setAttribute("xslt", "phone_login_amount_csv.xsl");
            } else {
                this.rootNode.setAttribute("xslt", "phone_login_amount.xsl");
            }
            table.setAttribute("reportTitle", this.moduleSetup.get("phone.report.dispatchdirect.title", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0435"));
            ContractDao contractDao = new ContractDao(this.con, 0);
            Contract contract = (Contract)contractDao.get(this.cid);
            contractDao.close();
            table.setAttribute("contractTitle", contract.getTitle());
            table.setAttribute("comment", contract.getComment());
            table.setAttribute("date1", TimeUtils.formatDate((Calendar)this.date1));
            table.setAttribute("date2", TimeUtils.formatDate((Calendar)this.date2));
            table.setAttribute("type", String.valueOf(this.type));
            HashMap<String, Object> params = new HashMap<String, Object>();
            Iterator<Report> iter = pointCostList.list.iterator();
            params.put("beans", new Iter.PublicIter(iter));
            params.put("lines", new CSVLine(iter));
            params.put("size", new Iter.BeanNodeList(pointCostList.list.size()));
            this.transformerParameters = params;
            if (this.request != null) {
                this.request.setAttribute("bitel.billing.server.transformer.parameters", params);
            }
        }
    }

    static {
        paramMap.put("item_id", 1);
        paramMap.put("item", 2);
        paramMap.put("number", 3);
        paramMap.put("time", 4);
        paramMap.put("time_round", 5);
        paramMap.put("cost", 6);
    }

    public static class CSVLine {
        private Iterator<Report> reports;
        private int[] mask;
        private final StringBuilder sb = new StringBuilder();

        public CSVLine(Iterator<Report> reportList) {
            this.reports = reportList;
        }

        public void init(String pattern) {
            String[] params = Utils.patternSemicolon.split(pattern);
            this.mask = new int[params.length];
            int i = 0;
            for (String param : params) {
                this.mask[i++] = paramMap.get(param);
            }
        }

        public String next() {
            this.sb.setLength(0);
            Report report = this.reports.next();
            for (int i : this.mask) {
                switch (i) {
                    case 1: {
                        this.sb.append(String.valueOf(report.getClientItemId()));
                        break;
                    }
                    case 2: {
                        this.sb.append(String.valueOf(report.getClientItem()));
                        break;
                    }
                    case 3: {
                        this.sb.append(String.valueOf(report.getNumber()));
                        break;
                    }
                    case 4: {
                        this.sb.append(String.valueOf(Utils.formatSessionTime((int)report.getTime())));
                        break;
                    }
                    case 5: {
                        this.sb.append(String.valueOf(Utils.formatSessionTime((int)report.getTimeRound())));
                        break;
                    }
                    case 6: {
                        this.sb.append(String.valueOf(report.getCost()));
                    }
                }
                this.sb.append(';');
            }
            return this.sb.toString();
        }
    }
}

