/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoLogin;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoTypeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class TrayInfoLoginManager {
    private Connection con;
    private int mid = -1;

    public TrayInfoLoginManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public TrayInfoLogin getTrayInfoLogin(int id) throws BGException {
        TrayInfoLogin result = null;
        try {
            ResultSet rs = this.con.createStatement().executeQuery("SELECT login.*, contract.title as contract_title, contract.comment as contract_comment  FROM trayinfo_login_" + this.mid + " AS login  LEFT JOIN contract ON contract.id = login.cid  WHERE login.id=" + id);
            if (rs.next()) {
                result = new TrayInfoLogin();
                TrayInfoLoginManager.loadLoginFromRS(rs, result);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteTrayInfoLogin(int id) throws BGException {
        try {
            String query = "DELETE FROM trayinfo_login_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<TrayInfoLogin> getContractLoginsList(int cid) throws BGException {
        ArrayList<TrayInfoLogin> result = new ArrayList<TrayInfoLogin>();
        try {
            String query = "SELECT login.*, contract.title as contract_title, contract.comment as contract_comment  FROM trayinfo_login_" + this.mid + " AS login  LEFT JOIN contract ON contract.id = login.cid  WHERE (?=-1 OR login.cid=?) ORDER BY login.date1 DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TrayInfoLogin login = new TrayInfoLogin();
                TrayInfoLoginManager.loadLoginFromRS(rs, login);
                result.add(login);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void addTrayInfoLogin(int cid, String pswd, Date date1, Date date2) throws BGException {
        try {
            String query = "INSERT INTO trayinfo_login_" + this.mid + " ( type, cid, pswd, date1, date2 ) VALUES ( ?, ?, ?, ?, ? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, 0);
            ps.setInt(2, cid);
            ps.setString(3, pswd);
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean hasActiveLogin(int cid, Date time) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT id FROM trayinfo_login_" + this.mid + " WHERE cid=? AND ( date1 IS null OR date1<=? ) AND ( date2 IS NULL OR date2>=? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)time));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)time));
            ResultSet rs = ps.executeQuery();
            result = rs.next();
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public int getCidIsActive(String login, String pswd) throws SQLException {
        int result = -1;
        String tableName = "trayinfo_login_" + this.mid;
        if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            String query = "SELECT cid FROM " + tableName + " WHERE id=? AND pswd=? AND ( date1 IS NULL OR date1<=CURDATE() ) AND ( date2 IS NULL OR date2>=CURDATE())";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, login);
                ps.setString(2, pswd);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
        }
        return result;
    }

    public void updateTrayInfoLogin(int id, String pswd, Date date1, Date date2) throws SQLException {
        String query = "UPDATE trayinfo_login_" + this.mid + " SET pswd=?, date1=?, date2=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, pswd);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date2));
            ps.setInt(4, id);
            ps.executeUpdate();
        }
    }

    public void generateTrayInfoLogin(int type, int cid, String pswd) throws BGException {
        block16: {
            try (BalanceUtils bu = new BalanceUtils(this.con);
                 ContractDao contractDao = new ContractDao(this.con, 0);){
                TrayInfoType typeRef = new TrayInfoTypeManager(this.con, this.mid).getTrayInfoTypeById(type);
                if (typeRef == null) {
                    throw new BGException(" trayinfo login type " + type + " not found!");
                }
                Contract contract = (Contract)contractDao.get(cid);
                BigDecimal balance = bu.getBalance(LocalDate.now(), cid);
                if (typeRef.getCost().compareTo(BigDecimal.ZERO) == 0 || balance.subtract(contract.getBalanceLimit()).compareTo(typeRef.getCost()) > 0) {
                    GregorianCalendar now = new GregorianCalendar();
                    String query = "INSERT INTO trayinfo_login_" + this.mid + " ( type, cid, pswd, date1, date2 ) VALUES ( ?, ?, ?, ?, ? )";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setInt(1, typeRef.getId());
                    ps.setInt(2, cid);
                    ps.setString(3, pswd);
                    ps.setDate(4, TimeUtils.convertCalendarToSqlDate((Calendar)now));
                    if (typeRef.getDays() == 0) {
                        ps.setDate(5, null);
                    } else {
                        ((Calendar)now).add(6, typeRef.getDays());
                        ps.setDate(5, TimeUtils.convertCalendarToSqlDate((Calendar)now));
                    }
                    ps.executeUpdate();
                    ps.close();
                    Charge charge = Charge.builder().setContractId(cid).setDate(new Date()).setUserId(0).setTypeId(typeRef.getChargeType()).setSum(typeRef.getCost()).setComment("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043b\u043e\u0433\u0438\u043d\u0430 TrayInfo [ " + typeRef.getTitle() + " ]").build();
                    new ChargeDao(this.con).update((Object)charge);
                    this.con.commit();
                    bu.updateBalance(charge.getDate(), contract.getId());
                    this.con.commit();
                    EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 4, charge.getSum()));
                    break block16;
                }
                throw new BGMessageException("\u041d\u0435\u0442 \u0434\u0435\u043d\u0435\u0433 \u0434\u043b\u044f \u043f\u0440\u0438\u043e\u0431\u0440\u0435\u0442\u0435\u043d\u0438\u044f \u043b\u043e\u0433\u0438\u043d\u0430!", "trayInfo.activate.balanceError");
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private static void loadLoginFromRS(ResultSet rs, TrayInfoLogin login) throws SQLException {
        login.setLogin(rs.getInt("id"));
        login.setType(rs.getInt("type"));
        login.setContractId(rs.getInt("cid"));
        login.setPassword(rs.getString("pswd"));
        login.setDate1((Date)rs.getDate("date1"));
        login.setDate2((Date)rs.getDate("date2"));
        login.setContractTitle(rs.getString("contract_title"));
        login.setContractComment(rs.getString("contract_comment"));
    }
}

