/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.DlinkGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPMacBinding30xx;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPMacBinding35xx;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPProfile;
import ru.bitel.bgbilling.modules.ipn.server.dlink.IPRule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.MaskAddress;
import ru.bitel.bgbilling.modules.ipn.server.dlink.NeedRule;
import ru.bitel.bgbilling.modules.ipn.server.dlink.NextTaker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;

public class Dlink30xx35xxGateWorker
extends DlinkGateWorker {
    private SnmpContext context30xx;
    private SnmpContext context35xx;
    private int des30xxPorts = 26;
    private PortMask des30xxPortMask;
    private int des30xxPortIn35xx = 10;
    private int des30xxVlan = 1;
    private int des35xxPorts = 26;
    private PortMask des35xxPortMask;
    private int des35xxModel;
    private int des35xxSubModel;
    private int des35xxProfile8pos = 8;
    private int des35xxProfile10pos = 10;
    private int des35xxProfile12pos = 12;
    private List<MaskAddress> openHosts = new ArrayList<MaskAddress>();

    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        int gid = this.gate.getId();
        Gate parentGate = this.gate.getParent();
        if (parentGate == null) {
            this.log.error("Parent gate not defined for " + host);
            return;
        }
        String parentHost = parentGate.getHost();
        int parentPort = parentGate.getPort();
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port + " commutinty " + this.gate.getKeyword());
        }
        try {
            this.context30xx = this.getSnmpContext(this.gate.getGateType(), host, port);
            this.context35xx = this.getSnmpContext(parentGate.getGateType(), parentHost, parentPort);
            this.takeConfig();
            List<UserPortStatus> userList = this.loadUserList();
            this.context = this.context30xx;
            this.portMask = this.des30xxPortMask;
            this.fixMac30xx(userList);
            this.context = this.context35xx;
            this.portMask = this.des35xxPortMask;
            this.loadProfiles();
            this.setDes35Options(userList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setDes35Options(List<UserPortStatus> userList) throws Exception, InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Set 35xx binding..");
        }
        this.fixMac35xx(userList);
        this.log.debug("Set rules..");
        ArrayList<DlinkGateWorker.NeedProfile> needProfiles = new ArrayList<DlinkGateWorker.NeedProfile>();
        NeedRule rule = null;
        for (MaskAddress openHost : this.openHosts) {
            DlinkGateWorker.NeedProfile profile = new DlinkGateWorker.NeedProfile(new IPProfile(this.des35xxModel, openHost.profileId, 2, "00 00 00 00", "FF FF FF FF", 1, "00 00", 1));
            rule = new NeedRule(true, new IPRule(this.des35xxModel, 1, this.des30xxPortIn35xx, 2, "00 00 00 00", openHost.openAddress, 1, 0));
            profile.addRule(rule);
            needProfiles.add(profile);
        }
        DlinkGateWorker.NeedProfile profile8 = new DlinkGateWorker.NeedProfile(new IPProfile(this.des35xxModel, this.des35xxProfile8pos, 1, "00 00 00 00", "00 00 00 00", 2, "FF FF", 5));
        rule = new NeedRule(true, new IPRule(this.des35xxModel, 1, this.des30xxPortIn35xx, 2, "00 00 00 00", "FF FF FF FF", 5, 67));
        profile8.addRule(rule);
        DlinkGateWorker.NeedProfile profile10 = new DlinkGateWorker.NeedProfile(new IPProfile(this.des35xxModel, this.des35xxProfile10pos, 3, "FF FF FF FF", "00 00 00 00", 1, "00 00", 1));
        DlinkGateWorker.NeedProfile profile12 = new DlinkGateWorker.NeedProfile(new IPProfile(this.des35xxModel, this.des35xxProfile12pos, 3, "00 00 00 00", "00 00 00 00", 1, "00 00", 1));
        rule = new NeedRule(true, new IPRule(this.des35xxModel, 1, this.des30xxPortIn35xx, 1, "00 00 00 00", "00 00 00 00", 1, 0));
        profile12.addRule(rule);
        needProfiles.add(profile8);
        needProfiles.add(profile10);
        needProfiles.add(profile12);
        boolean needRule = false;
        for (UserPortStatus userPort : userList) {
            int ruleNumber = this.des30xxPortIn35xx * 1000 + userPort.port;
            needRule = userPort.status.status == 0;
            rule = new NeedRule(needRule, new IPRule(this.des35xxModel, ruleNumber, this.des30xxPortIn35xx, 2, userPort.ipAddr, "00 00 00 00", 1, 0));
            profile10.addRule(rule);
        }
        this.createProfilesAndRules(needProfiles);
    }

    private void fixMac30xx(List<UserPortStatus> userList) throws Exception, InterruptedException {
        HashSet<String> macSet = new HashSet<String>();
        IPMacBinding30xx ipMacBinding = new IPMacBinding30xx(this.des30xxVlan, this.des30xxPortMask, macSet);
        IpMacBindObserver observer = new IpMacBindObserver(ipMacBinding, ipMacBinding.getTopOid());
        this.sendNextPdu(ipMacBinding.getTopOid(), observer);
        this.waitResponse();
        for (UserPortStatus userPort : userList) {
            ipMacBinding.bind(userPort, this);
        }
        this.waitResponse();
    }

    private void fixMac35xx(List<UserPortStatus> userList) throws Exception, InterruptedException {
        HashSet<String> macSet = new HashSet<String>();
        IPMacBinding35xx ipMacBinding = new IPMacBinding35xx(this.des35xxModel, this.des35xxSubModel, this.des35xxPortMask, macSet);
        IpMacBindObserver observer = new IpMacBindObserver(ipMacBinding, ipMacBinding.getTopOid());
        this.sendNextPdu(ipMacBinding.getTopOid(), observer);
        this.waitResponse();
        for (UserPortStatus userPort : userList) {
            ipMacBinding.bind(userPort, this);
        }
        this.waitResponse();
    }

    private void takeConfig() {
        Preferences gateSetup = null;
        gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        this.des30xxPortIn35xx = gateSetup.getInt("uplink", 1);
        this.des30xxPorts = gateSetup.getInt("ports", 4);
        this.des30xxPortMask = new PortMask(Utils.pageCount((int)this.des30xxPorts, (int)8));
        this.des30xxVlan = gateSetup.getInt("vlan", this.des30xxVlan);
        gateSetup = new Preferences(this.gate.getParent().getConfig(), "\r\n");
        this.des35xxPorts = gateSetup.getInt("ports", 4);
        this.des35xxPortMask = new PortMask(Utils.pageCount((int)this.des35xxPorts, (int)8));
        Preferences gateTypeSetup = new Preferences(this.gate.getParent().getGateType().getConfig(), "\r\n");
        this.des35xxModel = gateTypeSetup.getInt("model", this.des35xxModel);
        this.des35xxSubModel = gateTypeSetup.getInt("sub.model", this.des35xxSubModel);
        this.des35xxProfile8pos = gateSetup.getInt("profile.8", gateTypeSetup.getInt("profile.8", this.des35xxProfile8pos));
        this.des35xxProfile10pos = gateSetup.getInt("profile.10", gateTypeSetup.getInt("profile.10", this.des35xxProfile10pos));
        this.des35xxProfile12pos = gateSetup.getInt("profile.12", gateTypeSetup.getInt("profile.12", this.des35xxProfile12pos));
        String openHost = gateSetup.get("open.host", gateTypeSetup.get("open.host", ""));
        StringTokenizer st = new StringTokenizer(openHost, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            String[] data = token.trim().split(":");
            if (data.length != 3) continue;
            MaskAddress maskAddress = new MaskAddress();
            maskAddress.profileId = Utils.parseInt((String)data[0]);
            maskAddress.openMask = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[1])));
            maskAddress.openAddress = Utils.bytesToString((byte[])Utils.convertIntToBytes((int)IPUtils.convertStringIPtoInt((String)data[2])));
            this.openHosts.add(maskAddress);
        }
    }

    class IpMacBindObserver
    extends DlinkGateWorker.NextObserver {
        private NextTaker nextTaker;
        private String topOid;

        public IpMacBindObserver(NextTaker nextTaker, String topOid) {
            this.nextTaker = nextTaker;
            this.topOid = topOid;
        }

        @Override
        protected void processResponse(varbind var) {
            String oid = var.getOid().toString();
            this.nextTaker.takeData(Dlink30xx35xxGateWorker.this.portMask, oid, var);
        }

        @Override
        public String getTopOid() {
            return this.topOid;
        }
    }
}

