/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLink;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLinkManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionGetContractAddress
extends ActionBase {
    public void doAction() throws Exception {
        String id = this.getParameter("id");
        if (id == null || this.mid < 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 id=" + id + "; mid=" + this.mid);
        }
        Element address = this.createElement(this.rootNode, "address");
        address.setAttribute("resource_only", this.moduleSetup.getBoolean("address.resource.only", false) ? "true" : "false");
        int intID = Utils.parseInt((String)id, (int)-1);
        AddressRange ar = new AddressRangeManager(this.con, this.mid).getAddressRange(intID);
        if (ar != null) {
            address.setAttribute("object_id", String.valueOf(ar.getObjectId()));
            address.setAttribute("addr1", String.valueOf(ar.getAddr1()));
            address.setAttribute("addr2", String.valueOf(ar.getAddr2()));
            address.setAttribute("port1", String.valueOf(ar.getPort1()));
            address.setAttribute("port2", String.valueOf(ar.getPort2()));
            address.setAttribute("comment", ar.getComment());
            address.setAttribute("date1", TimeUtils.format((Calendar)ar.getDate1(), (String)"dd.MM.yyyy"));
            address.setAttribute("date2", TimeUtils.format((Calendar)ar.getDate2(), (String)"dd.MM.yyyy"));
            address.setAttribute("plan", String.valueOf(ar.getPlanId()));
            address.setAttribute("mask", String.valueOf(ar.getMask()));
            StringBuffer ifaces = new StringBuffer();
            for (RangeIface rangeIface : new RangeIfaceManager(this.con, this.mid).getAdressRangeIfaces(intID)) {
                if (ifaces.length() != 0) {
                    ifaces.append(",");
                }
                ifaces.append(rangeIface.getSourceId() + "_" + rangeIface.getIfaceId());
            }
            address.setAttribute("ifaces", ifaces.toString());
            Element serviceLink = this.createElement(address, "service_link");
            Element data = this.createElement(serviceLink, "data");
            if (ar.getPersonalPlanId() > 0) {
                List<ServiceLink> linkList = new ServiceLinkManager(this.con, this.mid).getServiceLinkList(ar.getPersonalPlanId(), -1, null);
                this.createServiceLinkTable(data, linkList);
            }
        }
    }
}

