/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.AttributeParams;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.common.XMLUtils;

public final class RadiusAttributes {
    private static RadiusAttributes dictionary;
    private AttributeParams[] attributes = null;
    private HashMap<Integer, RadiusAttributes> vendors = new HashMap();
    private HashMap<String, AttributeParams> attributeMap = null;

    public static void init() {
        dictionary = new RadiusAttributes();
    }

    public static AttributeParams getAttributeParams(int code) {
        return dictionary.getAParams(code);
    }

    public static AttributeParams getVendorAttributeParams(int vendor, int code) {
        return dictionary.getVendorAParams(vendor, code);
    }

    public static AttributeParams findAttribute(String name) {
        return dictionary.findAParams(name);
    }

    private RadiusAttributes() {
        Document doc = this.getDoc();
        if (doc == null) {
            System.err.println("File dictionary.xml wasn't found or not valid!!!");
            System.exit(0);
        } else if (!this.loadDictionary(doc)) {
            System.err.println("Error of dictonary loading!!!");
            System.exit(0);
        }
    }

    private Document getDoc() {
        Document doc = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            File dictionaryFile = new File("conf" + File.separatorChar + "dictionary.xml");
            if (!dictionaryFile.exists()) {
                dictionaryFile = new File("data" + File.separatorChar + "dictionary.xml");
            }
            doc = docBuilder.parse(dictionaryFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    private boolean loadDictionary(Document doc) {
        boolean result = true;
        try {
            int i;
            Element docElement = doc.getDocumentElement();
            Element attributes = (Element)docElement.getElementsByTagName("attributes").item(0);
            NodeList standartAttributes = attributes.getElementsByTagName("attribute");
            this.loadDictionary(standartAttributes, 0);
            Element vendors = (Element)docElement.getElementsByTagName("vendors").item(0);
            NodeList vendorList = vendors.getElementsByTagName("vendor");
            for (int i2 = 0; i2 < vendorList.getLength(); ++i2) {
                Element vendor = (Element)vendorList.item(i2);
                int vendorCode = Integer.parseInt(vendor.getAttribute("code"));
                NodeList vendorAttributes = vendor.getElementsByTagName("attribute");
                RadiusAttributes vendorAttrs = new RadiusAttributes(vendorCode, vendorAttributes);
                this.vendors.put(vendorCode, vendorAttrs);
            }
            Document fakeDoc = XMLUtils.newDocument();
            Element fakeRoot = fakeDoc.createElement("root");
            fakeDoc.appendChild(fakeRoot);
            this.addFakeAttribute(fakeRoot, "string", 1, "BG_BALANCE_MODE");
            this.addFakeAttribute(fakeRoot, "integer", 2, "BG_SESSION_COUNT");
            RadiusAttributes vendorAttrs = new RadiusAttributes(-1, fakeRoot.getElementsByTagName("attribute"));
            this.vendors.put(-1, vendorAttrs);
            this.attributeMap = new HashMap(384);
            Object[] ras = this.vendors.values().toArray();
            for (i = ras.length - 1; i >= 0; --i) {
                RadiusAttributes ra = (RadiusAttributes)ras[i];
                for (int j = ra.attributes.length - 1; j >= 0; --j) {
                    if (ra.attributes[j] == null) continue;
                    this.attributeMap.put(ra.attributes[j].getName().toLowerCase(), ra.attributes[j]);
                }
            }
            for (i = this.attributes.length - 1; i >= 0; --i) {
                if (this.attributes[i] == null) continue;
                this.attributeMap.put(this.attributes[i].getName().toLowerCase(), this.attributes[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    private void addFakeAttribute(Element fakeRoot, String type, int code, String name) {
        Element attribute = XMLUtils.createElement((Element)fakeRoot, (String)"attribute");
        attribute.setAttribute("code", String.valueOf(code));
        attribute.setAttribute("add", "no");
        attribute.setAttribute("name", name);
        attribute.setAttribute("type", type);
    }

    private RadiusAttributes(int vendorCode, NodeList attributes) {
        this.loadDictionary(attributes, vendorCode);
    }

    private void loadDictionary(NodeList list, int vendorCode) {
        this.attributes = new AttributeParams[257];
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            int code = Integer.parseInt(el.getAttribute("code"));
            String name = el.getAttribute("name");
            String type = el.getAttribute("type");
            String add = el.getAttribute("add");
            int tp = 0;
            tp = type.equals("integer") ? 1 : (type.equals("ipaddr") ? 2 : 0);
            this.attributes[code] = new AttributeParams(name, tp, vendorCode, code, add.equals("yes"));
        }
    }

    public AttributeParams getAParams(int code) {
        return this.attributes != null && this.attributes.length > code && code > -1 ? this.attributes[code] : null;
    }

    public AttributeParams getVendorAParams(int vendor_code, int attr_code) {
        AttributeParams attribute = null;
        RadiusAttributes vendor = this.vendors.get(vendor_code);
        if (vendor != null) {
            attribute = vendor.getAParams(attr_code);
        }
        return attribute;
    }

    public AttributeParams findAParams(String name) {
        return this.attributeMap.get(name.toLowerCase());
    }
}

