/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.bean;

import bitel.billing.server.script.bean.FunctionManager;
import bsh.EvalError;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptLibraryManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.logging.BGNestedContext;

@Deprecated
public class ScriptMachineManager
extends BGLogger {
    private static ScriptMachineManager manager;
    private ConcurrentHashMap<String, ScriptInstance> scriptLibraryCache = new ConcurrentHashMap();

    public static ScriptMachineManager getManager() {
        if (manager == null) {
            try {
                manager = new ScriptMachineManager();
            }
            catch (Throwable e) {
                manager = new ScriptMachineManager();
            }
        }
        return manager;
    }

    private ScriptMachineManager() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ScriptFunctionModifiedEvent>(){

                @Override
                public void notify(ScriptFunctionModifiedEvent e, EventListenerContext ctx) {
                    BGNestedContext.push((String)"script");
                    ScriptMachineManager.this.getLogger().info("Script event function  was modified. Flush function cache...");
                    ScriptMachineManager.this.flushCache();
                    BGNestedContext.pop();
                }
            }, ScriptFunctionModifiedEvent.class);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void flushCache() {
        this.scriptLibraryCache.clear();
        FunctionManager.resetFunctionCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptInstance getScriptForLibrary(String name) {
        ScriptInstance result = this.scriptLibraryCache.get(name);
        if (result == null) {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                ScriptInstance newResult = new ScriptInstance(new ScriptLibraryManager(con).getByName(name));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                PrintStream outPrintStream = new PrintStream(out);
                PrintStream errPrintStream = new PrintStream(err);
                newResult.eval(outPrintStream, errPrintStream, null);
                result = this.scriptLibraryCache.putIfAbsent(name, newResult);
                if (result == null) {
                    result = newResult;
                }
            }
            catch (SQLException ex) {
                this.logError("library \"" + name + "\" error", ex);
            }
            catch (EvalError e) {
                this.getLogger().error("library \"" + name + "\" eval error", (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        return result;
    }
}

