/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import java.io.Serializable;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class IpAddr
implements Serializable {
    public long ipAddr;
    public String realm;
    public Date date1;
    public Date date2;

    public IpAddr(long ip, String realm, Date date1, Date date2) {
        this.ipAddr = ip;
        this.realm = realm;
        this.date1 = date1;
        this.date2 = date2;
    }

    public IpAddr() {
        this.ipAddr = 0L;
        this.realm = null;
        this.date1 = null;
        this.date2 = null;
    }

    public IpAddr(String value) throws BGException {
        String[] ip_realm_period = value.split("\\s*:\\s*");
        if (ip_realm_period.length != 3 || Utils.isBlankString((String)ip_realm_period[0]) || Utils.isBlankString((String)ip_realm_period[1]) || Utils.isBlankString((String)ip_realm_period[2])) {
            throw new BGException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441: " + value);
        }
        this.ipAddr = IPUtils.convertStringIPtoLong((String)ip_realm_period[0], (long)0L);
        this.realm = ip_realm_period[1];
        String[] period = ip_realm_period[2].split("\\s*\\-\\s*");
        if (period.length > 0) {
            this.date1 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)period[0], (String)"dd.MM.yyyy"));
        }
        if (period.length > 1) {
            this.date2 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)period[1], (String)"dd.MM.yyyy"));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddr other = (IpAddr)obj;
        if (this.date1 == null ? other.date1 != null : !this.date1.equals(other.date1)) {
            return false;
        }
        if (this.date2 == null ? other.date2 != null : !this.date2.equals(other.date2)) {
            return false;
        }
        if (this.ipAddr != other.ipAddr) {
            return false;
        }
        return !(this.realm == null ? other.realm != null : !this.realm.equals(other.realm));
    }
}

