/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.param.common.service.ContractParameterServiceOld;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class ContactManagerPanel
extends BGUPanel {
    private static final ContactType EMAIL_CONTACT_TYPE = new ContactType();
    private ContactTypeTableModel model;

    protected void jbInit() {
        this.model = new ContactTypeTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).getContactTypes())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ContactTypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", new ContactType()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, ContactTypeEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ContactType current = (ContactType)this.model.getSelectedRow();
            if (current != null) {
                ((DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class)).deleteContactType(current.getId());
                this.performAction("refresh");
            }
        });
    }

    static {
        EMAIL_CONTACT_TYPE.setId(-1);
        EMAIL_CONTACT_TYPE.setPattern("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,4}$");
        EMAIL_CONTACT_TYPE.setTitle("\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430 (e-mail)");
    }

    class ContactTypeTableModel
    extends BGTableModel<ContactType> {
        public ContactTypeTableModel() {
            super(ContactTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 100, 100, 100, "id");
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title");
        }
    }

    public class ContactTypeEditor
    extends BGEditorDialog<ContactType> {
        private static final int EMAIL_ID = 0;
        private static final int USER_ID = 1;
        private BGTextField titleField;
        private BGTextField patternField;
        private BGTextField tooltipField;
        private BGUComboBox<IdTitle> templateBox;
        private BGUComboBox<IdTitle> paramaterBox;

        public ContactTypeEditor(String title, ContactType data) {
            super(title, (Object)data);
            this.titleField = new BGTextField(40);
            this.patternField = new BGTextField(40);
            this.tooltipField = new BGTextField(40);
            this.templateBox = new BGUComboBox();
            this.paramaterBox = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.titleField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.templateBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.patternField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (\u043f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.tooltipField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.paramaterBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.templateBox.addActionListener(e -> this.patternField.setEnabled(this.templateBox.getSelectedItem() == null || ((IdTitle)this.templateBox.getSelectedItem()).getId() != 0));
            ArrayList<IdTitle> parameters = new ArrayList<IdTitle>();
            parameters.add(new IdTitle(-1, "\u041d\u0435\u0442"));
            try {
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)ContactManagerPanel.this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(1));
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)ContactManagerPanel.this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(3));
                parameters.addAll(((ContractParameterServiceOld)((ClientContext)ContactManagerPanel.this.getContext()).getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(9));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.paramaterBox.setData(parameters);
            ArrayList<IdTitle> items = new ArrayList<IdTitle>(2);
            items.add(new IdTitle(1, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439"));
            items.add(new IdTitle(0, "E-mail"));
            this.titleField.setText(((ContactType)this.data).getTitle());
            this.patternField.setText(((ContactType)this.data).getId() > 0 ? ((ContactType)this.data).getPattern() : "^.*$");
            this.tooltipField.setText(((ContactType)this.data).getDescription());
            this.templateBox.setData(items);
            this.templateBox.setSelectedItem((Object)1);
            this.templateBox.setSelectedItem((Object)(EMAIL_CONTACT_TYPE.getPattern().equals(((ContactType)this.data).getPattern()) ? 0 : 1));
            this.paramaterBox.setSelectedItem((Object)(((ContactType)this.data).getId() > 0 ? ((ContactType)this.data).getPid() : -1));
        }

        public boolean doApply() throws Exception {
            ((ContactType)this.data).setTitle(this.titleField.getText());
            ((ContactType)this.data).setPattern(this.templateBox.getSelectedItem() != null && ((IdTitle)this.templateBox.getSelectedItem()).getId() == 0 ? EMAIL_CONTACT_TYPE.getPattern() : this.patternField.getText());
            ((ContactType)this.data).setDescription(this.tooltipField.getText());
            ((ContactType)this.data).setPid(((IdTitle)this.paramaterBox.getSelectedItem()).getId());
            ((DispatchService)((ClientContext)ContactManagerPanel.this.getContext()).getPort(DispatchService.class)).updateContactType((ContactType)this.data);
            ContactManagerPanel.this.performAction("refresh");
            return true;
        }
    }
}

