/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.AddressEditor;
import ru.bitel.bgbilling.modules.ipn.client.AddressMove;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

class ContractAddressesPanel
extends ServicePanel {
    private BGTable tableAddress = new BGTable();
    private AddressEditor addressEditor = null;
    private AddressMove addressMove = new AddressMove();
    private CardLayout cardLayout1 = new CardLayout();
    private JCheckBox dateFilter = new JCheckBox();
    private BGControlPanelDate datePanel = new BGControlPanelDate();
    private JPanel mainPanel = new JPanel();

    public ContractAddressesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.tableAddress.setHeader(this.rb_name, "contract_address");
        this.tableAddress.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ContractAddressesPanel.this.tableAddress_mousePressed(e);
            }
        });
        this.getAddressEditor().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ContractAddressesPanel.this.setData();
            }
        });
        this.datePanel.setLocalDate(LocalDate.now());
        this.cardLayout1.show(this.mainPanel, "table");
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel addressEditorPanel = new JPanel();
        JPanel addressMovePanel = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.mainPanel.setLayout(this.cardLayout1);
        addressEditorPanel.setLayout(new GridBagLayout());
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_01 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_01.addActionListener(e -> this.bGControlPanel_01_actionPerformed(e));
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_02.addActionListener(e -> this.bGControlPanel_02_actionPerformed(e));
        addressMovePanel.setLayout(new GridBagLayout());
        this.dateFilter.setToolTipText("");
        this.dateFilter.setText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442:");
        this.dateFilter.addActionListener(e -> this.setData());
        this.datePanel.setBorder(null);
        JPanel sourcePanel = new JPanel(new GridBagLayout());
        sourcePanel.add((Component)jScrollPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.dateFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        sourcePanel.add((Component)this.datePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)addressEditorPanel, "editor");
        addressEditorPanel.add((Component)((Object)this.getAddressEditor()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressEditorPanel.add((Component)bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)addressMovePanel, "move");
        addressMovePanel.add((Component)((Object)this.addressMove), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressMovePanel.add((Component)bGControlPanel_01, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        jScrollPane1.setViewportView((Component)this.tableAddress);
        this.mainPanel.add((Component)sourcePanel, "table");
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        if (this.getContractId() == -1 || this.getModuleId() == -1) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setContractId(this.getContractId());
        request.setModuleId(this.getModuleId());
        request.setAttribute("object_id", this.objectId);
        this.addParams(request);
        if (this.dateFilter.isSelected()) {
            request.setAttribute("date", this.datePanel.getDateString());
        }
        request.setAction("AddressContractInfo");
        Document doc = this.getDocument(request);
        if (!ClientUtils.checkStatus((Document)doc)) {
            return;
        }
        this.tableAddress.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
    }

    protected void addParams(Request request) {
    }

    public void newItem() {
        this.cardLayout1.show(this.mainPanel, "editor");
        this.getAddressEditor().init(this.getContractId(), this.getModuleId(), this.objectId);
        this.getAddressEditor().setId("new");
        this.getAddressEditor().trySetData();
    }

    public void editItem() {
        String id = ClientUtils.getRowId((BGTable)this.tableAddress, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null);
        if (id != null) {
            this.getAddressEditor().init(this.getContractId(), this.getModuleId(), this.objectId);
            this.getAddressEditor().setId(id);
            this.cardLayout1.show(this.mainPanel, "editor");
            this.getAddressEditor().trySetData();
        }
    }

    private void netMove() {
        String id = ClientUtils.getRowId((BGTable)this.tableAddress, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u044f", null);
        if (id != null) {
            this.addressMove.init(this.module, this.getModuleId());
            this.addressMove.setId(id);
            this.addressMove.setContractId(this.getContractId());
            this.addressMove.setData();
            this.cardLayout1.show(this.mainPanel, "move");
            this.addressMove.setData();
        }
    }

    public void deleteItem() {
        String id = ClientUtils.getRowId((BGTable)this.tableAddress, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteContractAddress");
            request.setAttribute("id", id);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void tableAddress_mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.isAltDown() || e.isShiftDown() || e.isControlDown()) {
                this.netMove();
            } else {
                this.editItem();
            }
        }
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.getAddressEditor().trySetData();
        } else if ("ok".equals(actionCommand)) {
            if (ClientUtils.checkStatus((Document)this.getAddressEditor().buttonOkClick())) {
                this.cardLayout1.show(this.mainPanel, "table");
                this.setData();
            }
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout1.show(this.mainPanel, "table");
        }
    }

    private void bGControlPanel_01_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.getAddressEditor().trySetData();
        } else if ("ok".equals(actionCommand)) {
            if (ClientUtils.checkStatus((Document)this.addressMove.buttonOkClick())) {
                this.cardLayout1.show(this.mainPanel, "table");
                this.setData();
            }
        } else if ("cancel".equals(actionCommand)) {
            this.cardLayout1.show(this.mainPanel, "table");
        } else if ("help".equals(actionCommand)) {
            this.openHelp(AddressEditor.class.getName());
        }
    }

    protected AddressEditor getAddressEditor() {
        if (this.addressEditor == null) {
            this.addressEditor = new AddressEditor();
        }
        return this.addressEditor;
    }
}

