/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.ipn.client.editor.ContractRuleEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class RadiusPPPoEContractRuleEditor
extends ContractRuleEditorPanel {
    private Map<Integer, String> ruleTypes = new HashMap<Integer, String>();
    private BGTextField loginTf = new BGTextField();
    private JPasswordField passwordTf = new JPasswordField();
    private List<String> singleAddressList = new ArrayList<String>();
    private List<String> netList = new ArrayList<String>();
    private BGComboBox<ComboBoxItem> realmCb = new BGComboBox();
    private BGComboBox<ComboBoxItem> ipCb = new BGComboBox();
    private BGComboBox<ComboBoxItem> vrfCb = new BGComboBox();
    private BGControlPanelListSelect netSelect = new BGControlPanelListSelect();
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private BGTable table = new BGTable();
    int currentRow = 0;

    public RadiusPPPoEContractRuleEditor() {
        this.jbInit();
        this.table.setHeader(this.rb_name, this.moduleDoc, "pppoe_realm");
    }

    private void jbInit() {
        this.passwordTf.setMinimumSize(this.loginTf.getMinimumSize());
        this.passwordTf.setPreferredSize(this.loginTf.getPreferredSize());
        this.netSelect.setMinimumSize(new Dimension(0, 200));
        this.netSelect.setBorder((Border)new BGTitleBorder("\u0421\u0435\u0442\u0438"));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEditRealm(e.getActionCommand().equals("ok")));
        this.editPanel.add((Component)new JLabel("\u0420\u0435\u0430\u043b\u043c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.realmCb, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("IP:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.ipCb, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("VRF:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)this.vrfCb, new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)this.netSelect, new GridBagConstraints(1, 0, 1, 7, 0.5, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.editPanel.add((Component)okCancel, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.editPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.editPanel.setVisible(false);
        okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.actionMapper(e.getActionCommand()));
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.editPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.loginTf, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.passwordTf, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(panel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RadiusPPPoEContractRuleEditor.this.currentRow = RadiusPPPoEContractRuleEditor.this.table.getSelectedRow();
                    RadiusPPPoEContractRuleEditor.this.startEditRealm();
                }
            }
        });
    }

    public void setData() throws Exception {
        Request request = new Request().setModule(this.module).setAction("AddressContractInfo").setModuleId(this.getModuleId()).setContractId(this.getContractId()).setAttribute("date", new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            block0: for (Element row : XMLUtils.selectElements((Node)doc.getDocumentElement(), (String)"/data/table/data/row")) {
                String addressRange = row.getAttribute("address_range");
                String[] addresses = addressRange.split("\\s+\\-\\s+");
                if (addresses.length != 2) continue;
                long address1 = IPUtils.convertStringIPtoLong((String)addresses[0].trim(), (long)0L);
                long address2 = IPUtils.convertStringIPtoLong((String)addresses[1].trim(), (long)0L);
                if (addresses[0].trim().equals("0.0.0.0") || addresses[1].trim().equals("255.255.255.255")) continue;
                if (address1 == address2) {
                    this.singleAddressList.add(IPUtils.convertLongIpToString((long)address1));
                    continue;
                }
                int equalPos = 0;
                for (equalPos = 0; equalPos < 32; ++equalPos) {
                    boolean eq;
                    int offset = 31 - equalPos;
                    boolean bl = eq = (address1 & (long)(1 << offset)) == (address2 & (long)(1 << offset));
                    if (!eq) break;
                }
                if (equalPos <= 0) continue;
                int pos = 0;
                for (pos = equalPos; pos < 32; ++pos) {
                    int offset = 31 - pos;
                    if ((address1 >> offset & 1L) != 0L || (address2 >> offset & 1L) == 0L) continue block0;
                }
                StringBuilder net = new StringBuilder(50);
                net.append(IPUtils.convertLongIpToString((long)address1));
                net.append(' ');
                net.append(IPUtils.convertLongIpToString((long)(0xFFFFFFFFL << 32 - equalPos & 0xFFFFFFFFL)));
                String temp = net.toString();
                this.netList.add(temp);
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("RuleTypeList");
            request.setModuleId(this.getModuleId());
            request.setAttribute("gtid", this.gateTypeId);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                NodeList nodeList = doc.getElementsByTagName("item");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element item = (Element)nodeList.item(i);
                    int id = Utils.parseInt((String)item.getAttribute("id"));
                    String title = item.getAttribute("title");
                    this.ruleTypes.put(id, title);
                }
            }
            request = new Request();
            request.setModule(this.module);
            request.setAction("RadiusPPPoEVRFList");
            request.setModuleId(this.getModuleId());
            request.setAttribute("gtid", this.gateTypeId);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildComboBox(this.vrfCb, (Node)XMLUtils.getNode((Document)doc, (String)"list"), null);
            }
            this.vrfCb.insertItemAt((Object)new ComboBoxItem((Object)"-1", "-"), 0);
            if (!"0".equals(this.id)) {
                request = new Request();
                request.setModule(this.module);
                request.setAction("RadiusPPPoEGetContractRule");
                request.setModuleId(this.getModuleId());
                request.setAttribute("id", this.id);
                request.setAttribute("gtid", this.gateTypeId);
                doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    Element tableEl = XMLUtils.getElement((Document)doc, (String)"table");
                    this.table.updateData((Node)tableEl);
                    this.loginTf.setText(tableEl.getAttribute("login"));
                    this.passwordTf.setText(tableEl.getAttribute("pswd"));
                }
            }
        }
    }

    private String serializeTableData() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            result.append(this.table.getColumnValueString(i, "ID"));
            result.append(";");
            result.append(this.table.getColumnValueString(i, "vrfID"));
            result.append(";");
            result.append(this.table.getColumnValueString(i, "address"));
            result.append(";");
            StringBuilder netList = new StringBuilder();
            for (String _net : Utils.toList((String)this.table.getColumnValueString(i, "net_list"))) {
                netList.append(_net);
                netList.append(',');
            }
            if (netList.length() > 0) {
                netList.setLength(netList.length() - 1);
            }
            result.append((CharSequence)netList);
            result.append("\t\t");
        }
        result.setLength(result.length() - 2);
        return result.toString();
    }

    private void startEditRealm() {
        ((DefaultComboBoxModel)this.ipCb.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.realmCb.getModel()).removeAllElements();
        DefaultListModel model = (DefaultListModel)this.netSelect.getList().getModel();
        model.removeAllElements();
        ArrayList<String> temp = new ArrayList<String>();
        ArrayList<String> tempNetList = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (i == this.currentRow) continue;
            temp.add(this.table.getRowId(i, "address"));
            for (String net : this.table.getRowId(i, "net_list").split("\\s*,\\s*")) {
                tempNetList.add(net);
            }
        }
        block2: for (String ip : this.singleAddressList) {
            for (String t : temp) {
                if (!t.equals(ip)) continue;
                continue block2;
            }
            ((DefaultComboBoxModel)this.ipCb.getModel()).addElement(new ComboBoxItem((Object)ip, ip));
        }
        ArrayList<Integer> temp2 = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (i == this.currentRow) continue;
            temp2.add(Utils.parseInt((String)this.table.getRowId(i, "ID")));
        }
        block5: for (Integer id : this.ruleTypes.keySet()) {
            for (Integer id2 : temp2) {
                if (!id2.equals(id)) continue;
                continue block5;
            }
            ((DefaultComboBoxModel)this.realmCb.getModel()).addElement(new ComboBoxItem((Object)String.valueOf(id), this.ruleTypes.get(id)));
        }
        block7: for (String net : this.netList) {
            for (String net2 : tempNetList) {
                if (!net.equals(net2)) continue;
                continue block7;
            }
            BGUListItem item = new BGUListItem(0, net);
            item.setAttribute("id", (Object)net);
            model.addElement(item);
        }
        this.vrfCb.setSelectedIndex(0);
        if (this.currentRow >= 0) {
            ClientUtils.setComboBoxSelection(this.ipCb, (Object)this.table.getColumnValueString(this.currentRow, "address"));
            ClientUtils.setComboBoxSelection(this.realmCb, (Object)this.table.getColumnValueString(this.currentRow, "ID"));
            ClientUtils.setComboBoxSelection(this.vrfCb, (Object)this.table.getColumnValueString(this.currentRow, "vrfID"));
            this.netSelect.setListValues(this.table.getColumnValueString(this.currentRow, "net_list"));
        } else {
            for (int i = 0; i < model.getSize(); ++i) {
                ((BGUListItem)model.getElementAt(i)).setSelected(false);
            }
        }
        this.editPanel.setVisible(true);
    }

    private void stopEditRealm(boolean save) {
        if (save) {
            ComboBoxItem item = (ComboBoxItem)this.ipCb.getSelectedItem();
            if (item == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c ip-\u0430\u0434\u0440\u0435\u0441");
                return;
            }
            String ip = (String)item.getObject();
            String nets = this.netSelect.getListValues().trim();
            item = (ComboBoxItem)this.realmCb.getSelectedItem();
            if (item == null) {
                return;
            }
            String ruleTypeId = (String)item.getObject();
            String ruleTitle = item.toString();
            item = (ComboBoxItem)this.vrfCb.getSelectedItem();
            if (item == null) {
                return;
            }
            String vrfID = (String)item.getObject();
            String vrfTitle = item.toString();
            if (this.currentRow == -1) {
                Vector<String> vector = new Vector<String>();
                vector.add(ruleTypeId);
                vector.add(ruleTitle);
                vector.add(vrfID);
                vector.add(vrfTitle);
                vector.add(ip);
                vector.add(nets);
                ((DefaultTableModel)this.table.getModel()).addRow(vector);
            } else {
                this.table.setValueAt((Object)ruleTypeId, this.currentRow, 0);
                this.table.setValueAt((Object)ruleTitle, this.currentRow, 1);
                this.table.setValueAt((Object)vrfID, this.currentRow, 2);
                this.table.setValueAt((Object)vrfTitle, this.currentRow, 3);
                this.table.setValueAt((Object)ip, this.currentRow, 4);
                this.table.setValueAt((Object)nets, this.currentRow, 5);
            }
        }
        this.editPanel.setVisible(false);
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (this.table.getRowCount() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u0440\u0435\u0430\u043b\u043c!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("RadiusPPPoEUpdateContractRule");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.id);
            request.setContractId(this.getContractId());
            request.setAttribute("fwid", this.gateId);
            request.setAttribute("rtid", "0");
            request.setAttribute("rule", this.serializeTableData());
            request.setAttribute("login", this.loginTf.getText());
            request.setAttribute("pswd", new String(this.passwordTf.getPassword()));
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.contractGates.showGates();
            }
        } else {
            this.contractGates.showGates();
        }
    }

    public void deleteItem() {
        this.currentRow = this.table.getSelectedRow();
        if (this.currentRow == -1) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0430\u043b\u043c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            ((DefaultTableModel)this.table.getModel()).removeRow(this.currentRow);
        }
    }

    private void actionMapper(String command) {
        if (command.compareTo("newItem") == 0) {
            this.currentRow = -1;
            this.startEditRealm();
        } else if (command.compareTo("editItem") == 0) {
            this.currentRow = this.table.getSelectedRow();
            if (this.currentRow == -1) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            } else {
                this.startEditRealm();
            }
        } else if (command.compareTo("deleteItem") == 0) {
            this.deleteItem();
        } else if (command.compareTo("refresh") == 0) {
            this.trySetData();
        }
    }
}

