/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.logon;

import bitel.billing.server.contract.logon.ContractLogonLast;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.server.util.Setup;

public class ContractLogonLockCache {
    private int logonCounterMax;
    private int logonTimeoutLock;
    private int logonTimeoutPeriod;
    private int contractLogonLockCacheSize;
    private int contractLogonLockCacheExpired;
    private Setup setup = null;
    private String logonTimeoutAction = null;
    private Map<String, CacheItem> cacheMap = new ConcurrentHashMap<String, CacheItem>();

    public ContractLogonLockCache() {
        this.setup = Setup.getSetup();
        this.logonCounterMax = this.setup.getInt("logon.counter.max", Integer.MAX_VALUE);
        this.logonTimeoutLock = this.setup.getInt("logon.timeout.lock", 21600);
        this.logonTimeoutPeriod = this.setup.getInt("logon.timeout.period", 0);
        this.contractLogonLockCacheSize = this.setup.getInt("logon.lock.cache.size", 100);
        this.contractLogonLockCacheExpired = this.setup.getInt("logon.lock.cache.expired", 600);
        this.logonTimeoutAction = this.setup.get("logon.timeout.action", "+");
    }

    public Date checkLogonLock(String userName) {
        CacheItem cacheItem;
        Date date = null;
        if (userName != null && (cacheItem = this.cacheMap.get(userName)) != null && (date = this.checkLogonLock(cacheItem)) == null) {
            this.cacheMap.remove(userName);
        }
        return date;
    }

    public void updateLogonLock(int contractId, String userName) {
        if (userName == null) {
            return;
        }
        ContractLogonLast contractLogonLast = this.getContractLogonLast(contractId);
        if (contractLogonLast == null || contractLogonLast.getCounter() == 0) {
            this.cacheMap.remove(userName);
            return;
        }
        CacheItem cacheItem = this.cacheMap.getOrDefault(userName, new CacheItem());
        cacheItem.expireTime = System.currentTimeMillis() + (long)(this.contractLogonLockCacheExpired * 1000);
        cacheItem.count = contractLogonLast.getCounter();
        cacheItem.lastLogonTime = contractLogonLast.getDateTime().getTime();
        cacheItem.userName = userName;
        if (this.checkLogonLock(cacheItem) == null) {
            this.cacheMap.remove(userName);
            return;
        }
        if (this.cacheMap.size() > this.contractLogonLockCacheSize) {
            ArrayList<CacheItem> list = new ArrayList<CacheItem>(this.cacheMap.values());
            Collections.sort(list);
            while (this.cacheMap.size() > this.contractLogonLockCacheSize) {
                this.cacheMap.remove(((CacheItem)list.get((int)0)).userName);
            }
        }
        this.cacheMap.put(userName, cacheItem);
    }

    private Date checkLogonLock(CacheItem cacheItem) {
        Date date = null;
        long now = System.currentTimeMillis();
        date = cacheItem.count < this.logonCounterMax ? (this.logonTimeoutAction.equals("^") ? this.checkLogonLock(cacheItem.lastLogonTime + (long)Math.pow((long)this.logonTimeoutPeriod * 1000L, cacheItem.count), now) : this.checkLogonLock(cacheItem.lastLogonTime + (long)(this.logonTimeoutPeriod * cacheItem.count) * 1000L, now)) : this.checkLogonLock(cacheItem.lastLogonTime + (long)this.logonTimeoutLock * 1000L, now);
        if (date != null && this.checkLogonLock(cacheItem.expireTime, now) == null) {
            date = null;
        }
        return date;
    }

    private Date checkLogonLock(long time, long now) {
        return time > now ? new Date(time) : null;
    }

    private ContractLogonLast getContractLogonLast(int contractId) {
        ContractLogonLast contractLogonLast = null;
        if (contractId > 0) {
            try (Connection con = this.setup.getDBConnectionFromPool();
                 PreparedStatement ps = con.prepareStatement("SELECT * FROM contract_logon_last WHERE cid=?");){
                ps.setInt(1, contractId);
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        contractLogonLast = new ContractLogonLast();
                        contractLogonLast.setContractId(contractId);
                        contractLogonLast.setDateTime(resultSet.getTimestamp("dt"));
                        contractLogonLast.setCounter(resultSet.getInt("n"));
                        contractLogonLast.setRemoteIP(resultSet.getString("ip"));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return contractLogonLast;
    }

    class CacheItem
    implements Comparable<CacheItem> {
        public int count = 0;
        public long expireTime = 0L;
        public long lastLogonTime = 0L;
        public String userName = null;

        CacheItem() {
        }

        @Override
        public int compareTo(CacheItem o) {
            return Long.compare(this.expireTime, o.expireTime);
        }
    }
}

