/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.beans.ConstructorProperties;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.processor.DatagramListener;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorListener;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Idable;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerTask;

public class DhcpListener
extends DatagramListener
implements ProcessorListener,
CommandListener {
    private static final Logger logger = LogManager.getLogger();
    protected final DhcpProcessor<Idable> processor;
    protected final DhcpHourlyDataLogger dataLogger;
    private final Setup setup;
    private final boolean fallbackPool;
    private final ThreadPoolExecutor fallbackExecutorService;

    @ConstructorProperties(value={"host", "port", "recvBufferSize", "processor", "dataLogger", "threadCount", "maxQueueSize", "fallbackPool"})
    public DhcpListener(String host, int port, int byteBufferCapacity, DhcpProcessor<Idable> processor, DhcpHourlyDataLogger dataLogger, int threadCount, int maxQueueSize, Boolean fallbackPool) {
        super(host, port, byteBufferCapacity, threadCount, maxQueueSize, processor, "dhcpLstnr", "dhcp");
        this.processor = processor;
        this.dataLogger = dataLogger;
        this.setup = Setup.getSetup();
        if (fallbackPool == null) {
            fallbackPool = Boolean.FALSE;
        }
        this.fallbackPool = fallbackPool;
        this.fallbackExecutorService = this.fallbackPool ? (ThreadPoolExecutor)WorkerTask.newFixedThreadPool("dhcpLstnrExtr", "dhcp", this, threadCount) : null;
    }

    @Override
    public ThreadContext newThreadContext() {
        return new DhcpListenerWorkerContext(this.setup, this.processor.mid, this, this.processor, this.dataLogger);
    }

    @Override
    public ProcessorRequest<?> newRequest(SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        return new DhcpListenerWorker<Idable>(this, this.processor, clientAddress, millis, data, overloadLevel);
    }

    @Override
    public String getCommandsHelp() {
        return null;
    }

    @Override
    public String executeCommand(String cmd, String param) {
        if ("status".equals(cmd)) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("DhcpListener:\n");
                sb.append("  dhcp-requests per minute (1m/10m/1h): ").append(String.format(Locale.ENGLISH, "%.2f", (double)this.getLastMinuteCount())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getLastTenMinutesAverage())).append('/').append(String.format(Locale.ENGLISH, "%.2f", this.getLastHourAverage())).append('\n');
                return sb.toString();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public boolean fallback(SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        int overloadLevel2;
        if (!this.fallbackPool) {
            return false;
        }
        int size = this.fallbackExecutorService.getQueue().size();
        if (size > this.slow1QueueSize) {
            overloadLevel2 = 11;
            if (size > this.maxQueueSize) {
                this.fallbackExecutorService.getQueue().poll();
                if (size > this.rejectQueueSize) {
                    return true;
                }
            }
        } else {
            overloadLevel2 = 10;
        }
        this.fallbackExecutorService.execute(new DhcpListenerWorker<Idable>(this, this.processor, clientAddress, millis, data, overloadLevel2));
        return true;
    }
}

