/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.action;

import bitel.billing.server.ActionBase;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionGetModulesAndServicesTree
extends ActionBase {
    public void doAction() throws Exception {
        String folders = this.getParameter("nodeContent", "");
        if (Utils.notBlankString((String)folders)) {
            HashMap<Integer, Element> serviceSetMap = new HashMap<Integer, Element>();
            Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(folders)));
            Element rootElement = XMLUtils.selectElement((Node)doc, (String)"//module");
            NodeList nodeList = rootElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element item;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(item = (Element)node).getNodeName().equals("service_set")) continue;
                serviceSetMap.put(Utils.parseInteger((String)item.getAttribute("mid"), (Integer)0), item);
            }
            Element modulesElement = this.createElement(this.rootNode, "modules");
            ModuleCache cache = ModuleCache.getInstance();
            List moduleList = cache.getModulesList();
            for (BGModule module : moduleList) {
                HashMap<Integer, Service> moduleServices = new HashMap<Integer, Service>();
                for (Service s : cache.getModuleServicesList(module.getId())) {
                    moduleServices.put(s.getId(), s);
                }
                if (moduleServices.size() <= 0) continue;
                Element currentModule = this.createElement(modulesElement, "module");
                currentModule.setAttribute("id", String.valueOf(module.getId()));
                currentModule.setAttribute("type", "1");
                currentModule.setAttribute("title", module.getTitle());
                Element serviceSetElement = (Element)serviceSetMap.get(module.getId());
                if (serviceSetElement != null) {
                    nodeList = serviceSetElement.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element nodeElement = (Element)nodeList.item(i);
                        Element folderElement = this.createElement(currentModule, "folder");
                        folderElement.setAttribute("type", "1");
                        folderElement.setAttribute("title", nodeElement.getAttribute("title"));
                        this.addElements(moduleServices, nodeElement, folderElement);
                    }
                    continue;
                }
                ArrayList serviceList = new ArrayList(moduleServices.values());
                Collections.sort(serviceList, new Comparator<Service>(){

                    @Override
                    public int compare(Service o1, Service o2) {
                        return o1.getTitle().compareTo(o2.getTitle());
                    }
                });
                for (Service s : serviceList) {
                    this.addService(s, currentModule);
                }
            }
        }
    }

    private void addElements(Map<Integer, Service> moduleServices, Element xmlFolderElement, Element folderElement) {
        String values = xmlFolderElement.getAttribute("items");
        if (Utils.notBlankString((String)values)) {
            if (values.equals("other")) {
                this.addServiceElement(moduleServices, folderElement);
                moduleServices.clear();
            } else {
                String[] split;
                for (String s : split = values.split(",")) {
                    Service service = moduleServices.remove(Utils.parseInt((String)s));
                    if (service == null) continue;
                    this.addService(service, folderElement);
                }
            }
        } else {
            NodeList nodeList = xmlFolderElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element elementNode = (Element)node;
                Element root4nextLevelFolder = this.createElement(folderElement, "folder");
                root4nextLevelFolder.setAttribute("type", "1");
                root4nextLevelFolder.setAttribute("title", elementNode.getAttribute("title"));
                this.addElements(moduleServices, elementNode, root4nextLevelFolder);
            }
        }
    }

    private void addServiceElement(Map<Integer, Service> services, Element resultElement) {
        ArrayList<Service> serviceList = new ArrayList<Service>(services.values());
        Collections.sort(serviceList, new Comparator<Service>(){

            @Override
            public int compare(Service o1, Service o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        for (Service s : serviceList) {
            this.addService(s, resultElement);
        }
    }

    private void addService(Service service, Element element) {
        Element serviceElement = this.createElement(element, "service");
        serviceElement.setAttribute("id", String.valueOf(service.getId()));
        serviceElement.setAttribute("title", service.getTitle());
    }
}

