/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.event.worker;

import java.math.BigDecimal;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.assist.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.assist.server.event.AssistAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class AssistAutopaymentEventWorker
extends EventWorker {
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ContractDao contractDao;

    public AssistAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), AssistAutopaymentEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting AssistAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "assist-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.contractDao.close();
            this.contractDao = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        AssistAutopaymentEvent event = (AssistAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        try {
            Contract contract;
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = (Contract)this.contractDao.get(contractId)) != null) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                this.transactionManager.registerOrder(contractId, sum, dataMap, true, true);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

